/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms.plsql;

import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleStruct;
import oracle.jms.plsql.ExceptionHandler;
import oracle.jms.plsql.MapMsgEntity;
import oracle.jms.plsql.MsgStore;
import oracle.jms.plsql.ResourceMgr;
import oracle.jms.plsql.TypeConversion;
import oracle.sql.NUMBER;

public class MapMsgHandler {
    private static MsgStore msgStore = new MsgStore(3);

    public static int prepare(int id, int[] new_id, byte[] bytes_raw, OracleBlob bytes_lob) {
        try {
            byte[] data = null;
            if (bytes_raw != null) {
                data = bytes_raw;
            } else if (bytes_lob != null) {
                data = bytes_lob.getBytes(1L, (int)bytes_lob.length());
            }
            new_id[0] = id < 0 ? msgStore.createMsgEntity(data) : msgStore.createMsgEntity(id, data);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int clear_body(int id, int[] new_id) {
        try {
            new_id[0] = id < 0 ? msgStore.createMsgEntity() : msgStore.createMsgEntity(id);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int flush(int id, int[] bytes_len, byte[][] bytes_raw, OracleBlob[] bytes_blob) {
        try {
            MapMsgEntity entity = (MapMsgEntity)msgStore.getMsgEntity(id);
            byte[] data = entity.flush();
            bytes_len[0] = data.length;
            if (data.length > 2000) {
                if (bytes_blob[0] == null) {
                    bytes_blob[0] = (OracleBlob)ResourceMgr.getConnection().createBlob();
                } else {
                    bytes_blob[0].truncate(0L);
                }
                bytes_blob[0].setBytes(1L, data);
            } else {
                bytes_raw[0] = data;
            }
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int clean(int id) {
        try {
            msgStore.cleanMsgEntity(id);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int clean_all() {
        try {
            msgStore.cleanAllMsgEntity();
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int get_size(int id, int[] value) {
        try {
            MapMsgEntity entity = (MapMsgEntity)msgStore.getMsgEntity(id);
            value[0] = entity.size();
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int get_names(int id, OracleArray[] value) {
        try {
            MapMsgEntity entity = (MapMsgEntity)msgStore.getMsgEntity(id);
            String[] names = entity.getNames();
            value[0] = TypeConversion.arrayToARRAY(names);
            return 0;
        }
        catch (Throwable t) {
            try {
                value[0] = TypeConversion.getNullARRAY();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int get_names(int id, OracleArray[] value, int offset, int length, int[] retrieved) {
        try {
            MapMsgEntity entity = (MapMsgEntity)msgStore.getMsgEntity(id);
            String[] names = entity.getNames(offset, length, retrieved);
            value[0] = TypeConversion.arrayToARRAY(names);
            return 0;
        }
        catch (Throwable t) {
            try {
                retrieved[0] = 0;
                value[0] = TypeConversion.getNullARRAY();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int item_exists(int id, String name, NUMBER[] value) {
        try {
            MapMsgEntity entity = (MapMsgEntity)msgStore.getMsgEntity(id);
            value[0] = new NUMBER(entity.itemExists(name));
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int get_object(int id, String name, OracleStruct[] value, int[] nullInd) {
        try {
            MapMsgEntity entity = (MapMsgEntity)msgStore.getMsgEntity(id);
            Object objValue = entity.get(name);
            TypeConversion.objToJmsValue(objValue, value, nullInd);
            return 0;
        }
        catch (Throwable t) {
            try {
                nullInd[0] = 1;
                value[0] = TypeConversion.getNullSTRUCT();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int get_number(int id, String name, NUMBER[] value, int type) {
        try {
            MapMsgEntity entity = (MapMsgEntity)msgStore.getMsgEntity(id);
            Object objValue = entity.get(name, type);
            value[0] = TypeConversion.objToNumber(objValue, type);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int get_bytes(int id, String name, OracleBlob[] value) {
        try {
            MapMsgEntity entity = (MapMsgEntity)msgStore.getMsgEntity(id);
            Object objValue = entity.get(name, 9);
            if (objValue == null) {
                value[0] = null;
                return 0;
            }
            byte[] data = (byte[])objValue;
            if (value[0] == null) {
                value[0] = (OracleBlob)ResourceMgr.getConnection().createBlob();
            } else {
                value[0].truncate(0L);
            }
            value[0].setBytes(1L, data);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int get_char(int id, String name, String[] value) {
        try {
            MapMsgEntity entity = (MapMsgEntity)msgStore.getMsgEntity(id);
            Object objValue = entity.get(name, 7);
            if (objValue == null) {
                value[0] = null;
                return 0;
            }
            value[0] = ((Character)objValue).toString();
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int get_string(int id, String name, OracleClob[] value) {
        try {
            MapMsgEntity entity = (MapMsgEntity)msgStore.getMsgEntity(id);
            Object objValue = entity.get(name, 8);
            if (objValue == null) {
                value[0] = null;
                return 0;
            }
            String data = (String)objValue;
            if (value[0] == null) {
                value[0] = (OracleClob)ResourceMgr.getConnection().createClob();
            } else {
                value[0].truncate(0L);
            }
            value[0].setString(1L, data);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int set_number(int id, String name, NUMBER value, int type) {
        try {
            MapMsgEntity entity = (MapMsgEntity)msgStore.getMsgEntity(id);
            entity.set(name, TypeConversion.numberToObj(value, type));
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int set_bytes(int id, String name, byte[] value, int offset, int length) {
        try {
            if (value == null) {
                return 0;
            }
            MapMsgEntity entity = (MapMsgEntity)msgStore.getMsgEntity(id);
            if (offset == 0 && length == value.length) {
                entity.set(name, value);
            } else {
                byte[] new_value = new byte[length];
                System.arraycopy(value, offset, new_value, 0, length);
                entity.set(name, new_value);
            }
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int set_bytes(int id, String name, OracleBlob value, int offset, int length) {
        try {
            if (value == null) {
                return 0;
            }
            MapMsgEntity entity = (MapMsgEntity)msgStore.getMsgEntity(id);
            if ((long)(offset + length) > value.length()) {
                throw new IndexOutOfBoundsException();
            }
            byte[] data = value.getBytes((long)(offset + 1), length);
            entity.set(name, data);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int set_char(int id, String name, String value) {
        try {
            if (value != null && value.length() > 0) {
                MapMsgEntity entity = (MapMsgEntity)msgStore.getMsgEntity(id);
                entity.set(name, new Character(value.charAt(0)));
            }
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int set_string(int id, String name, String value) {
        try {
            if (value == null) {
                return 0;
            }
            MapMsgEntity entity = (MapMsgEntity)msgStore.getMsgEntity(id);
            entity.set(name, value);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int set_string(int id, String name, OracleClob value) {
        try {
            if (value == null) {
                return 0;
            }
            MapMsgEntity entity = (MapMsgEntity)msgStore.getMsgEntity(id);
            entity.set(name, value.getSubString(1L, (int)value.length()));
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }
}

