/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms.plsql;

import java.io.EOFException;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jms.plsql.BytesMsgEntity;
import oracle.jms.plsql.ExceptionHandler;
import oracle.jms.plsql.InternalException;
import oracle.jms.plsql.MsgStore;
import oracle.jms.plsql.ResourceMgr;
import oracle.sql.NUMBER;

public class BytesMsgHandler {
    private static MsgStore msgStore = new MsgStore(1);

    public static int prepare(int id, int[] new_id, byte[] bytes_raw, OracleBlob bytes_lob) {
        try {
            byte[] data = null;
            if (bytes_raw != null) {
                data = bytes_raw;
            } else if (bytes_lob != null) {
                data = bytes_lob.getBytes(1L, (int)bytes_lob.length());
            }
            new_id[0] = id < 0 ? msgStore.createMsgEntity(data) : msgStore.createMsgEntity(id, data);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int clear_body(int id, int[] new_id) {
        try {
            new_id[0] = id < 0 ? msgStore.createMsgEntity() : msgStore.createMsgEntity(id);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int get_mode(int id, int[] mode) {
        try {
            BytesMsgEntity entity = (BytesMsgEntity)msgStore.getMsgEntity(id);
            mode[0] = entity.getMode();
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int reset(int id) {
        try {
            BytesMsgEntity entity = (BytesMsgEntity)msgStore.getMsgEntity(id);
            entity.reset();
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int flush(int id, int[] bytes_len, byte[][] bytes_raw, OracleBlob[] bytes_blob) {
        try {
            BytesMsgEntity entity = (BytesMsgEntity)msgStore.getMsgEntity(id);
            byte[] data = entity.flush();
            bytes_len[0] = data.length;
            if (data.length > 2000) {
                if (bytes_blob[0] == null) {
                    bytes_blob[0] = (OracleBlob)ResourceMgr.getConnection().createBlob();
                } else {
                    bytes_blob[0].truncate(0L);
                }
                bytes_blob[0].setBytes(1L, data);
            } else {
                bytes_raw[0] = data;
            }
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int clean(int id) {
        try {
            msgStore.cleanMsgEntity(id);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int clean_all() {
        try {
            msgStore.cleanAllMsgEntity();
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int read_number(int id, NUMBER[] value, int type) {
        try {
            BytesMsgEntity entity = (BytesMsgEntity)msgStore.getMsgEntity(id);
            switch (type) {
                case 0: {
                    value[0] = new NUMBER(entity.readByte());
                    break;
                }
                case 1: {
                    value[0] = new NUMBER(entity.readShort());
                    break;
                }
                case 2: {
                    value[0] = new NUMBER(entity.readInt());
                    break;
                }
                case 3: {
                    value[0] = new NUMBER(entity.readLong());
                    break;
                }
                case 4: {
                    value[0] = new NUMBER(entity.readFloat());
                    break;
                }
                case 5: {
                    value[0] = new NUMBER(entity.readDouble());
                    break;
                }
                case 6: {
                    value[0] = new NUMBER(entity.readBoolean());
                    break;
                }
                case 10: {
                    value[0] = new NUMBER(entity.readUnsignedByte());
                    break;
                }
                case 11: {
                    value[0] = new NUMBER(entity.readUnsignedShort());
                    break;
                }
                default: {
                    throw new InternalException();
                }
            }
            return 0;
        }
        catch (EOFException eofe) {
            value[0] = null;
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int read_bytes(int id, OracleBlob[] value, int length, int[] readLen) {
        try {
            BytesMsgEntity entity = (BytesMsgEntity)msgStore.getMsgEntity(id);
            byte[] data = new byte[length];
            readLen[0] = entity.readBytes(data);
            if (readLen[0] == -1) {
                value[0] = null;
            } else {
                if (value[0] == null) {
                    value[0] = (OracleBlob)ResourceMgr.getConnection().createBlob();
                } else {
                    value[0].truncate(0L);
                }
                value[0].setBytes(1L, data);
            }
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int read_char(int id, String[] value) {
        try {
            BytesMsgEntity entity = (BytesMsgEntity)msgStore.getMsgEntity(id);
            value[0] = String.valueOf(entity.readChar());
            return 0;
        }
        catch (EOFException eofe) {
            value[0] = null;
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int read_utf(int id, OracleClob[] value) {
        try {
            BytesMsgEntity entity = (BytesMsgEntity)msgStore.getMsgEntity(id);
            String data = entity.readUTF();
            if (data == null) {
                value[0] = null;
                return 0;
            }
            if (value[0] == null) {
                value[0] = (OracleClob)ResourceMgr.getConnection().createClob();
            } else {
                value[0].truncate(0L);
            }
            value[0].setString(1L, data);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int write_number(int id, NUMBER value, int type) {
        try {
            BytesMsgEntity entity = (BytesMsgEntity)msgStore.getMsgEntity(id);
            switch (type) {
                case 0: {
                    entity.writeByte(value.byteValue());
                    break;
                }
                case 1: {
                    entity.writeShort(value.shortValue());
                    break;
                }
                case 2: {
                    entity.writeInt(value.intValue());
                    break;
                }
                case 3: {
                    entity.writeLong(value.longValue());
                    break;
                }
                case 4: {
                    entity.writeFloat(value.floatValue());
                    break;
                }
                case 5: {
                    entity.writeDouble(value.doubleValue());
                    break;
                }
                case 6: {
                    entity.writeBoolean(value.booleanValue());
                    break;
                }
                default: {
                    throw new InternalException();
                }
            }
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int write_bytes(int id, byte[] value, int offset, int length) {
        try {
            if (value == null) {
                return 0;
            }
            BytesMsgEntity entity = (BytesMsgEntity)msgStore.getMsgEntity(id);
            entity.writeBytes(value, offset, length);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int write_bytes(int id, OracleBlob value, int offset, int length) {
        try {
            if (value == null) {
                return 0;
            }
            BytesMsgEntity entity = (BytesMsgEntity)msgStore.getMsgEntity(id);
            if ((long)(offset + length) > value.length()) {
                throw new IndexOutOfBoundsException();
            }
            byte[] data = value.getBytes((long)(offset + 1), length);
            entity.writeBytes(data, 0, length);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int write_char(int id, String value) {
        try {
            if (value != null && value.length() > 0) {
                BytesMsgEntity entity = (BytesMsgEntity)msgStore.getMsgEntity(id);
                entity.writeChar(value.charAt(0));
            }
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int write_utf(int id, String value) {
        try {
            if (value == null) {
                return 0;
            }
            BytesMsgEntity entity = (BytesMsgEntity)msgStore.getMsgEntity(id);
            entity.writeUTF(value);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int write_utf(int id, OracleClob value) {
        try {
            if (value == null) {
                return 0;
            }
            BytesMsgEntity entity = (BytesMsgEntity)msgStore.getMsgEntity(id);
            entity.writeUTF(value.getSubString(1L, (int)value.length()));
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }
}

