/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.rmi.server.UID;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import javax.jms.Connection;
import javax.jms.IllegalStateException;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidClientIDRuntimeException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidDestinationRuntimeException;
import javax.jms.InvalidSelectorException;
import javax.jms.InvalidSelectorRuntimeException;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.JMSSecurityException;
import javax.jms.JMSSecurityRuntimeException;
import javax.jms.MessageConsumer;
import javax.jms.MessageFormatException;
import javax.jms.MessageFormatRuntimeException;
import javax.jms.MessageNotWriteableException;
import javax.jms.MessageNotWriteableRuntimeException;
import javax.jms.MessageProducer;
import javax.jms.ResourceAllocationException;
import javax.jms.ResourceAllocationRuntimeException;
import javax.jms.Session;
import javax.jms.TransactionInProgressException;
import javax.jms.TransactionInProgressRuntimeException;
import javax.jms.TransactionRolledBackException;
import javax.jms.TransactionRolledBackRuntimeException;
import javax.naming.InitialContext;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleData;
import oracle.jdbc.internal.OracleConnection;
import oracle.jms.AQjmsBytesMessage_C;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsJDBCConnInfo;
import oracle.jms.AQjmsMapMessage_C;
import oracle.jms.AQjmsMessageHeaderExt;
import oracle.jms.AQjmsObject;
import oracle.jms.AQjmsObjectMessage_C;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsStreamMessage_C;
import oracle.jms.AQjmsTextMessage_C;
import oracle.jms.AQjmsTransformation;
import oracle.jms.WebLogicHelper;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

class AQjmsUtil {
    static final int JAVA_WAIT_NONE = 1000;
    static final int JAVA_WAIT_FOREVER = 0;
    private static final String s_pfx = AQjmsUtil.getHostTimePrefix();
    private static long s_cnt = 0L;

    AQjmsUtil() {
    }

    static String getSystemProperty(String key) {
        final String fkey = key;
        String value = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(fkey);
            }
        });
        return value;
    }

    static String getSystemProperty(String key, String def) {
        final String fkey = key;
        final String fdef = def;
        String value = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(fkey, fdef);
            }
        });
        return value;
    }

    static boolean selectorEquals(String selector1, String selector2) {
        if (selector1 == null) {
            selector1 = "";
        }
        if (selector2 == null) {
            selector2 = "";
        }
        selector1 = selector1.trim();
        selector2 = selector2.trim();
        return selector1.equals(selector2);
    }

    static boolean topicEquals(AQjmsDestination topic1, AQjmsDestination topic2) throws JMSException {
        boolean topicOwnerEquals = AQjmsUtil.stringEqualsNoCase(topic1.getTopicOwner(), topic2.getTopicOwner());
        boolean topicNameEquals = AQjmsUtil.stringEqualsNoCase(topic1.getTopicName(), topic2.getTopicName());
        return topicOwnerEquals && topicNameEquals;
    }

    static boolean stringEqualsNoCase(String s1, String s2) {
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        return s1.equalsIgnoreCase(s2);
    }

    private static String getHostTimePrefix() {
        String host = "localhost";
        String uid = new UID().toString();
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable ex) {
            AQjmsOracleDebug.trace(1, "AQjmsUtil.getHostTimePrefix", "");
        }
        return host + "." + uid;
    }

    static synchronized String newID() {
        return s_pfx + "." + ++s_cnt;
    }

    static String newID(String pfx) {
        return "OJMS." + pfx + "." + AQjmsUtil.newID();
    }

    static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ex) {
            AQjmsOracleDebug.trace(5, "WARN: AQjmsUtil.sleep", "interrupted");
        }
    }

    static void wait(Object o, long ms) {
        try {
            o.wait(ms);
        }
        catch (InterruptedException ex) {
            AQjmsOracleDebug.trace(5, "WARN: AQjmsUtil.wait", "interrupted");
        }
    }

    static AQjmsObject get(Iterator iter) {
        return (AQjmsObject)((WeakReference)iter.next()).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sync(Collection s) {
        if (s == null) {
            return;
        }
        Collection collection = s;
        synchronized (collection) {
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                AQjmsObject c = AQjmsUtil.get(iter);
                if (c != null && c.isOpen()) continue;
                iter.remove();
            }
        }
    }

    static void throwClosed(AQjmsObject o) throws JMSException {
        AQjmsUtil.throwClosed(o, "");
    }

    static void throwClosed(AQjmsObject o, String str) throws JMSException {
        int errcode = o instanceof Connection ? 114 : (o instanceof Session ? 131 : (o instanceof MessageProducer ? 138 : (o instanceof MessageConsumer ? 115 : 122)));
        AQjmsError.throwIllegalStateEx(errcode, str + ":" + o.getID());
    }

    static JMSRuntimeException convertToRuntimeException(JMSException e) {
        if (e instanceof IllegalStateException) {
            return new IllegalStateRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof InvalidClientIDException) {
            return new InvalidClientIDRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof InvalidDestinationException) {
            return new InvalidDestinationRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof InvalidSelectorException) {
            return new InvalidSelectorRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof JMSSecurityException) {
            return new JMSSecurityRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof MessageFormatException) {
            return new MessageFormatRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof MessageNotWriteableException) {
            return new MessageNotWriteableRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof ResourceAllocationException) {
            return new ResourceAllocationRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof TransactionInProgressException) {
            return new TransactionInProgressRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof TransactionRolledBackException) {
            return new TransactionRolledBackRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        return new JMSRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
    }

    static long javaTimeout(long aqtimeout) {
        if (aqtimeout == 0L) {
            return 1000L;
        }
        if (aqtimeout == -1L) {
            return 0L;
        }
        return aqtimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object lookupObject(String objName, Class objClass) throws JMSException {
        InitialContext ctx = null;
        Object obj = null;
        try {
            ctx = new InitialContext();
            obj = ctx.lookup(objName);
        }
        catch (Exception e) {
            AQjmsError.throwEx(118, (Throwable)e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!objClass.isInstance(obj)) {
            AQjmsError.throwEx(195, objName);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AQjmsTransformation getTransType(java.sql.Connection conn, AQjmsDestination dest, String transfxm) throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsUtil.getTransType", "entry:" + transfxm);
        if (transfxm == null) {
            AQjmsError.throwEx(122, "transformation is null");
        }
        Statement stmt = null;
        AQjmsTransformation trans = null;
        try {
            String transSchema = null;
            String transName = null;
            int commapos = transfxm.indexOf(".", 1);
            if (commapos == -1) {
                transSchema = ((oracle.jdbc.OracleConnection)conn).getUserName();
                transName = transfxm;
            } else {
                transSchema = transfxm.substring(0, commapos);
                transName = transfxm.substring(commapos + 1);
            }
            AQjmsOracleDebug.trace(3, "AQjmsUtil.getTransType", "schema" + transSchema + " name: " + transName);
            Hashtable transList = dest.getTransTable();
            trans = (AQjmsTransformation)transList.get(transSchema + "." + transName);
            if (trans == null) {
                AQjmsOracleDebug.trace(3, "AQjmsUtil.getTransType", "transformation is not in the cache, retrive from db.");
                stmt = conn.prepareCall("begin dbms_aqjms.aq$_get_trans_type(?, ?, ?, ?);end;");
                stmt.setString(1, transSchema);
                stmt.setString(2, transName);
                stmt.registerOutParameter(3, 12);
                stmt.registerOutParameter(4, 12);
                stmt.execute();
                String srcType = stmt.getString(3);
                String destType = stmt.getString(4);
                trans = new AQjmsTransformation(srcType, destType);
                transList.put(transSchema + "." + transName, trans);
            }
        }
        catch (SQLException sqe) {
            Object errorMsg = sqe.getErrorCode() == 1403 ? "Transformation " + transfxm + " does not exist" : "Error retrieving transformation types";
            AQjmsError.throwEx((String)errorMsg, (Throwable)sqe);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable throwable) {}
            }
        }
        AQjmsOracleDebug.trace(3, "AQjmsUtil.getTransType", "transformation:" + String.valueOf(trans));
        return trans;
    }

    static OracleClob populateTextContainer(OracleData cont, AQjmsMessageHeaderExt header, String textData, AQjmsSession sess, boolean useTemporaryLob, boolean[] writeLobFlag, boolean isBulkEnqueue) throws JMSException {
        writeLobFlag[0] = false;
        int length = 0;
        if (textData != null) {
            length = textData.length();
        }
        Integer lenField = new Integer(length);
        Object lobField = null;
        OracleClob tempLob = null;
        String vcField = null;
        boolean pass = false;
        try {
            if (sess.maxBytes(length) > 4000) {
                if (useTemporaryLob) {
                    oracle.jdbc.OracleConnection db_conn;
                    if (AQjmsConstants.CACHE_TEMPLOBS && !isBulkEnqueue) {
                        if (sess.cachedTempClob == null) {
                            db_conn = (oracle.jdbc.OracleConnection)sess.getDBConnection();
                            tempLob = (OracleClob)db_conn.createClob();
                            if (WebLogicHelper.runningInWLServer()) {
                                try {
                                    Method getVendorObjMethod = tempLob.getClass().getMethod("getVendorObj", new Class[0]);
                                    tempLob = (OracleClob)getVendorObjMethod.invoke((Object)tempLob, new Object[0]);
                                }
                                catch (Exception e) {
                                    AQjmsOracleDebug.traceEx(3, "AQjmsUtil.unwrapClob", e);
                                }
                            }
                            sess.cachedTempClob = tempLob;
                        } else {
                            tempLob = sess.cachedTempClob;
                        }
                    } else {
                        db_conn = (oracle.jdbc.OracleConnection)sess.getDBConnection();
                        tempLob = (OracleClob)db_conn.createClob();
                        if (WebLogicHelper.runningInWLServer()) {
                            try {
                                Method getVendorObjMethod = tempLob.getClass().getMethod("getVendorObj", new Class[0]);
                                tempLob = (OracleClob)getVendorObjMethod.invoke((Object)tempLob, new Object[0]);
                            }
                            catch (Exception e) {
                                AQjmsOracleDebug.traceEx(3, "AQjmsUtil.unwrapClob", e);
                            }
                        }
                    }
                    lobField = tempLob;
                    lobField.setString(1L, textData);
                } else {
                    lobField = (long)sess.maxBytes(length) > AQjmsConstants.getLongLobThreshold() ? CLOB.getEmptyCLOB() : null;
                    writeLobFlag[0] = true;
                }
            } else {
                vcField = textData;
            }
            if (cont instanceof AQjmsGenMessage_C) {
                AQjmsGenMessage_C genCont = (AQjmsGenMessage_C)cont;
                genCont.setMessageType(new Integer(0));
                genCont.setHeader(header);
                genCont.setTextLen(lenField);
                genCont.setTextVc(vcField);
                genCont.setTextLob((OracleClob)lobField);
            } else if (cont instanceof AQjmsTextMessage_C) {
                AQjmsTextMessage_C textCont = (AQjmsTextMessage_C)cont;
                textCont.setHeader(header);
                textCont.setTextLen(lenField);
                textCont.setTextVc(vcField);
                textCont.setTextLob((OracleClob)lobField);
            } else {
                AQjmsError.throwEx(122, "invalid OracleData type:" + String.valueOf(cont));
            }
            pass = true;
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        finally {
            if (!pass && tempLob != null) {
                try {
                    if (AQjmsConstants.CACHE_TEMPLOBS && !isBulkEnqueue) {
                        sess.cachedTempClob = null;
                        tempLob.free();
                    } else {
                        tempLob.free();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        return tempLob;
    }

    static OracleBlob populateBytesContainer(OracleData cont, int messageType, AQjmsMessageHeaderExt header, byte[] bytesData, AQjmsSession sess, boolean useTemporaryLob, boolean[] writeLobFlag, boolean isBulkEnqueue) throws JMSException {
        writeLobFlag[0] = false;
        int length = 0;
        if (bytesData != null) {
            length = bytesData.length;
        }
        Integer lenField = new Integer(length);
        Object lobField = null;
        OracleBlob tempLob = null;
        byte[] rawField = null;
        boolean pass = false;
        try {
            if (length > 2000) {
                if (useTemporaryLob) {
                    oracle.jdbc.OracleConnection db_conn;
                    if (AQjmsConstants.CACHE_TEMPLOBS && !isBulkEnqueue) {
                        if (sess.cachedTempBlob == null) {
                            db_conn = (oracle.jdbc.OracleConnection)sess.getDBConnection();
                            tempLob = (OracleBlob)db_conn.createBlob();
                            if (WebLogicHelper.runningInWLServer()) {
                                try {
                                    Method getVendorObjMethod = tempLob.getClass().getMethod("getVendorObj", new Class[0]);
                                    tempLob = (OracleBlob)getVendorObjMethod.invoke((Object)tempLob, new Object[0]);
                                }
                                catch (Exception e) {
                                    AQjmsOracleDebug.traceEx(3, "AQjmsUtil.unwrapBlob", e);
                                }
                            }
                            sess.cachedTempBlob = tempLob;
                        } else {
                            tempLob = sess.cachedTempBlob;
                        }
                    } else {
                        db_conn = (oracle.jdbc.OracleConnection)sess.getDBConnection();
                        tempLob = (OracleBlob)db_conn.createBlob();
                        if (WebLogicHelper.runningInWLServer()) {
                            try {
                                Method getVendorObjMethod = tempLob.getClass().getMethod("getVendorObj", new Class[0]);
                                tempLob = (OracleBlob)getVendorObjMethod.invoke((Object)tempLob, new Object[0]);
                            }
                            catch (Exception e) {
                                AQjmsOracleDebug.traceEx(3, "AQjmsUtil.unwrapBlob", e);
                            }
                        }
                    }
                    lobField = tempLob;
                    lobField.setBytes(1L, bytesData);
                } else {
                    lobField = (long)length > AQjmsConstants.getLongLobThreshold() ? BLOB.getEmptyBLOB() : null;
                    writeLobFlag[0] = true;
                }
            } else {
                rawField = bytesData;
            }
            if (cont instanceof AQjmsGenMessage_C) {
                AQjmsGenMessage_C genCont = (AQjmsGenMessage_C)cont;
                genCont.setMessageType(new Integer(messageType));
                genCont.setHeader(header);
                genCont.setBytesLen(lenField);
                genCont.setBytesRaw(rawField);
                genCont.setBytesLob((OracleBlob)lobField);
            } else if (cont instanceof AQjmsBytesMessage_C) {
                AQjmsBytesMessage_C bytesCont = (AQjmsBytesMessage_C)cont;
                bytesCont.setHeader(header);
                bytesCont.setBytesLen(lenField);
                bytesCont.setBytesRaw(rawField);
                bytesCont.setBytesLob((OracleBlob)lobField);
            } else if (cont instanceof AQjmsStreamMessage_C) {
                AQjmsStreamMessage_C streamCont = (AQjmsStreamMessage_C)cont;
                streamCont.setHeader(header);
                streamCont.setBytesLen(lenField);
                streamCont.setBytesRaw(rawField);
                streamCont.setBytesLob((OracleBlob)lobField);
            } else if (cont instanceof AQjmsMapMessage_C) {
                AQjmsMapMessage_C mapCont = (AQjmsMapMessage_C)cont;
                mapCont.setHeader(header);
                mapCont.setBytesLen(lenField);
                mapCont.setBytesRaw(rawField);
                mapCont.setBytesLob((OracleBlob)lobField);
            } else if (cont instanceof AQjmsObjectMessage_C) {
                AQjmsObjectMessage_C objectCont = (AQjmsObjectMessage_C)cont;
                objectCont.setHeader(header);
                objectCont.setBytesLen(lenField);
                objectCont.setBytesRaw(rawField);
                objectCont.setBytesLob((OracleBlob)lobField);
            } else {
                AQjmsError.throwEx(122, "invalid OracleData type:" + String.valueOf(cont));
            }
            pass = true;
        }
        catch (SQLException sql_ex) {
            sql_ex.printStackTrace();
            throw new AQjmsException(sql_ex);
        }
        finally {
            if (!pass && tempLob != null) {
                try {
                    if (AQjmsConstants.CACHE_TEMPLOBS && !isBulkEnqueue) {
                        sess.cachedTempBlob = null;
                        tempLob.free();
                    } else {
                        tempLob.free();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        return tempLob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int checkMigration(AQjmsSession sess, String queueName, String[] migName) {
        OracleCallableStatement migStmt = null;
        int migState = 0;
        if (!sess.is23compatible()) {
            return migState;
        }
        try {
            java.sql.Connection dbConnection = sess.getDBConnection();
            migStmt = (OracleCallableStatement)dbConnection.prepareCall("SELECT DBMS_ASSERT.ENQUOTE_NAME(target_schema_name) , DBMS_ASSERT.ENQUOTE_NAME(target_queue_name), event, DBMS_ASSERT.SCHEMA_NAME(target_schema_name) verified_schema, DBMS_ASSERT.ENQUOTE_LITERAL(target_queue_name) enqoted_queue FROM USER_TXEVENTQ_MIGRATION_STATUS WHERE event_status = 1 and source_queue_name = ? ORDER BY event_timestamp DESC FETCH FIRST ROW ONLY");
            migStmt.setString(1, queueName.toUpperCase());
            ResultSet mig_rset = migStmt.executeQuery();
            if (mig_rset != null && mig_rset.next()) {
                migName[0] = mig_rset.getString(1);
                migName[1] = mig_rset.getString(2);
                String migEvent = mig_rset.getString(3);
                migName[2] = mig_rset.getString(4);
                migName[3] = mig_rset.getString(5);
                if (migEvent.equalsIgnoreCase("Commit_Migration")) {
                    AQjmsOracleDebug.trace(0, "AQjmsUtil.checkMigration", "Commit Migration is on for " + migName[0] + "." + queueName);
                    migState = 2;
                } else if (migEvent.equalsIgnoreCase("Init_Migration")) {
                    AQjmsOracleDebug.trace(0, "AQjmsUtil.checkMigration", "Init Migration is on for " + migName[0] + "." + queueName);
                    migState = 1;
                } else if (migEvent.equalsIgnoreCase("Cancel_Migration")) {
                    AQjmsOracleDebug.trace(0, "AQjmsUtil.checkMigration", "Cancel Migration is on for " + migName[0] + "." + queueName);
                    migState = 1;
                }
            } else {
                migState = 0;
            }
        }
        catch (Exception ex) {
            migState = -1;
            AQjmsOracleDebug.traceEx(0, "AQjmsUtil.checkMigration Exception for queue:" + queueName, ex);
        }
        finally {
            try {
                if (migStmt != null) {
                    migStmt.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return migState;
    }

    static void writeClob(String textData, AQjmsSession sess, AQjmsDestination dest, byte[] msgid, boolean isAnydataDest) throws JMSException {
        block23: {
            OracleCallableStatement clobStmt = null;
            String queueTable = dest.getCompleteTableName();
            try {
                java.sql.Connection db_conn = sess.getDBConnection();
                if (queueTable == null) {
                    AQjmsError.throwEx(122, "qtable is null");
                }
                AQjmsOracleDebug.trace(5, "AQjmsUtil.writeClob", "qtable: " + queueTable);
                AQjmsOracleDebug.trace(5, "AQjmsStreamMessage.writeClob", "isAnydataDest: " + isAnydataDest);
                if (!isAnydataDest && !sess.isKprb() && (long)textData.length() <= AQjmsConstants.getLongLobThreshold()) {
                    clobStmt = (OracleCallableStatement)db_conn.prepareCall("UPDATE " + queueTable + " tab set tab.user_data.text_lob = ? where tab.msgid = ?");
                    clobStmt.setString(1, textData);
                    clobStmt.setBytes(2, msgid);
                    int count = clobStmt.executeUpdate();
                    if (count == 1) break block23;
                    boolean errorFlag = true;
                    String[] migratedQName = new String[4];
                    int migState = -1;
                    String schema = dest.getQueueOwner();
                    String queueName = dest.getQueueName();
                    if (dest.isTopic()) {
                        queueName = dest.getTopicName();
                    }
                    if ((migState = AQjmsUtil.checkMigration(sess, queueName, migratedQName)) > 0) {
                        if (migState == 1) {
                            schema = migratedQName[0];
                            queueName = migratedQName[1];
                        }
                        try {
                            clobStmt.close();
                            clobStmt = (OracleCallableStatement)db_conn.prepareCall("UPDATE " + schema + "." + queueName + " tab SET tab.userdata_blob = ? WHERE tab.msgid = ?");
                            clobStmt.setBytes(1, textData.getBytes());
                            clobStmt.setBytes(2, msgid);
                            int cnt = clobStmt.executeUpdate();
                            if (cnt == 1) {
                                errorFlag = false;
                                if (migState == 1) {
                                    dest.getProperty().setMigrating(true);
                                } else {
                                    dest.getProperty().setSharded(true);
                                }
                            }
                        }
                        catch (Exception ex) {
                            errorFlag = true;
                            AQjmsOracleDebug.traceEx(0, "AQjmsUtil.writeClob Exception occurred while updating lob in TEQ:" + schema + "." + queueName, ex);
                        }
                    }
                    if (errorFlag) {
                        AQjmsError.throwEx(122, "Write lob updated no row or more than 1 row");
                    }
                    break block23;
                }
                clobStmt = isAnydataDest ? (OracleCallableStatement)db_conn.prepareCall("SELECT dbms_aqin.aq$_getclob_from_jmsanydata(user_data) FROM " + queueTable + " where msgid = ?") : (OracleCallableStatement)db_conn.prepareCall("SELECT tab.user_data.text_lob FROM " + queueTable + " tab where msgid = ?");
                clobStmt.setBytes(1, msgid);
                ResultSet rset = clobStmt.executeQuery();
                OracleClob textLob = null;
                if (rset.next()) {
                    textLob = (OracleClob)rset.getClob(1);
                }
                if (textLob == null) {
                    AQjmsOracleDebug.trace(1, "AQjmsUtil.writeClob", "Internal error - text_lob is null");
                    AQjmsError.throwEx(122, "text_lob is null");
                }
                textLob.setString(1L, textData);
            }
            catch (SQLException sql_ex) {
                throw new AQjmsException(sql_ex);
            }
            finally {
                try {
                    if (clobStmt != null) {
                        clobStmt.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
    }

    static void writeBlob(byte[] bytesData, AQjmsSession sess, AQjmsDestination dest, byte[] msgid, boolean isAnydataDest) throws JMSException {
        block23: {
            OracleCallableStatement blobStmt = null;
            String queueTable = dest.getCompleteTableName();
            try {
                java.sql.Connection db_conn = sess.getDBConnection();
                if (queueTable == null) {
                    AQjmsError.throwEx(122, "qtable is null");
                }
                AQjmsOracleDebug.trace(5, "AQjmsUtil.writeBlob", "qtable: " + queueTable);
                AQjmsOracleDebug.trace(5, "AQjmsStreamMessage.writeBlob", "isAnydataDest: " + isAnydataDest);
                if (!isAnydataDest && !sess.isKprb() && (long)bytesData.length <= AQjmsConstants.getLongLobThreshold()) {
                    blobStmt = (OracleCallableStatement)db_conn.prepareCall("UPDATE " + queueTable + " tab set tab.user_data.bytes_lob = ? where tab.msgid = ?");
                    blobStmt.setBytes(1, bytesData);
                    blobStmt.setBytes(2, msgid);
                    int count = blobStmt.executeUpdate();
                    if (count == 1) break block23;
                    boolean errorFlag = true;
                    String[] migratedQName = new String[4];
                    int migState = -1;
                    String schema = dest.getQueueOwner();
                    String queueName = dest.getQueueName();
                    if (dest.isTopic()) {
                        queueName = dest.getTopicName();
                    }
                    if ((migState = AQjmsUtil.checkMigration(sess, queueName, migratedQName)) > 0) {
                        if (migState == 1) {
                            schema = migratedQName[0];
                            queueName = migratedQName[1];
                        }
                        try {
                            blobStmt.close();
                            blobStmt = (OracleCallableStatement)db_conn.prepareCall("UPDATE " + schema + "." + queueName + " tab SET tab.userdata_blob = ? WHERE tab.msgid = ?");
                            blobStmt.setBytes(1, bytesData);
                            blobStmt.setBytes(2, msgid);
                            int cnt = blobStmt.executeUpdate();
                            if (cnt == 1) {
                                errorFlag = false;
                                if (migState == 1) {
                                    dest.getProperty().setMigrating(true);
                                } else {
                                    dest.getProperty().setSharded(true);
                                }
                            }
                        }
                        catch (Exception ex) {
                            errorFlag = true;
                            AQjmsOracleDebug.traceEx(0, "AQjmsUtil.writeBlob Exception occurred while updating lob in TEQ:" + schema + "." + queueName, ex);
                        }
                    }
                    if (errorFlag) {
                        AQjmsError.throwEx(122, "Write lob updated no row or more than 1 row");
                    }
                    break block23;
                }
                blobStmt = isAnydataDest ? (OracleCallableStatement)db_conn.prepareCall("SELECT dbms_aqin.aq$_getblob_from_jmsanydata(user_data) FROM " + queueTable + " where msgid = ?") : (OracleCallableStatement)db_conn.prepareCall("SELECT tab.user_data.bytes_lob FROM " + queueTable + " tab where msgid = ?");
                blobStmt.setBytes(1, msgid);
                ResultSet rset = blobStmt.executeQuery();
                OracleBlob bytesLob = null;
                if (rset.next()) {
                    bytesLob = (OracleBlob)rset.getBlob(1);
                }
                if (bytesLob == null) {
                    AQjmsOracleDebug.trace(1, "AQjmsUtil.writeBlob", "Internal error - bytes_lob is null");
                    AQjmsError.throwEx(122, "bytes_lob is null");
                }
                bytesLob.setBytes(1L, bytesData);
            }
            catch (SQLException sql_ex) {
                throw new AQjmsException(sql_ex);
            }
            finally {
                try {
                    if (blobStmt != null) {
                        blobStmt.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
    }

    static String getTextData(int textLen, OracleClob textLob, String textVc) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsUtil.getTextData", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsUtil.getTextData", "textLen: " + textLen);
        String textData = textVc;
        if (textData == null && textLob != null) {
            try {
                textData = textLob.getSubString(1L, textLen);
            }
            catch (SQLException sql_ex) {
                throw new AQjmsException(sql_ex);
            }
        }
        if (textData == null && textLen != 0 || textData != null && textData.length() != textLen) {
            AQjmsError.throwEx(122, "Corrupted message");
        }
        AQjmsOracleDebug.trace(4, "AQjmsUtil.getTextData", "exit");
        return textData;
    }

    static byte[] getBytesData(int bytesLen, OracleBlob bytesLob, byte[] bytesRaw) throws JMSException {
        byte[] bytesData = null;
        AQjmsOracleDebug.trace(4, "AQjmsUtil.getBytesData", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsUtil.getBytesData", "bytesLen: " + bytesLen);
        try {
            if (bytesRaw != null) {
                bytesData = bytesRaw;
            } else if (bytesLob != null) {
                bytesData = bytesLob.getBytes(1L, bytesLen);
            }
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        if (bytesData == null && bytesLen != 0 || bytesData != null && bytesData.length != bytesLen) {
            AQjmsError.throwEx(122, "Corrupted message");
        }
        AQjmsOracleDebug.trace(4, "AQjmsUtil.getBytesData", "exit");
        return bytesData;
    }

    public static AQjmsJDBCConnInfo getJDBCConnInfo(oracle.jdbc.OracleConnection connOracle) {
        if (connOracle == null) {
            return null;
        }
        if (!(connOracle instanceof OracleConnection)) {
            return null;
        }
        OracleConnection conn = (OracleConnection)connOracle;
        AQjmsJDBCConnInfo jdbcInfo = new AQjmsJDBCConnInfo();
        try {
            jdbcInfo.instanceName = conn.getServerSessionInfo().getProperty("INSTANCE_NAME");
            jdbcInfo.instanceNum = conn.getServerSessionInfo().getProperty("AUTH_INSTANCE_NO");
            jdbcInfo.instStartTime = conn.getServerSessionInfo().getProperty("AUTH_SC_INSTANCE_START_TIME");
            jdbcInfo.dbName = conn.getServerSessionInfo().getProperty("DATABASE_NAME");
            jdbcInfo.dbServiceName = conn.getServerSessionInfo().getProperty("SERVICE_NAME");
            jdbcInfo.dbHostName = conn.getServerSessionInfo().getProperty("AUTH_SC_SERVER_HOST");
            jdbcInfo.sessionId = conn.getServerSessionInfo().getProperty("AUTH_SESSION_ID");
            jdbcInfo.serialNum = conn.getServerSessionInfo().getProperty("AUTH_SERIAL_NUM");
            jdbcInfo.serverPid = conn.getServerSessionInfo().getProperty("AUTH_SERVER_PID");
            jdbcInfo.dbUserId = conn.getServerSessionInfo().getProperty("AUTH_USER_ID");
        }
        catch (Exception e) {
            jdbcInfo.mayBeInvalid = true;
        }
        jdbcInfo.aqJmsStartTime = new Date();
        return jdbcInfo;
    }

    public static boolean doubleQuoted(String name) {
        return name.charAt(0) == '\"' && name.charAt(name.length() - 1) == '\"';
    }

    public static String encloseInDoubleQuotes(String name) {
        StringBuilder quotedName = new StringBuilder();
        quotedName.append("\"").append(name).append("\"");
        return quotedName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getQueueParameter(java.sql.Connection conn, String qName, String paramName) {
        CallableStatement stmt = null;
        int paramVal = 0;
        try {
            stmt = conn.prepareCall("BEGIN dbms_aqadm.get_queue_parameter(?, ?, ?); END;");
            stmt.setString(1, qName);
            stmt.setString(2, paramName);
            stmt.registerOutParameter(3, 2);
            stmt.execute();
            paramVal = stmt.getInt(3);
            AQjmsOracleDebug.trace(3, "AQjmsUtil.getQueueParameter", "paramName: " + paramName + ", paramVal: " + paramVal);
        }
        catch (SQLException sqe) {
            AQjmsOracleDebug.trace(3, "AQjmsUtil.getQueueParameter", "Error " + sqe.getErrorCode());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return paramVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isGrantOnAQADMPriv(java.sql.Connection conn) {
        PreparedStatement stmt = null;
        ResultSet rSet = null;
        try {
            stmt = conn.prepareStatement("select PRIVILEGE, TABLE_NAME from all_tab_privs where type='PACKAGE' and TABLE_NAME='DBMS_AQADM' and PRIVILEGE='EXECUTE'");
            try {
                rSet = stmt.executeQuery();
            }
            catch (SQLException ex) {
                AQjmsOracleDebug.trace(3, "AQjmsUtil.isGrantOnAQADMPriv", "Error " + ex.getErrorCode());
            }
            if (!rSet.isBeforeFirst()) {
                AQjmsOracleDebug.trace(3, "AQjmsUtil.isGrantOnAQADMPriv", "No rows selected");
                boolean ex = false;
                return ex;
            }
            boolean ex = true;
            return ex;
        }
        catch (SQLException sqe) {
            AQjmsOracleDebug.trace(3, "AQjmsUtil.isGrantOnAQADMPriv", "Error " + sqe.getErrorCode());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable throwable) {}
            }
            if (rSet != null) {
                try {
                    rSet.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }
}

