/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.sql.DataSource;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsConnectionFactory;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsUtil;
import oracle.jms.WebLogicHelper;

public class AQjmsTopicConnectionFactory
extends AQjmsConnectionFactory
implements TopicConnectionFactory,
Serializable {
    AQjmsTopicConnectionFactory(String hostname, String oracle_sid, int portno, String driver) throws JMSException {
        this.hostname = hostname;
        this.oracle_sid = oracle_sid;
        this.portno = portno;
        this.data_source = null;
        if (driver != null) {
            if (driver.equalsIgnoreCase("thin")) {
                this.jdbc_driver = "thin";
            } else if (driver.equalsIgnoreCase("oci8")) {
                this.jdbc_driver = "oci8";
            } else if (driver.equalsIgnoreCase("oci")) {
                this.jdbc_driver = "oci";
            } else {
                AQjmsError.throwEx(135, driver);
            }
        } else {
            this.jdbc_driver = "thin";
        }
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
    }

    AQjmsTopicConnectionFactory(String jdbc_connect_str, Properties jdbc_props) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.data_source = null;
        this.jdbc_conn_str = jdbc_connect_str;
        this.jdbc_info = jdbc_props;
    }

    AQjmsTopicConnectionFactory(DataSource dsobj) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
        this.data_source = dsobj;
        AQjmsOracleDebug.trace(5, "AQjmsTopicConnectionFactory - constructor", "data source object: " + String.valueOf(dsobj));
    }

    AQjmsTopicConnectionFactory(DataSource dsobj, String jdbc_connect_str, Properties jdbc_props) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.data_source = dsobj;
        this.jdbc_conn_str = jdbc_connect_str;
        this.jdbc_info = jdbc_props;
    }

    AQjmsTopicConnectionFactory(String dsname) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
        this.data_source = (DataSource)AQjmsUtil.lookupObject(dsname, DataSource.class);
        AQjmsOracleDebug.trace(5, "AQjmsTopicConnectionFactory - constructor", "data source name: " + dsname);
    }

    public AQjmsTopicConnectionFactory() {
    }

    public TopicConnection createTopicConnection() throws JMSException {
        AQjmsConnection tconn = null;
        if (WebLogicHelper.runningInWLServer()) {
            if (this.data_source == null) {
                throw new UnsupportedOperationException("WebLogic server side components must use AQ JMS datasource configuration");
            }
            tconn = new AQjmsConnection(this.data_source, null, null, 20);
        } else {
            tconn = this.jdbc_conn_str != null ? new AQjmsConnection(this.jdbc_conn_str, this.jdbc_info, 20) : (this.data_source != null ? new AQjmsConnection(this.data_source, null, null, 20) : new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, null, null, this.jdbc_driver, 20));
        }
        tconn.setCompliant(this.compliant);
        return tconn;
    }

    public TopicConnection createTopicConnectionInternal() throws JMSException {
        AQjmsConnection tconn = null;
        tconn = this.data_source != null ? new AQjmsConnection(this.data_source, null, null, 20) : (this.jdbc_conn_str != null ? new AQjmsConnection(this.jdbc_conn_str, this.jdbc_info, 20) : new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, null, null, this.jdbc_driver, 20));
        tconn.setCompliant(this.compliant);
        return tconn;
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        AQjmsConnection tconn = null;
        if (WebLogicHelper.runningInWLServer()) {
            if (this.data_source == null) {
                throw new UnsupportedOperationException("WebLogic server side components must use AQ JMS datasource configuration");
            }
            tconn = new AQjmsConnection(this.data_source, userName, password, 20);
        } else {
            Properties new_info = null;
            if (this.jdbc_conn_str != null) {
                if (this.jdbc_info != null) {
                    if (userName != null || password != null) {
                        new_info = (Properties)this.jdbc_info.clone();
                        new_info.put("user", userName);
                        new_info.put("password", password);
                    } else {
                        new_info = this.jdbc_info;
                    }
                    tconn = new AQjmsConnection(this.jdbc_conn_str, new_info, 20);
                } else {
                    tconn = new AQjmsConnection(this.jdbc_conn_str, userName, password, 20);
                }
            } else {
                tconn = this.data_source != null ? new AQjmsConnection(this.data_source, userName, password, 20) : new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, userName, password, this.jdbc_driver, 20);
            }
        }
        tconn.setCompliant(this.compliant);
        return tconn;
    }

    public static TopicConnection createTopicConnection(Connection jdbcConnection) throws JMSException {
        AQjmsConnection tconn = null;
        tconn = new AQjmsConnection(jdbcConnection, 20);
        return tconn;
    }

    public static TopicConnection createTopicConnection(Connection jdbcConnection, boolean compliant) throws JMSException {
        AQjmsConnection tconn = null;
        tconn = new AQjmsConnection(jdbcConnection, 20);
        tconn.setCompliant(compliant);
        return tconn;
    }

    public static TopicConnection createTopicConnection(OracleOCIConnectionPool connectionPool) throws JMSException {
        AQjmsConnection tconn = null;
        tconn = new AQjmsConnection(connectionPool, 20);
        return tconn;
    }

    public static TopicConnection createTopicConnection(OracleOCIConnectionPool connectionPool, boolean compliant) throws JMSException {
        AQjmsConnection tconn = null;
        tconn = new AQjmsConnection(connectionPool, 20);
        tconn.setCompliant(compliant);
        return tconn;
    }

    @Override
    boolean getCompliant() {
        return this.compliant;
    }

    @Override
    void setCompliant(boolean compliant) {
        this.compliant = compliant;
        AQjmsOracleDebug.trace(4, "AQjmsTopicConnectionFactory.setCompliant", "Current <compliant> is set to:" + compliant);
    }
}

