/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.SQLException;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.ObjectFactory;
import oracle.jms.AQjmsAgent;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsOracleDebug;

public class AQjmsSubscriberFactory
implements ObjectFactory {
    private String ag_name = null;
    private String address = null;
    private int protocol = 0;
    private String certificate = null;
    private String rule = null;
    private String transformation = null;
    private String sub_owner = null;
    static final String ALIAS_TYPE = "alias";
    static final String AGENT_TYPE = "agent";
    static final String AQSUB_TYPE = "aq_subscriber";
    static final String JMSUB_TYPE = "jms_subscriber";
    static final String RULE_ATTR = "rule";
    static final String TRANS_ATTR = "transformation";

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws JMSException {
        Reference ref = (Reference)obj;
        AQjmsOracleDebug.trace(4, "AQjmsSubscriberFactory.getObjectInstance", "entry");
        if (ref == null) {
            AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "Reference object is null");
            return null;
        }
        if (!ref.getClassName().equals("oracle.jms.AQjmsConsumer") && !ref.getClassName().equals("oracle.jms.AQjmsAgent")) {
            AQjmsOracleDebug.trace(3, "AQjmsConnectionFactory.getObjectInstance", "unable to manufacture object of class: " + ref.getClassName());
            return null;
        }
        try {
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(0);
            NamingEnumeration<SearchResult> results = ((DirContext)nameCtx).search(name, "(objectclass=*)", constraints);
            if (results == null) {
                AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "failed to search attributes of subscriber " + name.get(0));
                return null;
            }
            SearchResult si = results.next();
            Attributes attrs = si.getAttributes();
            String obj_typ = (String)attrs.get("orclDBAQObjType").get();
            AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "obj_typ " + obj_typ);
            while (obj_typ.toLowerCase().equals(ALIAS_TYPE)) {
                String obj_dn = (String)attrs.get("orclDBAQPointerAttr").get();
                AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "obj_dn " + obj_dn);
                InitialDirContext ctx = new InitialDirContext(environment);
                results = ctx.search(obj_dn, "(objectclass=*)", constraints);
                if (results == null) {
                    AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "failed to search attributes of object " + obj_dn);
                    return null;
                }
                si = results.next();
                attrs = si.getAttributes();
                obj_typ = (String)attrs.get("orclDBAQObjType").get();
                AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "obj_typ2 " + obj_typ);
            }
            if (obj_typ.toLowerCase().equals(AGENT_TYPE) || obj_typ.toLowerCase().equals(AQSUB_TYPE) || obj_typ.toLowerCase().equals(JMSUB_TYPE)) {
                String cn = (String)attrs.get("cn").get();
                AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "cn " + cn);
                int idx3 = obj_typ.toLowerCase().equals(JMSUB_TYPE) ? cn.indexOf(46) + 1 : 0;
                AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "idx3 " + idx3);
                int idx1 = cn.indexOf(58);
                AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "idx1 " + idx1);
                int idx2 = idx1 == -1 ? -1 : cn.indexOf(58, idx1 + 1);
                AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "idx2 " + idx2);
                if (idx2 == -1 || idx3 == -1) {
                    AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "attribute cn is of bad format " + cn);
                    return null;
                }
                if (idx1 > 0) {
                    this.ag_name = cn.substring(idx3, idx1);
                }
                AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "ag_name " + this.ag_name);
                if (idx2 - idx1 > 1) {
                    this.address = cn.substring(idx1 + 1, idx2);
                }
                AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "address " + this.address);
                if (idx2 < cn.length() - 1) {
                    String pro = cn.substring(idx2 + 1, cn.length());
                    AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "pro " + pro);
                    this.protocol = Integer.valueOf(pro);
                }
            }
            if (obj_typ.toLowerCase().equals(AGENT_TYPE)) {
                Attribute cer_atr = attrs.get("orclDBAQPointerAttr");
                if (cer_atr == null) {
                    AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "certificate = null ");
                } else {
                    this.certificate = (String)cer_atr.get();
                    AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "certificate " + this.certificate);
                }
                AQjmsAgent agent = new AQjmsAgent(this.ag_name, this.address, this.protocol);
                AQjmsOracleDebug.trace(4, "AQjmsSubscriberFactory.getObjectInstance", "Agents exit");
                return agent;
            }
            if (obj_typ.toLowerCase().equals(AQSUB_TYPE)) {
                Attribute gen_attr = attrs.get("orclDBAQGeneric");
                for (int i = 0; i < gen_attr.size(); ++i) {
                    String val = (String)gen_attr.get(i);
                    AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "val " + val);
                    if (val.toLowerCase().startsWith(RULE_ATTR)) {
                        this.rule = val.substring(RULE_ATTR.length() + 1);
                        AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "rule " + this.rule);
                        continue;
                    }
                    if (!val.toLowerCase().startsWith(TRANS_ATTR)) continue;
                    this.transformation = val.substring(TRANS_ATTR.length() + 1);
                    AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "transformation " + this.transformation);
                }
                AQjmsOracleDebug.trace(4, "AQjmsSubscriberFactory.getObjectInstance", " Subscriber exit");
                return null;
            }
        }
        catch (NamingException e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSubscriberFactory.getObjectInstance", e);
            AQjmsError.throwEx(205, (Throwable)e);
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSubscriberFactory.getObjectInstance", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSubscriberFactory.getObjectInstance", "exit");
        return null;
    }
}

