/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms.plsql;

import java.io.IOException;
import oracle.jms.plsql.InvalidIdException;
import oracle.jms.plsql.MsgEntity;
import oracle.jms.plsql.MsgStoreOverflowException;

class MsgStore {
    static int defaultSize = 20;
    private int msgType;
    private int storeSize;
    private MsgEntity[] msgArray;

    MsgStore(int n) {
        this.msgType = n;
        this.storeSize = defaultSize;
        this.msgArray = new MsgEntity[this.storeSize];
        for (int i = 0; i < this.storeSize; ++i) {
            this.msgArray[i] = null;
        }
    }

    MsgEntity getMsgEntity(int n) throws InvalidIdException {
        if (n < 0 || n >= this.storeSize || this.msgArray[n] == null) {
            throw new InvalidIdException();
        }
        return this.msgArray[n];
    }

    int createMsgEntity() throws MsgStoreOverflowException, IOException, ClassNotFoundException {
        return this.createMsgEntity(null);
    }

    int createMsgEntity(byte[] byArray) throws MsgStoreOverflowException, IOException, ClassNotFoundException {
        for (int i = 0; i < this.storeSize; ++i) {
            if (this.msgArray[i] != null) continue;
            this.msgArray[i] = MsgEntity.createMsgEntity(this.msgType, byArray);
            return i;
        }
        throw new MsgStoreOverflowException();
    }

    int createMsgEntity(int n) throws InvalidIdException, MsgStoreOverflowException, IOException, ClassNotFoundException {
        return this.createMsgEntity(n, null);
    }

    int createMsgEntity(int n, byte[] byArray) throws InvalidIdException, MsgStoreOverflowException, IOException, ClassNotFoundException {
        if (n < 0 || n >= this.storeSize) {
            throw new InvalidIdException();
        }
        if (this.msgArray[n] != null) {
            this.msgArray[n].clean();
        }
        this.msgArray[n] = MsgEntity.createMsgEntity(this.msgType, byArray);
        return n;
    }

    void cleanMsgEntity(int n) throws InvalidIdException, IOException {
        if (n < 0 || n >= this.storeSize || this.msgArray[n] == null) {
            throw new InvalidIdException();
        }
        this.msgArray[n].clean();
        this.msgArray[n] = null;
    }

    void cleanAllMsgEntity() throws IOException {
        for (int i = 0; i < this.storeSize; ++i) {
            if (this.msgArray[i] == null) continue;
            this.msgArray[i].clean();
            this.msgArray[i] = null;
        }
    }

    static void setDefaultSize(int n) {
        defaultSize = n;
    }
}

