/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms.plsql;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import oracle.jms.plsql.MapTooLargeException;
import oracle.jms.plsql.MsgEntity;
import oracle.jms.plsql.TypeConversion;
import oracle.jms.plsql.TypeConversionException;

class MapMsgEntity
extends MsgEntity {
    private HashMap map;
    private String[] names = null;
    private boolean namesDirty = false;

    MapMsgEntity() {
        this.map = new HashMap();
    }

    MapMsgEntity(byte[] byArray) throws IOException, ClassNotFoundException {
        final ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    try {
                        MapMsgEntity.this.map = (HashMap)objectInputStream.readObject();
                    }
                    catch (Throwable throwable) {
                        return throwable;
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            System.out.println("PrivilegedActionException : " + privilegedActionException);
            throw (IOException)privilegedActionException.getCause();
        }
        objectInputStream.close();
    }

    @Override
    void clean() throws IOException {
        this.map = null;
    }

    byte[] flush() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this.map);
        objectOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    int size() {
        return this.map.size();
    }

    String[] getNames() throws MapTooLargeException {
        if (this.map.size() > 1024) {
            throw new MapTooLargeException();
        }
        if (this.names == null || this.namesDirty) {
            this.populateNames();
        }
        return this.names;
    }

    String[] getNames(int n, int n2, int[] nArray) throws MapTooLargeException {
        if (n2 > 1024) {
            throw new MapTooLargeException();
        }
        if (this.names == null || this.namesDirty) {
            this.populateNames();
        }
        if (n >= this.names.length) {
            nArray[0] = 0;
            return new String[0];
        }
        n2 = n2 > this.names.length - n ? this.names.length - n : n2;
        String[] stringArray = new String[n2];
        System.arraycopy(stringArray, 0, this.names, n, n2);
        nArray[0] = n2;
        return stringArray;
    }

    boolean itemExists(String string) {
        return this.map.containsKey(string);
    }

    Object get(String string, int n) throws TypeConversionException {
        Object v = this.map.get(string);
        if (v == null) {
            return null;
        }
        return TypeConversion.jmsConvert(v, n);
    }

    Object get(String string) {
        return this.map.get(string);
    }

    void set(String string, Object object) {
        this.map.put(string, object);
        this.namesDirty = true;
    }

    private void populateNames() {
        this.names = new String[this.map.size()];
        Iterator iterator = this.map.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.names[n++] = (String)iterator.next();
        }
        this.namesDirty = false;
    }
}

