/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.rmi.server.UID;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.InitialContext;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleData;
import oracle.jdbc.internal.OracleConnection;
import oracle.jms.AQjmsBytesMessage_C;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsJDBCConnInfo;
import oracle.jms.AQjmsMapMessage_C;
import oracle.jms.AQjmsMessageHeaderExt;
import oracle.jms.AQjmsObject;
import oracle.jms.AQjmsObjectMessage_C;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsStreamMessage_C;
import oracle.jms.AQjmsTextMessage_C;
import oracle.jms.AQjmsTransformation;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

class AQjmsUtil {
    static final int JAVA_WAIT_NONE = 1000;
    static final int JAVA_WAIT_FOREVER = 0;
    private static final String s_pfx = AQjmsUtil.getHostTimePrefix();
    private static long s_cnt = 0L;

    AQjmsUtil() {
    }

    static String getSystemProperty(String string) {
        final String string2 = string;
        String string3 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string2);
            }
        });
        return string3;
    }

    static String getSystemProperty(String string, String string2) {
        final String string3 = string;
        final String string4 = string2;
        String string5 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string3, string4);
            }
        });
        return string5;
    }

    static boolean selectorEquals(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        string = string.trim();
        string2 = string2.trim();
        return string.equals(string2);
    }

    static boolean topicEquals(AQjmsDestination aQjmsDestination, AQjmsDestination aQjmsDestination2) throws JMSException {
        boolean bl = AQjmsUtil.stringEqualsNoCase(aQjmsDestination.getTopicOwner(), aQjmsDestination2.getTopicOwner());
        boolean bl2 = AQjmsUtil.stringEqualsNoCase(aQjmsDestination.getTopicName(), aQjmsDestination2.getTopicName());
        return bl && bl2;
    }

    static boolean stringEqualsNoCase(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        return string.equalsIgnoreCase(string2);
    }

    private static String getHostTimePrefix() {
        String string = "localhost";
        String string2 = new UID().toString();
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable throwable) {
            AQjmsOracleDebug.trace(1, "AQjmsUtil.getHostTimePrefix", "");
        }
        return string + "." + string2;
    }

    static synchronized String newID() {
        return s_pfx + "." + ++s_cnt;
    }

    static String newID(String string) {
        return "OJMS." + string + "." + AQjmsUtil.newID();
    }

    static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            AQjmsOracleDebug.trace(5, "WARN: AQjmsUtil.sleep", "interrupted");
        }
    }

    static void wait(Object object, long l) {
        try {
            object.wait(l);
        }
        catch (InterruptedException interruptedException) {
            AQjmsOracleDebug.trace(5, "WARN: AQjmsUtil.wait", "interrupted");
        }
    }

    static AQjmsObject get(Iterator iterator) {
        return (AQjmsObject)((WeakReference)iterator.next()).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sync(Collection collection) {
        if (collection == null) {
            return;
        }
        Collection collection2 = collection;
        synchronized (collection2) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                AQjmsObject aQjmsObject = AQjmsUtil.get(iterator);
                if (aQjmsObject != null && aQjmsObject.isOpen()) continue;
                iterator.remove();
            }
        }
    }

    static void throwClosed(AQjmsObject aQjmsObject) throws JMSException {
        AQjmsUtil.throwClosed(aQjmsObject, "");
    }

    static void throwClosed(AQjmsObject aQjmsObject, String string) throws JMSException {
        int n = aQjmsObject instanceof Connection ? 114 : (aQjmsObject instanceof Session ? 131 : (aQjmsObject instanceof MessageProducer ? 138 : (aQjmsObject instanceof MessageConsumer ? 115 : 122)));
        AQjmsError.throwIllegalStateEx(n, string + ":" + aQjmsObject.getID());
    }

    static long javaTimeout(long l) {
        if (l == 0L) {
            return 1000L;
        }
        if (l == -1L) {
            return 0L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object lookupObject(String string, Class clazz) throws JMSException {
        InitialContext initialContext = null;
        Object object = null;
        try {
            initialContext = new InitialContext();
            object = initialContext.lookup(string);
        }
        catch (Exception exception) {
            AQjmsError.throwEx(118, (Throwable)exception);
        }
        finally {
            if (initialContext != null) {
                try {
                    initialContext.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!clazz.isInstance(object)) {
            AQjmsError.throwEx(195, string);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AQjmsTransformation getTransType(java.sql.Connection connection, AQjmsDestination aQjmsDestination, String string) throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsUtil.getTransType", "entry:" + string);
        if (string == null) {
            AQjmsError.throwEx(122, "transformation is null");
        }
        Statement statement = null;
        AQjmsTransformation aQjmsTransformation = null;
        try {
            String string2 = null;
            String string3 = null;
            int n = string.indexOf(".", 1);
            if (n == -1) {
                string2 = ((oracle.jdbc.OracleConnection)connection).getUserName();
                string3 = string;
            } else {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            }
            AQjmsOracleDebug.trace(3, "AQjmsUtil.getTransType", "schema" + string2 + " name: " + string3);
            Hashtable hashtable = aQjmsDestination.getTransTable();
            aQjmsTransformation = (AQjmsTransformation)hashtable.get(string2 + "." + string3);
            if (aQjmsTransformation == null) {
                AQjmsOracleDebug.trace(3, "AQjmsUtil.getTransType", "transformation is not in the cache, retrive from db.");
                statement = connection.prepareCall("begin dbms_aqjms.aq$_get_trans_type(?, ?, ?, ?);end;");
                statement.setString(1, string2);
                statement.setString(2, string3);
                statement.registerOutParameter(3, 12);
                statement.registerOutParameter(4, 12);
                statement.execute();
                String string4 = statement.getString(3);
                String string5 = statement.getString(4);
                aQjmsTransformation = new AQjmsTransformation(string4, string5);
                hashtable.put(string2 + "." + string3, aQjmsTransformation);
            }
        }
        catch (SQLException sQLException) {
            String string6 = sQLException.getErrorCode() == 1403 ? "Transformation " + string + " does not exist" : "Error retrieving transformation types";
            AQjmsError.throwEx(string6, (Throwable)sQLException);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Throwable throwable) {}
            }
        }
        AQjmsOracleDebug.trace(3, "AQjmsUtil.getTransType", "transformation:" + aQjmsTransformation);
        return aQjmsTransformation;
    }

    static OracleClob populateTextContainer(OracleData oracleData, AQjmsMessageHeaderExt aQjmsMessageHeaderExt, String string, AQjmsSession aQjmsSession, boolean bl, boolean[] blArray, boolean bl2) throws JMSException {
        blArray[0] = false;
        int n = 0;
        if (string != null) {
            n = string.length();
        }
        Integer n2 = new Integer(n);
        Object object = null;
        OracleClob oracleClob = null;
        String string2 = null;
        boolean bl3 = false;
        try {
            Object object2;
            if (aQjmsSession.maxBytes(n) > 4000) {
                if (bl) {
                    if (AQjmsConstants.CACHE_TEMPLOBS && !bl2) {
                        if (aQjmsSession.cachedTempClob == null) {
                            object2 = (oracle.jdbc.OracleConnection)aQjmsSession.getDBConnection();
                            aQjmsSession.cachedTempClob = oracleClob = (OracleClob)object2.createClob();
                        } else {
                            oracleClob = aQjmsSession.cachedTempClob;
                        }
                    } else {
                        object2 = (oracle.jdbc.OracleConnection)aQjmsSession.getDBConnection();
                        oracleClob = (OracleClob)object2.createClob();
                    }
                    object = oracleClob;
                    object.setString(1L, string);
                } else {
                    object = (long)aQjmsSession.maxBytes(n) > AQjmsConstants.getLongLobThreshold() ? CLOB.getEmptyCLOB() : null;
                    blArray[0] = true;
                }
            } else {
                string2 = string;
            }
            if (oracleData instanceof AQjmsGenMessage_C) {
                object2 = (AQjmsGenMessage_C)oracleData;
                ((AQjmsGenMessage_C)object2).setMessageType(new Integer(0));
                ((AQjmsGenMessage_C)object2).setHeader(aQjmsMessageHeaderExt);
                ((AQjmsGenMessage_C)object2).setTextLen(n2);
                ((AQjmsGenMessage_C)object2).setTextVc(string2);
                ((AQjmsGenMessage_C)object2).setTextLob((OracleClob)object);
            } else if (oracleData instanceof AQjmsTextMessage_C) {
                object2 = (AQjmsTextMessage_C)oracleData;
                ((AQjmsTextMessage_C)object2).setHeader(aQjmsMessageHeaderExt);
                ((AQjmsTextMessage_C)object2).setTextLen(n2);
                ((AQjmsTextMessage_C)object2).setTextVc(string2);
                ((AQjmsTextMessage_C)object2).setTextLob((OracleClob)object);
            } else {
                AQjmsError.throwEx(122, "invalid OracleData type:" + oracleData);
            }
            bl3 = true;
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        finally {
            if (!bl3 && oracleClob != null) {
                try {
                    if (AQjmsConstants.CACHE_TEMPLOBS && !bl2) {
                        aQjmsSession.cachedTempClob = null;
                        oracleClob.free();
                    } else {
                        oracleClob.free();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        return oracleClob;
    }

    static OracleBlob populateBytesContainer(OracleData oracleData, int n, AQjmsMessageHeaderExt aQjmsMessageHeaderExt, byte[] byArray, AQjmsSession aQjmsSession, boolean bl, boolean[] blArray, boolean bl2) throws JMSException {
        blArray[0] = false;
        int n2 = 0;
        if (byArray != null) {
            n2 = byArray.length;
        }
        Integer n3 = new Integer(n2);
        Object object = null;
        OracleBlob oracleBlob = null;
        byte[] byArray2 = null;
        boolean bl3 = false;
        try {
            Object object2;
            if (n2 > 2000) {
                if (bl) {
                    if (AQjmsConstants.CACHE_TEMPLOBS && !bl2) {
                        if (aQjmsSession.cachedTempBlob == null) {
                            object2 = (oracle.jdbc.OracleConnection)aQjmsSession.getDBConnection();
                            aQjmsSession.cachedTempBlob = oracleBlob = (OracleBlob)object2.createBlob();
                        } else {
                            oracleBlob = aQjmsSession.cachedTempBlob;
                        }
                    } else {
                        object2 = (oracle.jdbc.OracleConnection)aQjmsSession.getDBConnection();
                        oracleBlob = (OracleBlob)object2.createBlob();
                    }
                    object = oracleBlob;
                    object.setBytes(1L, byArray);
                } else {
                    object = (long)n2 > AQjmsConstants.getLongLobThreshold() ? BLOB.getEmptyBLOB() : null;
                    blArray[0] = true;
                }
            } else {
                byArray2 = byArray;
            }
            if (oracleData instanceof AQjmsGenMessage_C) {
                object2 = (AQjmsGenMessage_C)oracleData;
                ((AQjmsGenMessage_C)object2).setMessageType(new Integer(n));
                ((AQjmsGenMessage_C)object2).setHeader(aQjmsMessageHeaderExt);
                ((AQjmsGenMessage_C)object2).setBytesLen(n3);
                ((AQjmsGenMessage_C)object2).setBytesRaw(byArray2);
                ((AQjmsGenMessage_C)object2).setBytesLob((OracleBlob)object);
            } else if (oracleData instanceof AQjmsBytesMessage_C) {
                object2 = (AQjmsBytesMessage_C)oracleData;
                ((AQjmsBytesMessage_C)object2).setHeader(aQjmsMessageHeaderExt);
                ((AQjmsBytesMessage_C)object2).setBytesLen(n3);
                ((AQjmsBytesMessage_C)object2).setBytesRaw(byArray2);
                ((AQjmsBytesMessage_C)object2).setBytesLob((OracleBlob)object);
            } else if (oracleData instanceof AQjmsStreamMessage_C) {
                object2 = (AQjmsStreamMessage_C)oracleData;
                ((AQjmsStreamMessage_C)object2).setHeader(aQjmsMessageHeaderExt);
                ((AQjmsStreamMessage_C)object2).setBytesLen(n3);
                ((AQjmsStreamMessage_C)object2).setBytesRaw(byArray2);
                ((AQjmsStreamMessage_C)object2).setBytesLob((OracleBlob)object);
            } else if (oracleData instanceof AQjmsMapMessage_C) {
                object2 = (AQjmsMapMessage_C)oracleData;
                ((AQjmsMapMessage_C)object2).setHeader(aQjmsMessageHeaderExt);
                ((AQjmsMapMessage_C)object2).setBytesLen(n3);
                ((AQjmsMapMessage_C)object2).setBytesRaw(byArray2);
                ((AQjmsMapMessage_C)object2).setBytesLob((OracleBlob)object);
            } else if (oracleData instanceof AQjmsObjectMessage_C) {
                object2 = (AQjmsObjectMessage_C)oracleData;
                ((AQjmsObjectMessage_C)object2).setHeader(aQjmsMessageHeaderExt);
                ((AQjmsObjectMessage_C)object2).setBytesLen(n3);
                ((AQjmsObjectMessage_C)object2).setBytesRaw(byArray2);
                ((AQjmsObjectMessage_C)object2).setBytesLob((OracleBlob)object);
            } else {
                AQjmsError.throwEx(122, "invalid OracleData type:" + oracleData);
            }
            bl3 = true;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new AQjmsException(sQLException);
        }
        finally {
            if (!bl3 && oracleBlob != null) {
                try {
                    if (AQjmsConstants.CACHE_TEMPLOBS && !bl2) {
                        aQjmsSession.cachedTempBlob = null;
                        oracleBlob.free();
                    } else {
                        oracleBlob.free();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        return oracleBlob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int checkMigration(AQjmsSession aQjmsSession, String string, String[] stringArray) {
        OracleCallableStatement oracleCallableStatement = null;
        int n = 0;
        if (!aQjmsSession.is23compatible()) {
            return n;
        }
        try {
            java.sql.Connection connection = aQjmsSession.getDBConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("SELECT target_schema_name, target_queue_name, event FROM USER_TXEVENTQ_MIGRATION_STATUS WHERE event_status = 1 and source_queue_name = ? ORDER BY event_timestamp DESC FETCH FIRST ROW ONLY");
            oracleCallableStatement.setString(1, string.toUpperCase());
            ResultSet resultSet = oracleCallableStatement.executeQuery();
            if (resultSet != null && resultSet.next()) {
                stringArray[0] = resultSet.getString(1);
                stringArray[1] = resultSet.getString(2);
                String string2 = resultSet.getString(3);
                if (string2.equalsIgnoreCase("Commit_Migration")) {
                    AQjmsOracleDebug.trace(0, "AQjmsUtil.checkMigration", "Commit Migration is on for " + stringArray[0] + "." + string);
                    n = 2;
                } else if (string2.equalsIgnoreCase("Init_Migration")) {
                    AQjmsOracleDebug.trace(0, "AQjmsUtil.checkMigration", "Init Migration is on for " + stringArray[0] + "." + string);
                    n = 1;
                }
            } else {
                n = 0;
            }
        }
        catch (Exception exception) {
            n = -1;
            AQjmsOracleDebug.traceEx(0, "AQjmsUtil.checkMigration Exception for queue:" + string, exception);
        }
        finally {
            try {
                if (oracleCallableStatement != null) {
                    oracleCallableStatement.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return n;
    }

    static void writeClob(String string, AQjmsSession aQjmsSession, AQjmsDestination aQjmsDestination, byte[] byArray, boolean bl) throws JMSException {
        block23: {
            OracleCallableStatement oracleCallableStatement = null;
            String string2 = aQjmsDestination.getCompleteTableName();
            try {
                java.sql.Connection connection = aQjmsSession.getDBConnection();
                if (string2 == null) {
                    AQjmsError.throwEx(122, "qtable is null");
                }
                AQjmsOracleDebug.trace(5, "AQjmsUtil.writeClob", "qtable: " + string2);
                AQjmsOracleDebug.trace(5, "AQjmsStreamMessage.writeClob", "isAnydataDest: " + bl);
                if (!bl && !aQjmsSession.isKprb() && (long)string.length() <= AQjmsConstants.getLongLobThreshold()) {
                    oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("UPDATE " + string2 + " tab set tab.user_data.text_lob = ? where tab.msgid = ?");
                    oracleCallableStatement.setString(1, string);
                    oracleCallableStatement.setBytes(2, byArray);
                    int n = oracleCallableStatement.executeUpdate();
                    if (n == 1) break block23;
                    boolean bl2 = true;
                    String[] stringArray = new String[2];
                    int n2 = -1;
                    String string3 = aQjmsDestination.getQueueOwner();
                    String string4 = aQjmsDestination.getQueueName();
                    if (aQjmsDestination.isTopic()) {
                        string4 = aQjmsDestination.getTopicName();
                    }
                    if ((n2 = AQjmsUtil.checkMigration(aQjmsSession, string4, stringArray)) > 0) {
                        if (n2 == 1) {
                            string3 = stringArray[0];
                            string4 = stringArray[1];
                        }
                        try {
                            oracleCallableStatement.close();
                            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("UPDATE " + string3 + "." + string4 + " tab SET tab.userdata_blob = ? WHERE tab.msgid = ?");
                            oracleCallableStatement.setBytes(1, string.getBytes());
                            oracleCallableStatement.setBytes(2, byArray);
                            int n3 = oracleCallableStatement.executeUpdate();
                            if (n3 == 1) {
                                bl2 = false;
                                if (n2 == 1) {
                                    aQjmsDestination.getProperty().setMigrating(true);
                                } else {
                                    aQjmsDestination.getProperty().setSharded(true);
                                }
                            }
                        }
                        catch (Exception exception) {
                            bl2 = true;
                            AQjmsOracleDebug.traceEx(0, "AQjmsUtil.writeClob Exception occurred while updating lob in TEQ:" + string3 + "." + string4, exception);
                        }
                    }
                    if (bl2) {
                        AQjmsError.throwEx(122, "Write lob updated no row or more than 1 row");
                    }
                    break block23;
                }
                oracleCallableStatement = bl ? (OracleCallableStatement)connection.prepareCall("SELECT dbms_aqin.aq$_getclob_from_jmsanydata(user_data) FROM " + string2 + " where msgid = ?") : (OracleCallableStatement)connection.prepareCall("SELECT tab.user_data.text_lob FROM " + string2 + " tab where msgid = ?");
                oracleCallableStatement.setBytes(1, byArray);
                ResultSet resultSet = oracleCallableStatement.executeQuery();
                OracleClob oracleClob = null;
                if (resultSet.next()) {
                    oracleClob = (OracleClob)resultSet.getClob(1);
                }
                if (oracleClob == null) {
                    AQjmsOracleDebug.trace(1, "AQjmsUtil.writeClob", "Internal error - text_lob is null");
                    AQjmsError.throwEx(122, "text_lob is null");
                }
                oracleClob.setString(1L, string);
            }
            catch (SQLException sQLException) {
                throw new AQjmsException(sQLException);
            }
            finally {
                try {
                    if (oracleCallableStatement != null) {
                        oracleCallableStatement.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
    }

    static void writeBlob(byte[] byArray, AQjmsSession aQjmsSession, AQjmsDestination aQjmsDestination, byte[] byArray2, boolean bl) throws JMSException {
        block23: {
            OracleCallableStatement oracleCallableStatement = null;
            String string = aQjmsDestination.getCompleteTableName();
            try {
                java.sql.Connection connection = aQjmsSession.getDBConnection();
                if (string == null) {
                    AQjmsError.throwEx(122, "qtable is null");
                }
                AQjmsOracleDebug.trace(5, "AQjmsUtil.writeBlob", "qtable: " + string);
                AQjmsOracleDebug.trace(5, "AQjmsStreamMessage.writeBlob", "isAnydataDest: " + bl);
                if (!bl && !aQjmsSession.isKprb() && (long)byArray.length <= AQjmsConstants.getLongLobThreshold()) {
                    oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("UPDATE " + string + " tab set tab.user_data.bytes_lob = ? where tab.msgid = ?");
                    oracleCallableStatement.setBytes(1, byArray);
                    oracleCallableStatement.setBytes(2, byArray2);
                    int n = oracleCallableStatement.executeUpdate();
                    if (n == 1) break block23;
                    boolean bl2 = true;
                    String[] stringArray = new String[2];
                    int n2 = -1;
                    String string2 = aQjmsDestination.getQueueOwner();
                    String string3 = aQjmsDestination.getQueueName();
                    if (aQjmsDestination.isTopic()) {
                        string3 = aQjmsDestination.getTopicName();
                    }
                    if ((n2 = AQjmsUtil.checkMigration(aQjmsSession, string3, stringArray)) > 0) {
                        if (n2 == 1) {
                            string2 = stringArray[0];
                            string3 = stringArray[1];
                        }
                        try {
                            oracleCallableStatement.close();
                            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("UPDATE " + string2 + "." + string3 + " tab SET tab.userdata_blob = ? WHERE tab.msgid = ?");
                            oracleCallableStatement.setBytes(1, byArray);
                            oracleCallableStatement.setBytes(2, byArray2);
                            int n3 = oracleCallableStatement.executeUpdate();
                            if (n3 == 1) {
                                bl2 = false;
                                if (n2 == 1) {
                                    aQjmsDestination.getProperty().setMigrating(true);
                                } else {
                                    aQjmsDestination.getProperty().setSharded(true);
                                }
                            }
                        }
                        catch (Exception exception) {
                            bl2 = true;
                            AQjmsOracleDebug.traceEx(0, "AQjmsUtil.writeBlob Exception occurred while updating lob in TEQ:" + string2 + "." + string3, exception);
                        }
                    }
                    if (bl2) {
                        AQjmsError.throwEx(122, "Write lob updated no row or more than 1 row");
                    }
                    break block23;
                }
                oracleCallableStatement = bl ? (OracleCallableStatement)connection.prepareCall("SELECT dbms_aqin.aq$_getblob_from_jmsanydata(user_data) FROM " + string + " where msgid = ?") : (OracleCallableStatement)connection.prepareCall("SELECT tab.user_data.bytes_lob FROM " + string + " tab where msgid = ?");
                oracleCallableStatement.setBytes(1, byArray2);
                ResultSet resultSet = oracleCallableStatement.executeQuery();
                OracleBlob oracleBlob = null;
                if (resultSet.next()) {
                    oracleBlob = (OracleBlob)resultSet.getBlob(1);
                }
                if (oracleBlob == null) {
                    AQjmsOracleDebug.trace(1, "AQjmsUtil.writeBlob", "Internal error - bytes_lob is null");
                    AQjmsError.throwEx(122, "bytes_lob is null");
                }
                oracleBlob.setBytes(1L, byArray);
            }
            catch (SQLException sQLException) {
                throw new AQjmsException(sQLException);
            }
            finally {
                try {
                    if (oracleCallableStatement != null) {
                        oracleCallableStatement.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
    }

    static String getTextData(int n, OracleClob oracleClob, String string) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsUtil.getTextData", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsUtil.getTextData", "textLen: " + n);
        String string2 = string;
        if (string2 == null && oracleClob != null) {
            try {
                string2 = oracleClob.getSubString(1L, n);
            }
            catch (SQLException sQLException) {
                throw new AQjmsException(sQLException);
            }
        }
        if (string2 == null && n != 0 || string2 != null && string2.length() != n) {
            AQjmsError.throwEx(122, "Corrupted message");
        }
        AQjmsOracleDebug.trace(4, "AQjmsUtil.getTextData", "exit");
        return string2;
    }

    static byte[] getBytesData(int n, OracleBlob oracleBlob, byte[] byArray) throws JMSException {
        byte[] byArray2 = null;
        AQjmsOracleDebug.trace(4, "AQjmsUtil.getBytesData", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsUtil.getBytesData", "bytesLen: " + n);
        try {
            if (byArray != null) {
                byArray2 = byArray;
            } else if (oracleBlob != null) {
                byArray2 = oracleBlob.getBytes(1L, n);
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        if (byArray2 == null && n != 0 || byArray2 != null && byArray2.length != n) {
            AQjmsError.throwEx(122, "Corrupted message");
        }
        AQjmsOracleDebug.trace(4, "AQjmsUtil.getBytesData", "exit");
        return byArray2;
    }

    public static AQjmsJDBCConnInfo getJDBCConnInfo(oracle.jdbc.OracleConnection oracleConnection) {
        if (oracleConnection == null) {
            return null;
        }
        if (!(oracleConnection instanceof OracleConnection)) {
            return null;
        }
        OracleConnection oracleConnection2 = (OracleConnection)oracleConnection;
        AQjmsJDBCConnInfo aQjmsJDBCConnInfo = new AQjmsJDBCConnInfo();
        try {
            aQjmsJDBCConnInfo.instanceName = oracleConnection2.getServerSessionInfo().getProperty("INSTANCE_NAME");
            aQjmsJDBCConnInfo.instanceNum = oracleConnection2.getServerSessionInfo().getProperty("AUTH_INSTANCE_NO");
            aQjmsJDBCConnInfo.instStartTime = oracleConnection2.getServerSessionInfo().getProperty("AUTH_SC_INSTANCE_START_TIME");
            aQjmsJDBCConnInfo.dbName = oracleConnection2.getServerSessionInfo().getProperty("DATABASE_NAME");
            aQjmsJDBCConnInfo.dbServiceName = oracleConnection2.getServerSessionInfo().getProperty("SERVICE_NAME");
            aQjmsJDBCConnInfo.dbHostName = oracleConnection2.getServerSessionInfo().getProperty("AUTH_SC_SERVER_HOST");
            aQjmsJDBCConnInfo.sessionId = oracleConnection2.getServerSessionInfo().getProperty("AUTH_SESSION_ID");
            aQjmsJDBCConnInfo.serialNum = oracleConnection2.getServerSessionInfo().getProperty("AUTH_SERIAL_NUM");
            aQjmsJDBCConnInfo.serverPid = oracleConnection2.getServerSessionInfo().getProperty("AUTH_SERVER_PID");
            aQjmsJDBCConnInfo.dbUserId = oracleConnection2.getServerSessionInfo().getProperty("AUTH_USER_ID");
        }
        catch (Exception exception) {
            aQjmsJDBCConnInfo.mayBeInvalid = true;
        }
        aQjmsJDBCConnInfo.aqJmsStartTime = new Date();
        return aQjmsJDBCConnInfo;
    }

    public static boolean doubleQuoted(String string) {
        return string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"';
    }

    public static String encloseInDoubleQuotes(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"").append(string).append("\"");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getQueueParameter(java.sql.Connection connection, String string, String string2) {
        CallableStatement callableStatement = null;
        int n = 0;
        try {
            callableStatement = connection.prepareCall("BEGIN dbms_aqadm.get_queue_parameter(?, ?, ?); END;");
            callableStatement.setString(1, string);
            callableStatement.setString(2, string2);
            callableStatement.registerOutParameter(3, 2);
            callableStatement.execute();
            n = callableStatement.getInt(3);
            AQjmsOracleDebug.trace(3, "AQjmsUtil.getQueueParameter", "paramName: " + string2 + ", paramVal: " + n);
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.trace(3, "AQjmsUtil.getQueueParameter", "Error " + sQLException.getErrorCode());
        }
        finally {
            if (callableStatement != null) {
                try {
                    callableStatement.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return n;
    }
}

