/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import oracle.jdbc.OracleData;
import oracle.jms.AQjmsBytesMessage_C;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsUtil;

public class AQjmsBytesMessage
extends AQjmsMessage
implements BytesMessage {
    private byte[] m_bytesData = new byte[0];
    private DataInputStream m_inDataStream;
    private ByteArrayOutputStream m_outByteArrayStream;
    private DataOutputStream m_outDataStream;
    private boolean m_dirty = false;

    public AQjmsBytesMessage() {
        super(true);
        this.m_outByteArrayStream = new ByteArrayOutputStream();
        this.m_outDataStream = new DataOutputStream(this.m_outByteArrayStream);
        this.access_mode = 1;
    }

    AQjmsBytesMessage(AQjmsSession aQjmsSession) {
        super(aQjmsSession, true);
        this.m_outByteArrayStream = new ByteArrayOutputStream();
        this.m_outDataStream = new DataOutputStream(this.m_outByteArrayStream);
        this.access_mode = 1;
    }

    AQjmsBytesMessage(AQjmsMessage aQjmsMessage) {
        super(aQjmsMessage);
    }

    AQjmsBytesMessage(AQjmsSession aQjmsSession, AQjmsBytesMessage_C aQjmsBytesMessage_C) throws JMSException {
        super(aQjmsSession, true);
        try {
            this.header_ext = aQjmsBytesMessage_C.getHeader();
            this.readBytesMessageContainer(aQjmsBytesMessage_C);
            this.m_inDataStream = new DataInputStream(new ByteArrayInputStream(this.m_bytesData));
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        this.access_mode = 0;
    }

    AQjmsBytesMessage(AQjmsSession aQjmsSession, AQjmsGenMessage_C aQjmsGenMessage_C) throws JMSException {
        super(aQjmsSession, true);
        try {
            this.header_ext = aQjmsGenMessage_C.getHeader();
            this.readGenMessageContainer(aQjmsGenMessage_C);
            this.m_inDataStream = new DataInputStream(new ByteArrayInputStream(this.m_bytesData));
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        this.access_mode = 0;
    }

    AQjmsBytesMessage(AQjmsSession aQjmsSession, byte[] byArray) {
        super(aQjmsSession, true);
        if (byArray != null) {
            this.m_bytesData = byArray;
        }
        this.m_inDataStream = new DataInputStream(new ByteArrayInputStream(this.m_bytesData));
        this.access_mode = 0;
    }

    public byte[] getBytesData() {
        this.updateBytesDataFromStream();
        return this.m_bytesData;
    }

    public boolean readBoolean() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            if (this.isLargeBody()) {
                this.invalidReadWithStreaming("readBoolean");
            }
            return this.m_inDataStream.readBoolean();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        return false;
    }

    public byte readByte() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            if (this.isLargeBody()) {
                this.invalidReadWithStreaming("readByte");
            }
            return this.m_inDataStream.readByte();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        return 0;
    }

    public int readUnsignedByte() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            if (this.isLargeBody()) {
                this.invalidReadWithStreaming("readUnsignedByte");
            }
            return this.m_inDataStream.readUnsignedByte();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        return 0;
    }

    public short readShort() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            if (this.isLargeBody()) {
                this.invalidReadWithStreaming("readShort");
            }
            return this.m_inDataStream.readShort();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        return 0;
    }

    public int readUnsignedShort() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            if (this.isLargeBody()) {
                this.invalidReadWithStreaming("readUnsignedShort");
            }
            return this.m_inDataStream.readUnsignedShort();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        return 0;
    }

    public char readChar() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            if (this.isLargeBody()) {
                this.invalidReadWithStreaming("readChar");
            }
            return this.m_inDataStream.readChar();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        return '\u0000';
    }

    public int readInt() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            if (this.isLargeBody()) {
                this.invalidReadWithStreaming("readInt");
            }
            return this.m_inDataStream.readInt();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        return 0;
    }

    public long readLong() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            if (this.isLargeBody()) {
                this.invalidReadWithStreaming("readLong");
            }
            return this.m_inDataStream.readLong();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        return 0L;
    }

    public float readFloat() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            if (this.isLargeBody()) {
                this.invalidReadWithStreaming("readFloat");
            }
            return this.m_inDataStream.readFloat();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        return 0.0f;
    }

    public double readDouble() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            if (this.isLargeBody()) {
                this.invalidReadWithStreaming("readDouble");
            }
            return this.m_inDataStream.readDouble();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        return 0.0;
    }

    public String readUTF() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            if (this.isLargeBody()) {
                this.invalidReadWithStreaming("readUTF");
            }
            return this.m_inDataStream.readUTF();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        return null;
    }

    public int readBytes(byte[] byArray) throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            if (this.isLargeBody()) {
                this.invalidReadWithStreaming("readBytes");
            }
            return this.m_inDataStream.read(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
            return -1;
        }
    }

    public int readBytes(byte[] byArray, int n) throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            if (this.isLargeBody()) {
                this.invalidReadWithStreaming("readBytes");
            }
            return this.m_inDataStream.read(byArray, 0, n);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
            return -1;
        }
    }

    public void writeBoolean(boolean bl) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outDataStream.writeBoolean(bl);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeByte(byte by) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outDataStream.writeByte(by);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeShort(short s) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outDataStream.writeShort(s);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeChar(char c) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outDataStream.writeChar(c);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeInt(int n) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outDataStream.writeInt(n);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeLong(long l) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outDataStream.writeLong(l);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeFloat(float f) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outDataStream.writeFloat(f);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeDouble(double d) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outDataStream.writeDouble(d);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeUTF(String string) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        if (string == null) {
            throw new NullPointerException("BytesMessage.writeUTF encounters null parameter");
        }
        try {
            this.m_outDataStream.writeUTF(string);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeBytes(byte[] byArray) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        if (byArray == null) {
            throw new NullPointerException("BytesMessage.writeBytes encounters null parameter");
        }
        try {
            this.m_outDataStream.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        if (byArray == null) {
            throw new NullPointerException("BytesMessage.writeBytes encounters null parameter");
        }
        try {
            this.m_outDataStream.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeObject(Object object) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        if (object == null) {
            throw new NullPointerException(AQjmsError.getMessage(229));
        }
        if (object instanceof Integer) {
            this.writeInt((Integer)object);
        } else if (object instanceof Long) {
            this.writeLong((Long)object);
        } else if (object instanceof Float) {
            this.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Short) {
            this.writeShort((Short)object);
        } else if (object instanceof Byte) {
            this.writeByte((Byte)object);
        } else if (object instanceof Double) {
            this.writeDouble((Double)object);
        } else if (object instanceof String) {
            this.writeUTF(((String)object).toString());
        } else if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else if (object instanceof byte[]) {
            this.writeBytes((byte[])object);
        } else {
            AQjmsError.throwMsgFormatEx(161, null);
        }
        this.m_dirty = true;
    }

    @Override
    public void setInputStream(InputStream inputStream) throws JMSException {
        super.setInputStream(inputStream);
    }

    public OutputStream getBody(OutputStream outputStream) throws JMSException {
        return this.getBody(outputStream, 0, 0L);
    }

    public OutputStream getBody(OutputStream outputStream, int n) throws JMSException {
        return this.getBody(outputStream, n, 0L);
    }

    public OutputStream getBody(OutputStream outputStream, long l) throws JMSException {
        return this.getBody(outputStream, 0, l);
    }

    @Override
    public OutputStream getBody(OutputStream outputStream, int n, long l) throws JMSException {
        return super.getBody(outputStream, n, l);
    }

    public void reset() throws JMSException {
        if (this.access_mode == 1) {
            this.updateBytesDataFromStream();
            this.m_outByteArrayStream = null;
            this.m_outDataStream = null;
            this.m_dirty = false;
        }
        this.m_inDataStream = new DataInputStream(new ByteArrayInputStream(this.m_bytesData));
        this.setAccessMode(0);
    }

    @Override
    public void clearBody() throws JMSException {
        if (this.access_mode == 0) {
            this.m_inDataStream = null;
        }
        this.m_bytesData = new byte[0];
        this.m_dirty = false;
        this.m_outByteArrayStream = new ByteArrayOutputStream();
        this.m_outDataStream = new DataOutputStream(this.m_outByteArrayStream);
        this.setAccessMode(1);
    }

    @Override
    public long getBodyLength() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0L;
        }
        if (super.getBodyLength() > 0L) {
            return super.getBodyLength();
        }
        if (this.m_bytesData == null) {
            return 0L;
        }
        return this.m_bytesData.length;
    }

    @Override
    OracleData getMessageCont(AQjmsSession aQjmsSession, boolean bl, boolean bl2) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsBytesMessage.getMessageCont", "entry");
        this.updateBytesDataFromStream();
        AQjmsBytesMessage_C aQjmsBytesMessage_C = new AQjmsBytesMessage_C();
        boolean[] blArray = new boolean[1];
        this.m_tempLob = AQjmsUtil.populateBytesContainer(aQjmsBytesMessage_C, 1, this.header_ext, this.m_bytesData, aQjmsSession, bl, blArray, bl2);
        this.setWriteLobLater(blArray[0]);
        AQjmsOracleDebug.trace(4, "AQjmsBytesMessage.getMessageCont", "exit");
        return aQjmsBytesMessage_C;
    }

    @Override
    AQjmsGenMessage_C getGenMessageCont(AQjmsSession aQjmsSession, boolean bl, boolean bl2) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsBytesMessage.getGenMessageCont", "entry");
        this.updateBytesDataFromStream();
        AQjmsGenMessage_C aQjmsGenMessage_C = new AQjmsGenMessage_C();
        boolean[] blArray = new boolean[1];
        this.m_tempLob = AQjmsUtil.populateBytesContainer(aQjmsGenMessage_C, 1, this.header_ext, this.m_bytesData, aQjmsSession, bl, blArray, bl2);
        this.setWriteLobLater(blArray[0]);
        AQjmsOracleDebug.trace(4, "AQjmsBytesMessage.getGenMessageCont", "exit");
        return aQjmsGenMessage_C;
    }

    @Override
    void writeLob(AQjmsSession aQjmsSession, AQjmsDestination aQjmsDestination, byte[] byArray, boolean bl) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsBytesmessage.writeLob", "entry");
        if (this.m_writeLobLater) {
            AQjmsUtil.writeBlob(this.m_bytesData, aQjmsSession, aQjmsDestination, byArray, bl);
        }
        AQjmsOracleDebug.trace(4, "AQjmsBytesmessage.writeLlob", "exit");
    }

    private void readBytesMessageContainer(AQjmsBytesMessage_C aQjmsBytesMessage_C) throws JMSException {
        try {
            this.m_bytesData = AQjmsUtil.getBytesData(aQjmsBytesMessage_C.getBytesLen(), aQjmsBytesMessage_C.getBytesLob(), aQjmsBytesMessage_C.getBytesRaw());
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        if (this.m_bytesData == null) {
            this.m_bytesData = new byte[0];
        }
    }

    private void readGenMessageContainer(AQjmsGenMessage_C aQjmsGenMessage_C) throws JMSException {
        try {
            this.m_bytesData = AQjmsUtil.getBytesData(aQjmsGenMessage_C.getBytesLen(), aQjmsGenMessage_C.getBytesLob(), aQjmsGenMessage_C.getBytesRaw());
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        if (this.m_bytesData == null) {
            this.m_bytesData = new byte[0];
        }
    }

    private void updateBytesDataFromStream() {
        if (this.m_dirty) {
            this.m_bytesData = this.m_outByteArrayStream.toByteArray();
            this.m_dirty = false;
        }
    }

    @Override
    byte[] getBytesCont() {
        this.updateBytesDataFromStream();
        return this.m_bytesData;
    }
}

