/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.Reference;
import javax.naming.Referenceable;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleDebug;
import oracle.AQ.AQOracleQueue;
import oracle.AQ.AQOracleSQLException;
import oracle.AQ.AQOracleSession;
import oracle.AQ.AQQueue;
import oracle.AQ.AQQueueProperty;
import oracle.AQ.AQQueueTable;
import oracle.AQ.AQQueueTableProperty;
import oracle.AQ.AQSession;
import oracle.AQ.AQUtil;
import oracle.jdbc.OracleCallableStatement;

public class AQOracleQueueTable
implements AQQueueTable,
Referenceable {
    private String owner;
    private String name;
    AQQueueTableProperty property;
    boolean multi_consumer;
    private AQOracleSession aq_sess;
    private CallableStatement crtq_stmt;
    private CallableStatement alqt_stmt;
    private CallableStatement allqt_stmt;
    private CallableStatement allqto_stmt;

    AQOracleQueueTable(AQOracleSession aQOracleSession, String string, String string2, AQQueueTableProperty aQQueueTableProperty) throws AQException {
        this.owner = string;
        if (string2 == null || string2.indexOf(".") != -1) {
            AQUtil.throwAQEx(179, string2);
        }
        this.name = string2;
        this.property = aQQueueTableProperty;
        this.aq_sess = aQOracleSession;
        this.multi_consumer = aQQueueTableProperty.isMulticonsumerEnabled();
    }

    @Override
    public String getOwner() throws AQException {
        return this.owner;
    }

    void setOwner(String string) throws AQException {
        this.owner = string;
    }

    @Override
    public String getName() throws AQException {
        return this.name;
    }

    void setName(String string) throws AQException {
        if (string == null || string.equals("")) {
            AQUtil.throwAQEx(179, "");
        }
        if (string.indexOf(".") != -1) {
            AQUtil.throwAQEx(179, string);
        }
        this.name = string;
    }

    public AQSession getAQSession() {
        return this.aq_sess;
    }

    private void setAQSession(AQOracleSession aQOracleSession) throws AQException {
        if (aQOracleSession != null) {
            this.aq_sess = aQOracleSession;
        } else {
            AQUtil.throwAQEx(194);
        }
    }

    @Override
    public AQQueueTableProperty getProperty() throws AQException {
        Object var1_1 = null;
        Connection connection = null;
        ResultSet resultSet = null;
        String string = null;
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        try {
            try {
                connection = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(188);
            }
            if (this.owner != null && !this.owner.equals("")) {
                string2 = this.owner;
            }
            if (string2 != null) {
                try {
                    if (this.allqto_stmt == null) {
                        this.allqto_stmt = this.aq_sess.is92compatible() ? connection.prepareCall("select queue_table, type, object_type, sort_order, recipients, message_grouping, user_comment, compatible, primary_instance, secondary_instance, owner, secure from all_queue_tables where owner = ? and queue_table = ?") : connection.prepareCall("select queue_table, type, object_type, sort_order, recipients, message_grouping, user_comment, compatible, primary_instance, secondary_instance, owner from all_queue_tables where owner = ? and queue_table = ?");
                    } else {
                        this.allqto_stmt.clearParameters();
                    }
                    this.allqto_stmt.setString(1, string2.toUpperCase());
                    this.allqto_stmt.setString(2, this.name.toUpperCase());
                    resultSet = this.allqto_stmt.executeQuery();
                }
                catch (SQLException sQLException) {
                    AQOracleDebug.traceEx(3, "AQOracleQueueTable.getProperty-1", sQLException);
                    try {
                        this.allqto_stmt.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.allqto_stmt = null;
                    throw sQLException;
                }
            }
            try {
                if (string2 == null) {
                    this.allqt_stmt = this.aq_sess.is92compatible() ? connection.prepareCall("select queue_table, type, object_type, sort_order, recipients, message_grouping, user_comment, compatible, primary_instance, secondary_instance, owner, secure from all_queue_tables where queue_table = ?") : connection.prepareCall("select queue_table, type, object_type, sort_order, recipients, message_grouping, user_comment, compatible, primary_instance, secondary_instance, owner from all_queue_tables where queue_table = ?");
                    this.allqt_stmt.setString(1, this.name.toUpperCase());
                    resultSet = this.allqt_stmt.executeQuery();
                }
            }
            catch (SQLException sQLException) {
                try {
                    this.allqt_stmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.allqt_stmt = null;
                AQOracleDebug.traceEx(3, "AQOracleQueueTable.getProperty-2", sQLException);
                throw sQLException;
            }
            if (resultSet != null && resultSet.next()) {
                string = resultSet.getString(2);
                if (string.equals("RAW")) {
                    this.property = new AQQueueTableProperty("RAW");
                } else {
                    string = resultSet.getString(3);
                    this.property = new AQQueueTableProperty(string);
                }
                this.property.setSortOrder(resultSet.getString(4));
                if (resultSet.getString(5).equals("SINGLE")) {
                    this.property.setMultiConsumer(false);
                } else {
                    this.property.setMultiConsumer(true);
                }
                if (resultSet.getString(6).equals("TRANSACTIONAL")) {
                    this.property.setMessageGrouping(1);
                }
                if (resultSet.getString(7) != null) {
                    this.property.setComment(resultSet.getString(7));
                }
                this.property.setCompatible(resultSet.getString(8));
                this.property.setPrimaryInstance(resultSet.getInt(9));
                this.property.setSecondaryInstance(resultSet.getInt(10));
                if (this.aq_sess.is92compatible()) {
                    string3 = resultSet.getString(12);
                    AQOracleDebug.trace(5, "AQOracleQueueTable.getProperty", "Secure queue table: " + string3);
                    if (string3.equalsIgnoreCase("YES")) {
                        this.property.setSecure(true);
                    }
                }
            } else if (string2 != null) {
                AQUtil.throwAQEx(173, string2 + "." + this.name);
            } else {
                AQUtil.throwAQEx(173, this.name);
            }
            if (resultSet.next()) {
                if (string2 != null) {
                    AQUtil.throwAQEx(172, "");
                } else {
                    AQUtil.throwAQEx(172, "(must specify owner)");
                }
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            AQOracleDebug.traceEx(3, "AQOracleQeueueTable.getProperty-3", sQLException);
            throw new AQOracleSQLException(sQLException);
        }
        return this.property;
    }

    public AQQueueTableProperty getProperty(boolean bl) throws AQException {
        if (bl) {
            AQOracleDebug.trace(5, "AQOracleQueueTable.getProperty", "return cached prop");
            return this.property;
        }
        AQOracleDebug.trace(5, "AQOracleQueueTable.getProperty", "get prop from db");
        return this.getProperty();
    }

    void setProperty(AQQueueTableProperty aQQueueTableProperty) throws AQException {
        this.property = aQQueueTableProperty;
    }

    @Override
    public void alter(String string, int n, int n2) throws AQException {
        Connection connection = null;
        String string2 = "";
        boolean bl = false;
        String string3 = "false";
        String string4 = "true";
        string2 = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                connection = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(188);
            }
            if (this.alqt_stmt != null) {
                this.alqt_stmt.clearParameters();
            } else {
                this.alqt_stmt = connection.prepareCall("begin dbms_aqadm.alter_queue_table(queue_table => ?, comment => ?, primary_instance => ?, secondary_instance => ?); end;");
            }
            this.alqt_stmt.setString(1, string2);
            this.alqt_stmt.setString(2, string);
            this.alqt_stmt.setInt(3, n);
            this.alqt_stmt.setInt(4, n2);
            ((OracleCallableStatement)this.alqt_stmt).execute();
            this.property.setComment(string);
            if (n != 0) {
                this.property.setPrimaryInstance(n);
            }
            if (n2 != 0) {
                this.property.setSecondaryInstance(n2);
            }
        }
        catch (SQLException sQLException) {
            try {
                this.alqt_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.alqt_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueueTable.alter", sQLException);
            throw new AQOracleSQLException(sQLException);
        }
    }

    @Override
    public void alter(String string) throws AQException {
        this.alter(string, 0, 0);
    }

    @Override
    public void drop(boolean bl) throws AQException {
        Statement statement = null;
        Connection connection = null;
        String string = "";
        boolean bl2 = false;
        boolean bl3 = true;
        String string2 = "false";
        String string3 = "true";
        if (this.name == null || this.name.equals("")) {
            AQUtil.throwAQEx(188);
        }
        string = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            connection = this.aq_sess.getDBConnection();
        }
        catch (Exception exception) {
            AQUtil.throwAQEx(188);
        }
        try {
            if (bl) {
                string2 = "true";
            }
            if (!bl3) {
                string3 = "false";
            }
            statement = connection.prepareCall("begin dbms_aqadm.drop_queue_table(queue_table => ?, force => " + string2 + ", auto_commit => " + string3 + "); end;");
            statement.setString(1, string);
            ((OracleCallableStatement)statement).execute();
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            AQOracleDebug.traceEx(3, "AQOracleQueueTable.drop", sQLException);
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQOracleSQLException(sQLException);
        }
        this.aq_sess = null;
    }

    @Override
    public AQQueue createQueue(String string, AQQueueProperty aQQueueProperty) throws AQException {
        CallableStatement callableStatement = null;
        Connection connection = null;
        AQOracleQueue aQOracleQueue = null;
        String string2 = "";
        String string3 = "true";
        if (string == null || string.equals("")) {
            AQUtil.throwAQEx(134);
        }
        if (aQQueueProperty == null) {
            AQUtil.throwAQEx(185);
        }
        if (string.indexOf(".") != -1) {
            AQUtil.throwAQEx(178, string);
        }
        string2 = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                connection = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(188);
            }
            if (!aQQueueProperty.isAutoCommitEnabled()) {
                string3 = "false";
                callableStatement = connection.prepareCall("begin dbms_aqadm.create_queue(queue_name => ?, queue_table => ?, queue_type => ?, max_retries => ?, retry_delay => ?, retention_time => ?, comment => ?, auto_commit => false); end;");
            } else {
                if (this.crtq_stmt != null) {
                    this.crtq_stmt.clearParameters();
                } else {
                    this.crtq_stmt = connection.prepareCall("begin dbms_aqadm.create_queue(queue_name => ?, queue_table => ?, queue_type => ?, max_retries => ?, retry_delay => ?, retention_time => ?, comment => ?, auto_commit => true); end;");
                }
                callableStatement = this.crtq_stmt;
            }
            callableStatement.setString(1, string);
            callableStatement.setString(2, string2);
            callableStatement.setInt(3, aQQueueProperty.getQueueType());
            if (aQQueueProperty.max_retries != null) {
                ((OracleCallableStatement)callableStatement).setObject(4, (Object)aQQueueProperty.max_retries, 4);
            } else {
                ((OracleCallableStatement)callableStatement).setNull(4, 4);
            }
            callableStatement.setDouble(5, aQQueueProperty.getRetryInterval());
            callableStatement.setDouble(6, aQQueueProperty.getRetentionTime());
            callableStatement.setString(7, aQQueueProperty.getComment());
            callableStatement.execute();
        }
        catch (SQLException sQLException) {
            try {
                this.crtq_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.crtq_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueueTable.createQueue", sQLException);
            throw new AQOracleSQLException(sQLException);
        }
        aQOracleQueue = this.property.getPayloadType().equalsIgnoreCase("RAW") ? new AQOracleQueue(this.aq_sess, this.owner, string, string2, aQQueueProperty, 2, this.property.getPayloadType(), this.property.isSecure()) : new AQOracleQueue(this.aq_sess, this.owner, string, string2, aQQueueProperty, 1, this.property.getPayloadType(), this.property.isSecure());
        return aQOracleQueue;
    }

    @Override
    public void dropQueue(String string) throws AQException {
        Statement statement = null;
        Connection connection = null;
        String string2 = "";
        boolean bl = true;
        String string3 = "true";
        string2 = this.owner != null && !this.owner.equals("") ? this.owner + "." + string : string;
        if (string.indexOf(".") != -1) {
            AQUtil.throwAQEx(178, string);
        }
        try {
            try {
                connection = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(188);
            }
            connection = this.aq_sess.getDBConnection();
            if (!bl) {
                string3 = "false";
            }
            statement = connection.prepareCall("begin dbms_aqadm.drop_queue(queue_name => ?, auto_commit =>" + string3 + "); end;");
            statement.setString(1, string2);
            statement.execute();
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.dropQueue", sQLException);
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQOracleSQLException(sQLException);
        }
    }

    public boolean isMulticonsumerEnabled() throws AQException {
        return this.multi_consumer;
    }

    @Override
    public boolean isSecure() {
        return this.property.isSecure();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[AQQueueTable]");
        stringBuffer.append("\n  owner            : " + this.owner);
        stringBuffer.append("\n  name             : " + this.name);
        if (this.property != null) {
            stringBuffer.append("\n" + this.property.toString());
        }
        if (this.aq_sess != null) {
            stringBuffer.append("\n" + this.aq_sess.toString());
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    @Override
    public Reference getReference() {
        Reference reference = new Reference("oracle.AQ.AQOracleQueueTable", "oracle.AQ.AQOracleQueueTableFactory", null);
        return reference;
    }

    @Override
    public void close() {
        try {
            if (this.crtq_stmt != null) {
                this.crtq_stmt.close();
            }
            if (this.alqt_stmt != null) {
                this.alqt_stmt.close();
            }
            if (this.allqt_stmt != null) {
                this.allqt_stmt.close();
            }
            if (this.allqto_stmt != null) {
                this.allqto_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.aq_sess = null;
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

