/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.Connection;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import oracle.jdbc.OracleConnection;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.WebLogicHelper;

final class EmulatedXAHandler
implements Synchronization {
    private static final String JNDI_OC4J_TRANS_MANAGER = "java:comp/pm/TransactionManager";
    private static TransactionManager m_tm;
    private static boolean tmLookupFailed;
    private final Connection dbConn;
    private final AQjmsSession aqSess;
    private boolean synchronizationRegistered;
    boolean globalTxnFlag;

    EmulatedXAHandler(Connection connection, AQjmsSession aQjmsSession) {
        AQjmsOracleDebug.trace(3, "EmulatedXAHandler.constructor", "enter");
        this.dbConn = connection;
        this.aqSess = aQjmsSession;
        EmulatedXAHandler.lookupTransactionManager();
        if (m_tm != null) {
            AQjmsOracleDebug.trace(3, "EmulatedXAHandler.constructor", "Found the transaction manager, we are running inside container.");
        } else {
            AQjmsOracleDebug.trace(3, "EmulatedXAHandler.constructor", "Can not find the transaction manager, we are NOT running in container");
        }
        AQjmsOracleDebug.trace(3, "EmulatedXAHandler.constructor", "exit");
    }

    boolean inGlobalTrans(boolean bl) throws JMSException {
        AQjmsOracleDebug.trace(3, "EmulatedXAHandler.inGlobalTrans", "entry, reCheck=" + bl);
        if (bl) {
            this.checkForGlobalTxn();
        }
        AQjmsOracleDebug.trace(3, "EmulatedXAHandler.inGlobalTrans", "exit");
        return this.globalTxnFlag;
    }

    void checkForGlobalTxn() throws JMSException {
        block7: {
            AQjmsOracleDebug.trace(3, "EmulatedXAHandler.checkForGlobalTxn", "entry");
            if (m_tm != null) {
                try {
                    Transaction transaction = m_tm.getTransaction();
                    if (transaction == null) {
                        AQjmsOracleDebug.trace(3, "EmulatedXAHandler.checkForGlobalTxn", "container TM answers NOT IN global txn");
                        this.globalTxnFlag = false;
                        break block7;
                    }
                    AQjmsOracleDebug.trace(3, "EmulatedXAHandler.checkForGlobalTxn", "container TM answers IN global txn " + transaction);
                    this.globalTxnFlag = true;
                    if (this.synchronizationRegistered) {
                        AQjmsOracleDebug.trace(5, "EmulatedXAHandler.synchronizationRegistered=true", transaction.toString());
                        break block7;
                    }
                    AQjmsOracleDebug.trace(5, "EmulatedXAHandler.checkForGlobalTxn", "Transaction change:  --> " + transaction);
                    this.synchronizationRegistered = true;
                    transaction.registerSynchronization((Synchronization)this);
                }
                catch (Exception exception) {
                    AQjmsOracleDebug.traceEx(3, "EmulatedXAHandler.checkForGlobalTxn", exception);
                    AQjmsError.throwEx(122, (Throwable)exception);
                }
            } else {
                boolean bl = ((OracleConnection)this.dbConn).getUsingXAFlag();
                if (bl != this.globalTxnFlag) {
                    this.globalTxnFlag = bl;
                }
            }
        }
    }

    void setRollbackOnlyIfInGlobalTxn() {
        try {
            Transaction transaction;
            if (m_tm != null && (transaction = m_tm.getTransaction()) != null) {
                transaction.setRollbackOnly();
            }
        }
        catch (Throwable throwable) {
            AQjmsOracleDebug.traceEx(1, "EmulatedXAHandler.setRollbackOnlyIfInGlobalTxn", throwable);
        }
    }

    private static synchronized void lookupTransactionManager() {
        block15: {
            InitialContext initialContext;
            if (m_tm != null || tmLookupFailed) {
                return;
            }
            AQjmsOracleDebug.trace(3, "EmulatedXAHandler.constructor", "looking up the transaction manager object in container.");
            m_tm = WebLogicHelper.getTranactionManager();
            if (m_tm != null) {
                return;
            }
            try {
                initialContext = new InitialContext();
            }
            catch (NamingException namingException) {
                AQjmsOracleDebug.traceEx(3, "EmulatedXAHandler.constructor cannot create initial context", namingException);
                break block15;
            }
            try {
                m_tm = (TransactionManager)initialContext.lookup(JNDI_OC4J_TRANS_MANAGER);
            }
            catch (Throwable throwable) {
                AQjmsOracleDebug.traceEx(3, "EmulatedXAHandler.constructor cannot find OC4J transaction manager", throwable);
            }
            finally {
                try {
                    initialContext.close();
                }
                catch (NamingException namingException) {
                    AQjmsOracleDebug.traceEx(3, "InitialContext.close failed", namingException);
                }
            }
        }
        tmLookupFailed = true;
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int n) {
        this.aqSess.restartConsumers();
        this.synchronizationRegistered = false;
    }
}

