/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.sql.DataSource;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsConnectionFactory;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsUtil;
import oracle.jms.WebLogicHelper;

public class AQjmsTopicConnectionFactory
extends AQjmsConnectionFactory
implements TopicConnectionFactory,
Serializable {
    AQjmsTopicConnectionFactory(String string, String string2, int n, String string3) throws JMSException {
        this.hostname = string;
        this.oracle_sid = string2;
        this.portno = n;
        this.data_source = null;
        if (string3 != null) {
            if (string3.equalsIgnoreCase("thin")) {
                this.jdbc_driver = "thin";
            } else if (string3.equalsIgnoreCase("oci8")) {
                this.jdbc_driver = "oci8";
            } else if (string3.equalsIgnoreCase("oci")) {
                this.jdbc_driver = "oci";
            } else {
                AQjmsError.throwEx(135, string3);
            }
        } else {
            this.jdbc_driver = "thin";
        }
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
    }

    AQjmsTopicConnectionFactory(String string, Properties properties) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.data_source = null;
        this.jdbc_conn_str = string;
        this.jdbc_info = properties;
    }

    AQjmsTopicConnectionFactory(DataSource dataSource) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
        this.data_source = dataSource;
        AQjmsOracleDebug.trace(5, "AQjmsTopicConnectionFactory - constructor", "data source object: " + dataSource);
    }

    AQjmsTopicConnectionFactory(DataSource dataSource, String string, Properties properties) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.data_source = dataSource;
        this.jdbc_conn_str = string;
        this.jdbc_info = properties;
    }

    AQjmsTopicConnectionFactory(String string) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
        this.data_source = (DataSource)AQjmsUtil.lookupObject(string, DataSource.class);
        AQjmsOracleDebug.trace(5, "AQjmsTopicConnectionFactory - constructor", "data source name: " + string);
    }

    public AQjmsTopicConnectionFactory() {
    }

    public TopicConnection createTopicConnection() throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        if (WebLogicHelper.runningInWLServer()) {
            if (this.data_source == null) {
                throw new UnsupportedOperationException("WebLogic server side components must use AQ JMS datasource configuration");
            }
            aQjmsConnection = new AQjmsConnection(this.data_source, null, null, 20);
        } else {
            aQjmsConnection = this.jdbc_conn_str != null ? new AQjmsConnection(this.jdbc_conn_str, this.jdbc_info, 20) : (this.data_source != null ? new AQjmsConnection(this.data_source, null, null, 20) : new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, null, null, this.jdbc_driver, 20));
        }
        aQjmsConnection.setCompliant(this.compliant);
        return aQjmsConnection;
    }

    public TopicConnection createTopicConnectionInternal() throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        aQjmsConnection = this.data_source != null ? new AQjmsConnection(this.data_source, null, null, 20) : (this.jdbc_conn_str != null ? new AQjmsConnection(this.jdbc_conn_str, this.jdbc_info, 20) : new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, null, null, this.jdbc_driver, 20));
        aQjmsConnection.setCompliant(this.compliant);
        return aQjmsConnection;
    }

    public TopicConnection createTopicConnection(String string, String string2) throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        if (WebLogicHelper.runningInWLServer()) {
            if (this.data_source == null) {
                throw new UnsupportedOperationException("WebLogic server side components must use AQ JMS datasource configuration");
            }
            aQjmsConnection = new AQjmsConnection(this.data_source, string, string2, 20);
        } else {
            Properties properties = null;
            if (this.jdbc_conn_str != null) {
                if (this.jdbc_info != null) {
                    if (string != null || string2 != null) {
                        properties = (Properties)this.jdbc_info.clone();
                        properties.put("user", string);
                        properties.put("password", string2);
                    } else {
                        properties = this.jdbc_info;
                    }
                    aQjmsConnection = new AQjmsConnection(this.jdbc_conn_str, properties, 20);
                } else {
                    aQjmsConnection = new AQjmsConnection(this.jdbc_conn_str, string, string2, 20);
                }
            } else {
                aQjmsConnection = this.data_source != null ? new AQjmsConnection(this.data_source, string, string2, 20) : new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, string, string2, this.jdbc_driver, 20);
            }
        }
        aQjmsConnection.setCompliant(this.compliant);
        return aQjmsConnection;
    }

    public static TopicConnection createTopicConnection(Connection connection) throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        aQjmsConnection = new AQjmsConnection(connection, 20);
        return aQjmsConnection;
    }

    public static TopicConnection createTopicConnection(Connection connection, boolean bl) throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        aQjmsConnection = new AQjmsConnection(connection, 20);
        aQjmsConnection.setCompliant(bl);
        return aQjmsConnection;
    }

    public static TopicConnection createTopicConnection(OracleOCIConnectionPool oracleOCIConnectionPool) throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        aQjmsConnection = new AQjmsConnection(oracleOCIConnectionPool, 20);
        return aQjmsConnection;
    }

    public static TopicConnection createTopicConnection(OracleOCIConnectionPool oracleOCIConnectionPool, boolean bl) throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        aQjmsConnection = new AQjmsConnection(oracleOCIConnectionPool, 20);
        aQjmsConnection.setCompliant(bl);
        return aQjmsConnection;
    }

    @Override
    boolean getCompliant() {
        return this.compliant;
    }

    @Override
    void setCompliant(boolean bl) {
        this.compliant = bl;
        AQjmsOracleDebug.trace(4, "AQjmsTopicConnectionFactory.setCompliant", "Current <compliant> is set to:" + bl);
    }
}

