/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import javax.jms.JMSException;
import javax.jms.Session;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsXAException;

public class AQjmsEmulatedXAResource
implements XAResource {
    private Session m_session;
    private int m_transactionTimeout;

    public AQjmsEmulatedXAResource(Session session) {
        this.m_session = session;
    }

    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.commit", "enter: xid=" + xid + " onePhase=" + bl);
        try {
            this.m_session.commit();
        }
        catch (JMSException jMSException) {
            AQjmsOracleDebug.traceEx(1, "AQjmsEmulatedXAResource.commit", jMSException);
            throw new AQjmsXAException(jMSException, "AQjmsEmulatedXAResource.commit failed. xid=" + xid + ", onePhase=" + bl);
        }
        if (this.m_session instanceof AQjmsSession && !AQjmsConstants.ignorePriority()) {
            ((AQjmsSession)this.m_session).restartConsumers();
        }
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.commit", "exit");
    }

    @Override
    public void end(Xid xid, int n) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.end", "enter: xid=" + xid + " flags=" + n);
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.end", "exit");
    }

    @Override
    public void forget(Xid xid) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.forget", "enter: xid=" + xid);
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.forget", "exit");
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.getTransactionTimeout", "enter");
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.getTransactionTimeout", "exit: transaction timeout=" + this.m_transactionTimeout);
        return this.m_transactionTimeout;
    }

    @Override
    public boolean isSameRM(XAResource xAResource) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.isSameRM", "enter");
        boolean bl = false;
        bl = xAResource == null ? false : (this == xAResource ? true : (xAResource instanceof AQjmsEmulatedXAResource ? this.m_session == ((AQjmsEmulatedXAResource)xAResource).m_session : false));
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.isSameRM: isSameRM=" + bl, "exit");
        return bl;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.prepare", "enter: xid=" + xid);
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.prepare", "exit");
        return 0;
    }

    @Override
    public Xid[] recover(int n) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.recover", "enter: flag=" + n);
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.recover", "exit");
        return new Xid[0];
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.rollback", "enter: xid=" + xid);
        try {
            this.m_session.rollback();
        }
        catch (JMSException jMSException) {
            AQjmsOracleDebug.traceEx(1, "AQjmsEmulatedXAResource.rollback", jMSException);
            throw new AQjmsXAException(jMSException, "AQjmsEmulatedXAResource.rollback failed. xid=" + xid);
        }
        if (this.m_session instanceof AQjmsSession) {
            ((AQjmsSession)this.m_session).restartConsumers();
        }
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.rollback", "exit");
    }

    @Override
    public boolean setTransactionTimeout(int n) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.setTransactionTimeout", "enter: seconds=" + n);
        this.m_transactionTimeout = n;
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.setTransactionTimeout", "exit");
        return true;
    }

    @Override
    public void start(Xid xid, int n) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.start", "enter: xid=" + xid + " flags=" + n);
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.start", "exit");
    }
}

