/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.url.parser;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

final class ParserUtils {
    ParserUtils() {
    }

    public static boolean isValidIPv4(String ip) {
        String[] parts = ip.split("\\.");
        if (parts.length != 4) {
            return false;
        }
        for (String part : parts) {
            try {
                int num = Integer.parseInt(part);
                if (num < 0 || num > 255) {
                    return false;
                }
                if (part.length() <= 1 || !part.startsWith("0")) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    @SafeVarargs
    static <T> Set<T> setOf(T ... arg) {
        return new HashSet<T>(Arrays.asList(arg));
    }
}

