/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import oracle.jdbc.OracleXAConnectionBuilder;
import oracle.jdbc.datasource.OracleXAConnection;
import oracle.jdbc.datasource.impl.OracleConnectionBuilderImpl;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.xa.OracleXAConnectionBuilderImpl;

@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.XA, Feature.HIGH_AVAILABILITY, Feature.CONN_POOL, Feature.APPLICATION_CONTINUITY})
public abstract class OracleXADataSource
extends OracleConnectionPoolDataSource
implements oracle.jdbc.datasource.OracleXADataSource,
oracle.jdbc.replay.internal.OracleXADataSource {
    protected boolean useNativeXA = false;

    public OracleXADataSource() throws SQLException {
        this.dataSourceName = "OracleXADataSource";
    }

    @Override
    public abstract XAConnection getXAConnection() throws SQLException;

    @Override
    public abstract XAConnection getXAConnection(String var1, @Blind String var2) throws SQLException;

    public abstract XAConnection getXAConnection(Properties var1) throws SQLException;

    @Override
    public void setURL(String string) {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            super.setURL(string);
            if (string != null) {
                if (string.startsWith("jdbc:oracle:thin")) {
                    this.useNativeXA = true;
                } else if (string.startsWith("jdbc:oracle:oci") || string.startsWith("jdbc:oracle:oci8")) {
                    this.useNativeXA = false;
                }
            }
        }
    }

    public void setNativeXA(boolean bl) {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            this.useNativeXA = bl;
        }
    }

    public boolean getNativeXA() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            boolean bl = this.useNativeXA;
            return bl;
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Override
    public OracleXAConnectionBuilder createXAConnectionBuilder() {
        return new OracleXAConnectionBuilderImpl(){

            @Override
            public OracleXAConnection build() throws SQLException {
                OracleConnectionBuilderImpl oracleConnectionBuilderImpl = (OracleConnectionBuilderImpl)OracleXADataSource.this.createConnectionBuilder().copy(this);
                oracleConnectionBuilderImpl.verifyBuildConfiguration();
                return (OracleXAConnection)((Object)OracleXADataSource.this.getPooledConnection(oracleConnectionBuilderImpl));
            }
        };
    }
}

