/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.StringWriter;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import oracle.jdbc.driver.json.JakartaGeneratorWrapper;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.OsonAbstractObject;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.binary.OsonObjectImpl;

public class JakartaOsonObject
extends OsonAbstractObject
implements JsonObject,
Wrapper {
    public JakartaOsonObject(OsonContext osonContext) {
        super(osonContext);
    }

    public JakartaOsonObject(OsonContext osonContext, int n2) {
        super(osonContext, n2);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(new OsonObjectImpl(new OsonContext(this.ctx), this.pos));
        }
        catch (ClassCastException classCastException) {
            throw new SQLException(classCastException.getMessage(), classCastException);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isAssignableFrom(OsonObjectImpl.class);
    }

    public JsonValue get(Object object) {
        return (JsonValue)this.getInternal(object);
    }

    public JsonArray getJsonArray(String string) {
        return (JsonArray)this.getJsonArrayInternal(string);
    }

    public JsonObject getJsonObject(String string) {
        return (JsonObject)this.getJsonObjectInternal(string);
    }

    public JsonNumber getJsonNumber(String string) {
        int n2 = this.getChildOffset(string);
        if (n2 < 0) {
            return null;
        }
        return (JsonNumber)this.getValueInternal(n2);
    }

    public JsonString getJsonString(String string) {
        return (JsonString)this.get(string);
    }

    @Override
    public String getString(String string) {
        return this.getJsonString(string).getString();
    }

    @Override
    public String getString(String string, String string2) {
        JsonValue jsonValue = this.get(string);
        if (jsonValue == null) {
            return string2;
        }
        if (jsonValue.getValueType() == JsonValue.ValueType.STRING) {
            return ((JsonString)jsonValue).getString();
        }
        return string2;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.OBJECT;
    }

    public JsonValue put(String string, JsonValue jsonValue) {
        throw new UnsupportedOperationException();
    }

    public JsonValue remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map<? extends String, ? extends JsonValue> map) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Collection<JsonValue> values() {
        return new OsonAbstractObject.OsonObjectValues<JsonValue>(this);
    }

    public Set<Map.Entry<String, JsonValue>> entrySet() {
        return new OsonAbstractObject.OsonEntrySet<JsonValue>(this);
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        for (Map.Entry<String, JsonValue> entry : this.entrySet()) {
            n2 += entry.hashCode();
        }
        return n2;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        JakartaGeneratorWrapper jakartaGeneratorWrapper = new JakartaGeneratorWrapper(new JsonSerializerImpl(stringWriter));
        jakartaGeneratorWrapper.write((JsonValue)this);
        jakartaGeneratorWrapper.close();
        return stringWriter.toString();
    }
}

