/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jdbc.nl;

import java.io.PrintStream;
import java.util.Vector;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.jdbc.nl.InvalidSyntaxException;

public final class NVPair {
    public static int RHS_NONE = 0;
    public static int RHS_ATOM = 1;
    public static int RHS_LIST = 2;
    public static int LIST_REGULAR = 3;
    public static int LIST_COMMASEP = 4;
    private String _name;
    private int _rhsType;
    private String _atom;
    private Vector _list;
    private int _listType;
    private NVPair _parent;
    private String _linesep = System.getProperty("line.separator");

    public NVPair(String string) {
        this._name = string;
        this._atom = null;
        this._list = null;
        this._listType = LIST_REGULAR;
        this._parent = null;
        this._rhsType = RHS_NONE;
    }

    public NVPair(String string, String string2) throws InvalidSyntaxException {
        this(string);
        this.setAtom(string2);
    }

    public NVPair(String string, NVPair nVPair) {
        this(string);
        this.addListElement(nVPair);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public NVPair getParent() {
        return this._parent;
    }

    private void _setParent(NVPair nVPair) {
        this._parent = nVPair;
    }

    public int getRHSType() {
        return this._rhsType;
    }

    public int getListType() {
        return this._listType;
    }

    public void setListType(int n2) {
        this._listType = n2;
    }

    public String getAtom() {
        return this._atom;
    }

    public void setAtom(String string) throws InvalidSyntaxException {
        if (this._name.indexOf("COMMENT") == -1 && this.containsComment(string)) {
            Object[] objectArray = new Object[]{"#", this.getName()};
            throw new InvalidSyntaxException("UnexpectedChar-04603", objectArray);
        }
        this._rhsType = RHS_ATOM;
        this._atom = string;
        this._list = null;
    }

    private boolean containsComment(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) != '#') continue;
            if (i2 != 0) {
                if (string.charAt(i2 - 1) == '\\') continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public int getListSize() {
        if (this._list == null) {
            return 0;
        }
        return this._list.size();
    }

    public NVPair getListElement(int n2) {
        if (this._list == null) {
            return null;
        }
        return (NVPair)this._list.elementAt(n2);
    }

    public void addListElement(NVPair nVPair) {
        if (this._list == null) {
            this._rhsType = RHS_LIST;
            this._list = new Vector(3, 5);
            this._atom = null;
        }
        this._list.addElement(nVPair);
        nVPair._setParent(this);
    }

    public void removeListElement(int n2) {
        if (this._list != null) {
            this._list.removeElementAt(n2);
            if (this.getListSize() == 0) {
                this._list = null;
                this._rhsType = RHS_NONE;
            }
        }
    }

    private String space(int n2) {
        String string = new String("");
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + " ";
        }
        return string;
    }

    public String trimValueToString() {
        String string = this.valueToString().trim();
        return string.substring(1, string.length() - 1);
    }

    public String valueToString() {
        String string;
        block3: {
            block4: {
                block2: {
                    string = "";
                    if (this._rhsType != RHS_ATOM) break block2;
                    string = string + this._atom;
                    break block3;
                }
                if (this._rhsType != RHS_LIST) break block3;
                if (this._listType != LIST_REGULAR) break block4;
                for (int i2 = 0; i2 < this.getListSize(); ++i2) {
                    string = string + this.getListElement(i2).toString();
                }
                break block3;
            }
            if (this._listType != LIST_COMMASEP) break block3;
            for (int i3 = 0; i3 < this.getListSize(); ++i3) {
                NVPair nVPair = this.getListElement(i3);
                string = string + nVPair.getName();
                if (i3 == this.getListSize() - 1) continue;
                string = string + ", ";
            }
        }
        return string;
    }

    @DisableTrace
    public String toString() {
        String string = "(" + this._name + "=";
        if (this._rhsType == RHS_ATOM) {
            string = string + this._atom;
        } else if (this._rhsType == RHS_LIST) {
            if (this._listType == LIST_REGULAR) {
                for (int i2 = 0; i2 < this.getListSize(); ++i2) {
                    string = string + this.getListElement(i2).toString();
                }
            } else if (this._listType == LIST_COMMASEP) {
                string = string + " (";
                for (int i3 = 0; i3 < this.getListSize(); ++i3) {
                    NVPair nVPair = this.getListElement(i3);
                    string = string + nVPair.getName();
                    if (i3 == this.getListSize() - 1) continue;
                    string = string + ", ";
                }
                string = string + ")";
            }
        }
        string = string + ")";
        return string;
    }

    @DisableTrace
    public String toString(int n2, boolean bl) {
        String string = "";
        String string2 = new String(this._name);
        if (this._rhsType == RHS_LIST) {
            if (this._listType == LIST_REGULAR) {
                String string3 = "";
                for (int i2 = 0; i2 < this.getListSize(); ++i2) {
                    string3 = string2.equalsIgnoreCase("ADDRESS") || string2.equalsIgnoreCase("RULE") ? string3 + this.getListElement(i2).toString(n2 + 1, false) : string3 + this.getListElement(i2).toString(n2 + 1, true);
                }
                if (!string3.equals("")) {
                    string = string2.equalsIgnoreCase("ADDRESS") || string2.equalsIgnoreCase("RULE") ? string + this.space(n2 * 2) + "(" + this._name + " = " : string + this.space(n2 * 2) + "(" + this._name + " =" + this._linesep;
                    string = string + string3;
                    string = string2.equalsIgnoreCase("ADDRESS") || string2.equalsIgnoreCase("RULE") ? string + ")" + this._linesep : (n2 == 0 ? string + ")" : (n2 == 1 ? string + this.space(n2 * 2) + ")" : string + this.space(n2 * 2) + ")" + this._linesep));
                }
            } else if (this._listType == LIST_COMMASEP) {
                string = string + "(" + this._name + "= (";
                for (int i3 = 0; i3 < this.getListSize(); ++i3) {
                    NVPair nVPair = this.getListElement(i3);
                    string = string + nVPair.getName();
                    if (i3 == this.getListSize() - 1) continue;
                    string = string + ", ";
                }
                string = string + "))";
            }
        } else if (this._rhsType == RHS_ATOM) {
            if (n2 == 0) {
                if (string2.indexOf("COMMENT") != -1) {
                    this._atom = this.modifyCommentString(this._atom);
                    string = string + "(" + this._atom + ")";
                } else {
                    string = string + "(" + this._name + " = " + this._atom + ")";
                }
            } else if (string2.indexOf("COMMENT") != -1) {
                this._atom = this.modifyCommentString(this._atom);
                string = string + this._atom + this._linesep;
            } else if (!bl) {
                string = string + "(" + this._name + " = " + this._atom + ")";
            } else {
                string = string + this.space(n2 * 2) + "(" + this._name + " = " + this._atom + ")";
                string = string + this._linesep;
            }
        }
        return string;
    }

    public String modifyCommentString(String string) {
        String string2 = "";
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\\': {
                    if (string.charAt(i2 + 1) != '(' && string.charAt(i2 + 1) != '=' && string.charAt(i2 + 1) != ')' && string.charAt(i2 + 1) != ',' && string.charAt(i2 + 1) != '\\') break;
                }
            }
            int n2 = ++i2;
            string2 = string2 + string.charAt(n2);
        }
        return string2;
    }

    public void println() {
        System.out.println(this.toString());
    }

    public void println(PrintStream printStream) {
        if (this._rhsType == RHS_ATOM) {
            printStream.println("          (" + this._name + " = " + this._atom + ")");
        } else if (this._rhsType == RHS_LIST) {
            for (int i2 = 0; i2 < this.getListSize(); ++i2) {
                this.getListElement(i2).println(printStream);
            }
        }
    }
}

