/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import oracle.jdbc.driver.json.binary.JsonpOsonValueFactory;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.sql.NUMBER;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonDecimalImpl
extends OracleJsonNumberImpl
implements OracleJsonDecimal {
    public static String NEGATIVE_INF = "\"-Inf\"";
    public static String POSITIVE_INF = "\"Inf\"";
    byte[] raw;
    OracleJsonDecimal.TargetType type;
    private static DecimalFormat SCIENTIFIC_FORMAT_POSITIVE_EXP;
    private static DecimalFormat SCIENTIFIC_FORMAT_NEGATIVE_EXP;

    public OracleJsonDecimalImpl(BigDecimal bigDecimal) {
        this.raw = OsonPrimitiveConversions.toNumber(bigDecimal);
    }

    public OracleJsonDecimalImpl(long l2) {
        this.raw = OsonPrimitiveConversions.toNumber(l2);
        this.type = OracleJsonDecimal.TargetType.LONG;
    }

    public OracleJsonDecimalImpl(int n2) {
        this.raw = OsonPrimitiveConversions.toNumber((long)n2);
        this.type = OracleJsonDecimal.TargetType.INT;
    }

    public OracleJsonDecimalImpl(byte[] byArray, OracleJsonDecimal.TargetType targetType) {
        this.raw = byArray;
        this.type = targetType;
    }

    public OracleJsonDecimalImpl(long l2, OracleJsonDecimal.TargetType targetType) {
        this.raw = OsonPrimitiveConversions.toNumber(l2);
        this.type = targetType;
    }

    public OracleJsonDecimalImpl(int n2, OracleJsonDecimal.TargetType targetType) {
        this.raw = OsonPrimitiveConversions.toNumber((long)n2);
        this.type = targetType;
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.DECIMAL;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OracleJsonDecimal)) {
            return false;
        }
        OracleJsonDecimal oracleJsonDecimal = (OracleJsonDecimal)object;
        return this.bigDecimalValue().equals(oracleJsonDecimal.bigDecimalValue());
    }

    @Override
    public int hashCode() {
        return this.bigDecimalValue().hashCode();
    }

    public void reset(byte[] byArray, OracleJsonDecimal.TargetType targetType) {
        this.raw = byArray;
        this.type = targetType;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return OsonPrimitiveConversions.toBigDecimal(this.raw);
    }

    public byte[] raw() {
        return this.raw;
    }

    @Override
    public String getString() {
        BigDecimal bigDecimal;
        int n2;
        int n3 = this.raw.length;
        if (n3 <= 2) {
            if (OsonPrimitiveConversions.isNegInf(this.raw, n3, 0)) {
                return NEGATIVE_INF;
            }
            if (OsonPrimitiveConversions.isPosInf(this.raw)) {
                return POSITIVE_INF;
            }
        }
        if ((n2 = (bigDecimal = OsonPrimitiveConversions.toBigDecimal(this.raw)).precision()) <= 40) {
            return bigDecimal.toPlainString();
        }
        return OracleJsonDecimalImpl.format(bigDecimal);
    }

    private static String format(BigDecimal bigDecimal) {
        DecimalFormat decimalFormat = bigDecimal.scale() < 0 ? (DecimalFormat)SCIENTIFIC_FORMAT_NEGATIVE_EXP.clone() : (DecimalFormat)SCIENTIFIC_FORMAT_POSITIVE_EXP.clone();
        return decimalFormat.format(bigDecimal);
    }

    public boolean isDec() {
        return this.type == OracleJsonDecimal.TargetType.DECIMAL;
    }

    public boolean isSB4() {
        return this.type == OracleJsonDecimal.TargetType.INT;
    }

    public boolean isSB8() {
        return this.type == OracleJsonDecimal.TargetType.LONG;
    }

    @Override
    public NUMBER getNUMBER() {
        return new NUMBER(this.raw());
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        return clazz.cast(JsonpOsonValueFactory.INSTANCE.createNumber(this.raw, this.type));
    }

    @Override
    public OracleJsonDecimal.TargetType getTargetType() {
        return this.type;
    }

    static {
        int n2 = 40;
        StringBuilder stringBuilder = new StringBuilder(n2 + 5);
        stringBuilder.append("0.");
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append('#');
        }
        stringBuilder.append("E0");
        DecimalFormat decimalFormat = new DecimalFormat(stringBuilder.toString(), DecimalFormatSymbols.getInstance(Locale.US));
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        SCIENTIFIC_FORMAT_POSITIVE_EXP = decimalFormat;
        SCIENTIFIC_FORMAT_NEGATIVE_EXP = (DecimalFormat)decimalFormat.clone();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setExponentSeparator("E+");
        SCIENTIFIC_FORMAT_POSITIVE_EXP.setDecimalFormatSymbols(decimalFormatSymbols);
    }

    public static enum NumberType {
        NONE,
        SB4,
        SB8,
        DEC128;

    }
}

