/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.sql.SQLException;

public interface OracleLargeObject<T> {
    public void freeTemporary() throws SQLException;

    public boolean isTemporary() throws SQLException;

    public short getDuration() throws SQLException;

    public boolean isFree();

    public void setPrefetchData(PrefetchData<T> var1);

    public PrefetchData<T> getPrefetchData();

    public static final class ArrayPrefetchData<T>
    implements PrefetchData<T> {
        private final T array;
        private final int length;

        private ArrayPrefetchData(T t2, int n2) {
            this.array = t2;
            this.length = n2;
        }

        @Override
        public int copy(int n2, T t2, int n3, int n4) {
            int n5 = Math.min(n4, this.length - n2);
            if (n5 < 1) {
                return 0;
            }
            System.arraycopy(this.array, n2, t2, n3, n5);
            return n5;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public T share() {
            return this.array;
        }
    }

    public static interface PrefetchData<T> {
        public static <T> PrefetchData<T> wrapArray(T t2, int n2) {
            if (!(1.$assertionsDisabled || t2 != null && t2.getClass().isArray())) {
                throw new AssertionError((Object)("Not an array: " + t2));
            }
            return new ArrayPrefetchData(t2, n2);
        }

        public int copy(int var1, T var2, int var3, int var4);

        public int length();

        public T share();

        static {
            if (1.$assertionsDisabled) {
                // empty if block
            }
        }
    }
}

