/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.sdk;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.optimizely.ab.Optimizely;
import com.optimizely.ab.UnknownEventTypeException;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.Variation;
import com.optimizely.ab.notification.NotificationCenter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class OptimizelyClient {
    private final Logger logger;
    @Nullable
    private Optimizely optimizely;
    @NonNull
    private Map<String, ?> defaultAttributes = new HashMap();

    OptimizelyClient(@Nullable Optimizely optimizely, @NonNull Logger logger) {
        this.optimizely = optimizely;
        this.logger = logger;
    }

    protected void setDefaultAttributes(@NonNull Map<String, ?> attrs) {
        this.defaultAttributes = attrs;
    }

    @NonNull
    public Map<String, ?> getDefaultAttributes() {
        return this.defaultAttributes;
    }

    private Map<String, ?> getAllAttributes(@NonNull Map<String, ?> attrs) {
        HashMap combinedMap = new HashMap(this.defaultAttributes);
        if (attrs != null) {
            combinedMap.putAll(attrs);
        } else if (combinedMap.isEmpty()) {
            combinedMap = null;
        }
        return combinedMap;
    }

    @Nullable
    public Variation activate(@NonNull String experimentKey, @NonNull String userId) {
        if (this.isValid()) {
            return this.optimizely.activate(experimentKey, userId, this.getDefaultAttributes());
        }
        this.logger.warn("Optimizely is not initialized, could not activate experiment {} for user {}", (Object)experimentKey, (Object)userId);
        return null;
    }

    @Nullable
    public Variation activate(@NonNull String experimentKey, @NonNull String userId, @NonNull Map<String, ?> attributes) {
        if (this.isValid()) {
            return this.optimizely.activate(experimentKey, userId, this.getAllAttributes(attributes));
        }
        this.logger.warn("Optimizely is not initialized, could not activate experiment {} for user {} with attributes", (Object)experimentKey, (Object)userId);
        return null;
    }

    @Nullable
    public ProjectConfig getProjectConfig() {
        if (this.isValid()) {
            return this.optimizely.getProjectConfig();
        }
        this.logger.warn("Optimizely is not initialized, could not get project config");
        return null;
    }

    public boolean isValid() {
        if (this.optimizely != null) {
            return this.optimizely.isValid();
        }
        return false;
    }

    public void track(@NonNull String eventName, @NonNull String userId) {
        if (this.isValid()) {
            try {
                this.optimizely.track(eventName, userId, this.getDefaultAttributes());
            }
            catch (Exception e) {
                this.logger.error("Unable to track event", (Throwable)e);
            }
        } else {
            this.logger.warn("Optimizely is not initialized, could not track event {} for user {}", (Object)eventName, (Object)userId);
        }
    }

    public void track(@NonNull String eventName, @NonNull String userId, @NonNull Map<String, ?> attributes) throws UnknownEventTypeException {
        if (this.isValid()) {
            this.optimizely.track(eventName, userId, this.getAllAttributes(attributes));
        } else {
            this.logger.warn("Optimizely is not initialized, could not track event {} for user {} with attributes", (Object)eventName, (Object)userId);
        }
    }

    public void track(@NonNull String eventName, @NonNull String userId, @NonNull Map<String, ?> attributes, @NonNull Map<String, ?> eventTags) throws UnknownEventTypeException {
        if (this.isValid()) {
            this.optimizely.track(eventName, userId, this.getAllAttributes(attributes), eventTags);
        } else {
            this.logger.warn("Optimizely is not initialized, could not track event {} for user {} with attributes and event tags", (Object)eventName, (Object)userId);
        }
    }

    @Nullable
    public Variation getVariation(@NonNull String experimentKey, @NonNull String userId) {
        if (this.isValid()) {
            return this.optimizely.getVariation(experimentKey, userId, this.getDefaultAttributes());
        }
        this.logger.warn("Optimizely is not initialized, could not get variation for experiment {} for user {}", (Object)experimentKey, (Object)userId);
        return null;
    }

    @Nullable
    public Variation getVariation(@NonNull String experimentKey, @NonNull String userId, @NonNull Map<String, ?> attributes) {
        if (this.isValid()) {
            return this.optimizely.getVariation(experimentKey, userId, this.getAllAttributes(attributes));
        }
        this.logger.warn("Optimizely is not initialized, could not get variation for experiment {} for user {} with attributes", (Object)experimentKey, (Object)userId);
        return null;
    }

    public boolean setForcedVariation(@NonNull String experimentKey, @NonNull String userId, @Nullable String variationKey) {
        if (this.isValid()) {
            return this.optimizely.setForcedVariation(experimentKey, userId, variationKey);
        }
        this.logger.warn("Optimizely is not initialized, could not set forced variation");
        return false;
    }

    @Nullable
    public Variation getForcedVariation(@NonNull String experimentKey, @NonNull String userId) {
        if (this.isValid()) {
            return this.optimizely.getForcedVariation(experimentKey, userId);
        }
        this.logger.warn("Optimizely is not initialized, could not get forced variation");
        return null;
    }

    public List<String> getEnabledFeatures(@NonNull String userId, @NonNull Map<String, ?> attributes) {
        if (this.isValid()) {
            return this.optimizely.getEnabledFeatures(userId, attributes);
        }
        this.logger.warn("Optimizely is not initialized, could not get enabled feature for user {}", (Object)userId);
        return null;
    }

    @NonNull
    public Boolean isFeatureEnabled(@NonNull String featureKey, @NonNull String userId) {
        if (this.isValid()) {
            return this.optimizely.isFeatureEnabled(featureKey, userId);
        }
        this.logger.warn("Optimizely is not initialized, could not enable feature {} for user {}", (Object)featureKey, (Object)userId);
        return false;
    }

    @NonNull
    public Boolean isFeatureEnabled(@NonNull String featureKey, @NonNull String userId, @NonNull Map<String, ?> attributes) {
        if (this.isValid()) {
            return this.optimizely.isFeatureEnabled(featureKey, userId, attributes);
        }
        this.logger.warn("Optimizely is not initialized, could not enable feature {} for user {} with attributes", (Object)featureKey, (Object)userId);
        return false;
    }

    @Nullable
    public Boolean getFeatureVariableBoolean(@NonNull String featureKey, @NonNull String variableKey, @NonNull String userId) {
        if (this.isValid()) {
            return this.optimizely.getFeatureVariableBoolean(featureKey, variableKey, userId);
        }
        this.logger.warn("Optimizely is not initialized, could not get feature {} variable {} boolean for user {}", new Object[]{featureKey, variableKey, userId});
        return null;
    }

    @Nullable
    public Boolean getFeatureVariableBoolean(@NonNull String featureKey, @NonNull String variableKey, @NonNull String userId, @NonNull Map<String, ?> attributes) {
        if (this.isValid()) {
            return this.optimizely.getFeatureVariableBoolean(featureKey, variableKey, userId, attributes);
        }
        this.logger.warn("Optimizely is not initialized, could not get feature {} variable {} boolean for user {} with attributes", new Object[]{featureKey, variableKey, userId});
        return null;
    }

    @Nullable
    public Double getFeatureVariableDouble(@NonNull String featureKey, @NonNull String variableKey, @NonNull String userId) {
        if (this.isValid()) {
            return this.optimizely.getFeatureVariableDouble(featureKey, variableKey, userId);
        }
        this.logger.warn("Optimizely is not initialized, could not get feature {} variable {} double for user {}", new Object[]{featureKey, variableKey, userId});
        return null;
    }

    @Nullable
    public Double getFeatureVariableDouble(@NonNull String featureKey, @NonNull String variableKey, @NonNull String userId, @NonNull Map<String, ?> attributes) {
        if (this.isValid()) {
            return this.optimizely.getFeatureVariableDouble(featureKey, variableKey, userId, attributes);
        }
        this.logger.warn("Optimizely is not initialized, could not get feature {} variable {} double for user {} with attributes", new Object[]{featureKey, variableKey, userId});
        return null;
    }

    @Nullable
    public Integer getFeatureVariableInteger(@NonNull String featureKey, @NonNull String variableKey, @NonNull String userId) {
        if (this.isValid()) {
            return this.optimizely.getFeatureVariableInteger(featureKey, variableKey, userId);
        }
        this.logger.warn("Optimizely is not initialized, could not get feature {} variable {} integer for user {}", new Object[]{featureKey, variableKey, userId});
        return null;
    }

    @Nullable
    public Integer getFeatureVariableInteger(@NonNull String featureKey, @NonNull String variableKey, @NonNull String userId, @NonNull Map<String, ?> attributes) {
        if (this.isValid()) {
            return this.optimizely.getFeatureVariableInteger(featureKey, variableKey, userId, attributes);
        }
        this.logger.warn("Optimizely is not initialized, could not get feature {} variable {} integer for user {} with attributes", new Object[]{featureKey, variableKey, userId});
        return null;
    }

    @Nullable
    public String getFeatureVariableString(@NonNull String featureKey, @NonNull String variableKey, @NonNull String userId) {
        if (this.isValid()) {
            return this.optimizely.getFeatureVariableString(featureKey, variableKey, userId);
        }
        this.logger.warn("Optimizely is not initialized, could not get feature {} variable {} string for user {}", new Object[]{featureKey, variableKey, userId});
        return null;
    }

    @Nullable
    public String getFeatureVariableString(@NonNull String featureKey, @NonNull String variableKey, @NonNull String userId, @NonNull Map<String, ?> attributes) {
        if (this.isValid()) {
            return this.optimizely.getFeatureVariableString(featureKey, variableKey, userId, attributes);
        }
        this.logger.warn("Optimizely is not initialized, could not get feature {} variable {} string for user {} with attributes", new Object[]{featureKey, variableKey, userId});
        return null;
    }

    @Nullable
    public NotificationCenter getNotificationCenter() {
        if (this.isValid()) {
            return this.optimizely.notificationCenter;
        }
        this.logger.warn("Optimizely is not initialized, could not get the notification listener");
        return null;
    }
}

