/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.sdk;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import android.support.annotation.RequiresApi;
import android.support.annotation.VisibleForTesting;
import com.optimizely.ab.Optimizely;
import com.optimizely.ab.android.datafile_handler.DatafileHandler;
import com.optimizely.ab.android.datafile_handler.DatafileLoadedListener;
import com.optimizely.ab.android.datafile_handler.DatafileService;
import com.optimizely.ab.android.datafile_handler.DefaultDatafileHandler;
import com.optimizely.ab.android.event_handler.DefaultEventHandler;
import com.optimizely.ab.android.sdk.OptimizelyClient;
import com.optimizely.ab.android.sdk.OptimizelyClientEngine;
import com.optimizely.ab.android.sdk.OptimizelyDefaultAttributes;
import com.optimizely.ab.android.sdk.OptimizelyStartListener;
import com.optimizely.ab.android.user_profile.DefaultUserProfileService;
import com.optimizely.ab.bucketing.UserProfileService;
import com.optimizely.ab.config.parser.ConfigParseException;
import com.optimizely.ab.error.ErrorHandler;
import com.optimizely.ab.event.EventHandler;
import com.optimizely.ab.event.internal.payload.Event;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizelyManager {
    @NonNull
    private OptimizelyClient optimizelyClient = new OptimizelyClient(null, LoggerFactory.getLogger(OptimizelyClient.class));
    @NonNull
    private DatafileHandler datafileHandler;
    private final long datafileDownloadInterval;
    private final long eventDispatchInterval;
    @Nullable
    private EventHandler eventHandler = null;
    @Nullable
    private ErrorHandler errorHandler;
    @NonNull
    private Logger logger;
    @NonNull
    private final String projectId;
    @NonNull
    private UserProfileService userProfileService;
    @Nullable
    private OptimizelyStartListener optimizelyStartListener;

    OptimizelyManager(@NonNull String projectId, @NonNull Logger logger, long datafileDownloadInterval, @NonNull DatafileHandler datafileHandler, @Nullable ErrorHandler errorHandler, long eventDispatchInterval, @NonNull EventHandler eventHandler, @NonNull UserProfileService userProfileService) {
        this.projectId = projectId;
        this.logger = logger;
        this.datafileDownloadInterval = datafileDownloadInterval;
        this.datafileHandler = datafileHandler;
        this.eventDispatchInterval = eventDispatchInterval;
        this.eventHandler = eventHandler;
        this.errorHandler = errorHandler;
        this.userProfileService = userProfileService;
    }

    @VisibleForTesting
    public Long getDatafileDownloadInterval() {
        return this.datafileDownloadInterval;
    }

    @NonNull
    public static Builder builder(@NonNull String projectId) {
        return new Builder(projectId);
    }

    @Nullable
    OptimizelyStartListener getOptimizelyStartListener() {
        return this.optimizelyStartListener;
    }

    void setOptimizelyStartListener(@Nullable OptimizelyStartListener optimizelyStartListener) {
        this.optimizelyStartListener = optimizelyStartListener;
    }

    public OptimizelyClient initialize(@NonNull Context context, @NonNull String datafile) {
        if (!this.isAndroidVersionSupported()) {
            return this.optimizelyClient;
        }
        try {
            this.optimizelyClient = this.buildOptimizely(context, datafile);
        }
        catch (ConfigParseException e) {
            this.logger.error("Unable to parse compiled data file", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("Unable to build OptimizelyClient instance", (Throwable)e);
        }
        catch (Error e) {
            this.logger.error("Unable to build OptimizelyClient instance", (Throwable)e);
        }
        this.datafileHandler.downloadDatafile(context, this.projectId, null);
        return this.optimizelyClient;
    }

    @NonNull
    public OptimizelyClient initialize(@NonNull Context context, @RawRes int datafileRes) {
        try {
            String datafile = this.loadRawResource(context, datafileRes);
            return this.initialize(context, datafile);
        }
        catch (IOException e) {
            this.logger.error("Unable to load compiled data file", (Throwable)e);
            return this.optimizelyClient;
        }
    }

    public OptimizelyClient initialize(@NonNull Context context) {
        String datafile = this.datafileHandler.loadSavedDatafile(context, this.projectId);
        if (datafile != null) {
            return this.initialize(context, datafile);
        }
        return this.optimizelyClient;
    }

    @TargetApi(value=14)
    public void initialize(@NonNull Activity activity, @NonNull OptimizelyStartListener optimizelyStartListener) {
        if (!this.isAndroidVersionSupported()) {
            return;
        }
        activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new OptlyActivityLifecycleCallbacks(this));
        this.initialize(activity.getApplicationContext(), optimizelyStartListener);
    }

    public void initialize(@NonNull Context context, @NonNull OptimizelyStartListener optimizelyStartListener) {
        if (!this.isAndroidVersionSupported()) {
            return;
        }
        this.optimizelyStartListener = optimizelyStartListener;
        this.datafileHandler.downloadDatafile(context, this.projectId, this.getDatafileLoadedListener(context));
    }

    DatafileLoadedListener getDatafileLoadedListener(final Context context) {
        return new DatafileLoadedListener(){

            @RequiresApi(api=11)
            public void onDatafileLoaded(@Nullable String datafile) {
                if (datafile != null) {
                    OptimizelyManager.this.injectOptimizely(context, OptimizelyManager.this.userProfileService, datafile);
                } else {
                    OptimizelyStartListener optimizelyStartListener = OptimizelyManager.this.getOptimizelyStartListener();
                    if (optimizelyStartListener != null) {
                        optimizelyStartListener.onStart(OptimizelyManager.this.getOptimizely());
                    }
                }
            }

            public void onStop(Context context2) {
                OptimizelyManager.this.stop(context2);
            }
        };
    }

    @TargetApi(value=14)
    void stop(@NonNull Activity activity, @NonNull OptlyActivityLifecycleCallbacks optlyActivityLifecycleCallbacks) {
        this.stop((Context)activity);
        activity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)optlyActivityLifecycleCallbacks);
    }

    public void stop(@NonNull Context context) {
        if (!this.isAndroidVersionSupported()) {
            return;
        }
        this.optimizelyStartListener = null;
    }

    @NonNull
    public OptimizelyClient getOptimizely() {
        this.isAndroidVersionSupported();
        return this.optimizelyClient;
    }

    private String loadRawResource(Context context, @RawRes int rawRes) throws IOException {
        byte[] b;
        Resources res = context.getResources();
        InputStream in = res.openRawResource(rawRes);
        int read = in.read(b = new byte[in.available()]);
        if (read > -1) {
            return new String(b);
        }
        throw new IOException("Couldn't parse raw res fixture, no bytes");
    }

    public boolean isDatafileCached(Context context) {
        return this.datafileHandler.isDatafileSaved(context, this.projectId);
    }

    @NonNull
    public static String getDatafileUrl(String projectId) {
        return DatafileService.getDatafileUrl((String)projectId);
    }

    @NonNull
    public String getProjectId() {
        return this.projectId;
    }

    @NonNull
    public DatafileHandler getDatafileHandler() {
        return this.datafileHandler;
    }

    @RequiresApi(api=11)
    void injectOptimizely(@NonNull Context context, @NonNull UserProfileService userProfileService, @NonNull String datafile) {
        if (this.datafileDownloadInterval > 0L && this.datafileHandler != null) {
            this.datafileHandler.startBackgroundUpdates(context, this.projectId, Long.valueOf(this.datafileDownloadInterval));
        }
        try {
            this.optimizelyClient = this.buildOptimizely(context, datafile);
            this.optimizelyClient.setDefaultAttributes(OptimizelyDefaultAttributes.buildDefaultAttributesMap(context, this.logger));
            if (userProfileService instanceof DefaultUserProfileService) {
                ((DefaultUserProfileService)userProfileService).startInBackground(new DefaultUserProfileService.StartCallback(){

                    public void onStartComplete(UserProfileService userProfileService) {
                        if (OptimizelyManager.this.optimizelyStartListener != null) {
                            OptimizelyManager.this.logger.info("Sending Optimizely instance to listener");
                            OptimizelyManager.this.optimizelyStartListener.onStart(OptimizelyManager.this.optimizelyClient);
                        } else {
                            OptimizelyManager.this.logger.info("No listener to send Optimizely to");
                        }
                    }
                });
            } else if (this.optimizelyStartListener != null) {
                this.logger.info("Sending Optimizely instance to listener");
                this.optimizelyStartListener.onStart(this.optimizelyClient);
            } else {
                this.logger.info("No listener to send Optimizely to");
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to build OptimizelyClient instance", (Throwable)e);
        }
        catch (Error e) {
            this.logger.error("Unable to build OptimizelyClient instance", (Throwable)e);
        }
    }

    private OptimizelyClient buildOptimizely(@NonNull Context context, @NonNull String datafile) throws ConfigParseException {
        EventHandler eventHandler = this.getEventHandler(context);
        Event.ClientEngine clientEngine = OptimizelyClientEngine.getClientEngineFromContext(context);
        Optimizely.Builder builder = Optimizely.builder((String)datafile, (EventHandler)eventHandler).withClientEngine(clientEngine).withClientVersion("1.4.0");
        if (this.errorHandler != null) {
            builder.withErrorHandler(this.errorHandler);
        }
        if (this.userProfileService != null) {
            builder.withUserProfileService(this.userProfileService);
        } else {
            this.userProfileService = DefaultUserProfileService.newInstance((String)this.projectId, (Context)context);
            builder.withUserProfileService(this.userProfileService);
        }
        Optimizely optimizely = builder.build();
        return new OptimizelyClient(optimizely, LoggerFactory.getLogger(OptimizelyClient.class));
    }

    @NonNull
    @VisibleForTesting
    public UserProfileService getUserProfileService() {
        return this.userProfileService;
    }

    protected EventHandler getEventHandler(Context context) {
        if (this.eventHandler == null) {
            DefaultEventHandler eventHandler = DefaultEventHandler.getInstance((Context)context);
            eventHandler.setDispatchInterval(this.eventDispatchInterval);
            this.eventHandler = eventHandler;
        }
        return this.eventHandler;
    }

    protected ErrorHandler getErrorHandler(Context context) {
        return this.errorHandler;
    }

    private boolean isAndroidVersionSupported() {
        if (Build.VERSION.SDK_INT >= 14) {
            return true;
        }
        this.logger.warn("Optimizely will not work on this phone.  It's Android version {} is less the minimum supported version {}", (Object)Build.VERSION.SDK_INT, (Object)14);
        return false;
    }

    public static class Builder {
        @NonNull
        private final String projectId;
        private long datafileDownloadInterval = -1L;
        private long eventDispatchInterval = -1L;
        @Nullable
        private DatafileHandler datafileHandler = null;
        @Nullable
        private Logger logger = null;
        @Nullable
        private EventHandler eventHandler = null;
        @Nullable
        private ErrorHandler errorHandler = null;
        @Nullable
        private UserProfileService userProfileService = null;

        Builder(@NonNull String projectId) {
            this.projectId = projectId;
        }

        public Builder withDatafileDownloadInterval(long interval) {
            this.datafileDownloadInterval = interval;
            return this;
        }

        public Builder withDatafileHandler(DatafileHandler overrideHandler) {
            this.datafileHandler = overrideHandler;
            return this;
        }

        public Builder withLogger(Logger overrideHandler) {
            this.logger = overrideHandler;
            return this;
        }

        public Builder withErrorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder withEventDispatchInterval(long interval) {
            this.eventDispatchInterval = interval;
            return this;
        }

        public Builder withEventHandler(EventHandler eventHandler) {
            this.eventHandler = eventHandler;
            return this;
        }

        public Builder withUserProfileService(UserProfileService userProfileService) {
            this.userProfileService = userProfileService;
            return this;
        }

        public OptimizelyManager build(Context context) {
            if (this.logger == null) {
                try {
                    this.logger = LoggerFactory.getLogger(OptimizelyManager.class);
                }
                catch (Exception e) {
                    this.logger = LoggerFactory.getLogger((String)"com.optimizely.ab.android.sdk.OptimizelyManager");
                    this.logger.error("Unable to generate logger from class.", (Throwable)e);
                }
                catch (Error e) {
                    this.logger = LoggerFactory.getLogger((String)"com.optimizely.ab.android.sdk.OptimizelyManager");
                    this.logger.error("Unable to generate logger from class.", (Throwable)e);
                }
            }
            if (this.datafileDownloadInterval > 0L && this.datafileDownloadInterval < 60L) {
                this.datafileDownloadInterval = 60L;
                this.logger.warn("Minimum datafile polling interval is 60 seconds. Defaulting to 60 seconds.");
            }
            if (this.datafileHandler == null) {
                this.datafileHandler = new DefaultDatafileHandler();
            }
            if (this.userProfileService == null) {
                this.userProfileService = DefaultUserProfileService.newInstance((String)this.projectId, (Context)context);
            }
            if (this.eventHandler == null) {
                this.eventHandler = DefaultEventHandler.getInstance((Context)context);
            }
            return new OptimizelyManager(this.projectId, this.logger, this.datafileDownloadInterval, this.datafileHandler, this.errorHandler, this.eventDispatchInterval, this.eventHandler, this.userProfileService);
        }
    }

    @RequiresApi(api=14)
    static class OptlyActivityLifecycleCallbacks
    implements Application.ActivityLifecycleCallbacks {
        @NonNull
        private OptimizelyManager optimizelyManager;

        OptlyActivityLifecycleCallbacks(@NonNull OptimizelyManager optimizelyManager) {
            this.optimizelyManager = optimizelyManager;
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
            this.optimizelyManager.stop(activity, this);
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    }
}

