/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.shared;

import android.app.IntentService;
import android.app.Service;
import android.app.job.JobParameters;
import android.app.job.JobService;
import android.app.job.JobWorkItem;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Handler;
import android.support.annotation.RequiresApi;
import com.optimizely.ab.android.shared.ServiceScheduler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresApi(api=26)
public class JobWorkService
extends JobService {
    public static final String INTENT_EXTRA_JWS_PERIODIC = "com.optimizely.ab.android.shared.JobService.Periodic";
    public static final int ONE_MINUTE = 60000;
    private CommandProcessor mCurProcessor;
    private int startId = 1;
    Logger logger = LoggerFactory.getLogger(JobWorkService.class);

    public void onCreate() {
    }

    public void onDestroy() {
        if (this.mCurProcessor != null) {
            this.mCurProcessor.cancel(true);
        }
    }

    public boolean onStartJob(JobParameters params) {
        this.mCurProcessor = new CommandProcessor(params, this.getApplicationContext(), this.logger);
        this.mCurProcessor.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        return true;
    }

    public boolean onStopJob(JobParameters params) {
        this.mCurProcessor.cancel(true);
        return true;
    }

    private void reschedule(JobWorkItem item) {
        ServiceScheduler.PendingIntentFactory pendingIntentFactory = new ServiceScheduler.PendingIntentFactory(this.getApplicationContext());
        ServiceScheduler serviceScheduler = new ServiceScheduler(this.getApplicationContext(), pendingIntentFactory, LoggerFactory.getLogger(ServiceScheduler.class));
        Intent intent = item.getIntent();
        serviceScheduler.schedule(intent, intent.getLongExtra(INTENT_EXTRA_JWS_PERIODIC, -1L));
    }

    static final class CommandProcessor
    extends AsyncTask<Void, Void, Void> {
        private final JobParameters mParams;
        private final Logger logger;
        private final Context context;

        CommandProcessor(JobParameters params, Context context, Logger logger) {
            this.mParams = params;
            this.logger = logger;
            this.context = context;
        }

        protected Void doInBackground(Void ... params) {
            boolean cancelled;
            while (!(cancelled = this.isCancelled())) {
                JobWorkItem work;
                try {
                    work = this.mParams.dequeueWork();
                    if (work == null) {
                        return null;
                    }
                }
                catch (Exception e) {
                    this.logger.error("Exception in JobWorkService:doInBackground mParams.dequeueWork() ", (Throwable)e);
                    return null;
                }
                final String componentClass = work.getIntent().getComponent().getClassName();
                Class<?> clazz = null;
                this.logger.info("Processing work: " + work + ", component: " + componentClass);
                try {
                    clazz = Class.forName(componentClass);
                    Object service = clazz.newInstance();
                    this.setContext((Service)service);
                    cancelled = this.isCancelled();
                    if (cancelled) {
                        this.logger.info("JobService was cancelled with items still in the queue.  Attempting to service all items");
                    }
                    if (service instanceof IntentService) {
                        IntentService intentService = (IntentService)service;
                        intentService.onCreate();
                        this.callOnHandleIntent(intentService, work.getIntent());
                        this.completeWork(this.mParams, work);
                    } else {
                        Handler mainHandler = new Handler(this.context.getApplicationContext().getMainLooper());
                        final Service mainService = (Service)service;
                        final JobWorkItem workItem = work;
                        final Intent manServiceIntent = work.getIntent();
                        mainHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    this.callOnStartCommand(mainService, manServiceIntent);
                                    this.completeWork(mParams, workItem);
                                }
                                catch (Exception e) {
                                    logger.error("Problem running service {}", (Object)componentClass, (Object)e);
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    this.logger.error("Error creating ServiceWorkScheduled", (Throwable)e);
                }
                this.logger.info("Done with: " + work);
            }
            if (cancelled) {
                this.logger.error("CANCELLED!");
            }
            return null;
        }

        private void setContext(Service service) {
            this.callMethod(ContextWrapper.class, service, "attachBaseContext", new Class[]{Context.class}, this.context.getApplicationContext());
        }

        private void callOnStartCommand(Service service, Intent intent) {
            this.callMethod(Service.class, service, "onStartCommand", new Class[]{Intent.class, Integer.TYPE, Integer.TYPE}, intent, 0, 1);
        }

        private void callOnHandleIntent(IntentService intentService, Intent intent) {
            this.callMethod(IntentService.class, intentService, "onHandleIntent", new Class[]{Intent.class}, intent);
        }

        private void callMethod(Class clazz, Object object, String methodName, Class[] parameterTypes, Object ... parameters) {
            try {
                Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
                method.setAccessible(true);
                method.invoke(object, parameters);
            }
            catch (NoSuchMethodException e) {
                this.logger.error("Error calling method " + methodName, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.logger.error("Error calling method " + methodName, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.logger.error("Error calling method " + methodName, (Throwable)e);
            }
        }

        private void completeWork(JobParameters jobParameters, JobWorkItem jobWorkItem) {
            Intent intent = jobWorkItem.getIntent();
            if (intent != null && intent.hasExtra(JobWorkService.INTENT_EXTRA_JWS_PERIODIC)) {
                this.logger.info("Periodic work item completed ");
                jobParameters.completeWork(jobWorkItem);
            } else {
                this.logger.info("work item completed");
                jobParameters.completeWork(jobWorkItem);
            }
        }
    }
}

