/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.shared;

import android.content.Context;
import com.optimizely.ab.android.shared.Cache;
import com.optimizely.ab.android.shared.CountingIdlingResourceInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedCounter
implements CountingIdlingResourceInterface {
    private final Cache cache;
    private final Logger logger = LoggerFactory.getLogger((String)"CachedCounter");
    private final Context context;
    private static final String fileName = "OptlyCachedCounterKey";

    public CachedCounter(Context context) {
        this.context = context;
        this.cache = new Cache(context, this.logger);
        if (!this.cache.exists(fileName)) {
            this.cache.save(fileName, "0");
        }
    }

    @Override
    public synchronized void increment() {
        String value = this.cache.load(fileName);
        Integer val = Integer.valueOf(value);
        val = val + 1;
        this.cache.save(fileName, val.toString());
    }

    @Override
    public synchronized void decrement() {
        String value = this.cache.load(fileName);
        Integer val = Integer.valueOf(value);
        if (val == 0) {
            return;
        }
        val = val - 1;
        this.cache.save(fileName, val.toString());
    }
}

