/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.shared;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.slf4j.Logger;

public class Cache {
    @NonNull
    private final Context context;
    @NonNull
    private final Logger logger;

    public Cache(@NonNull Context context, @NonNull Logger logger) {
        this.context = context;
        this.logger = logger;
    }

    public boolean delete(String filename) {
        return this.context.deleteFile(filename);
    }

    public boolean exists(String filename) {
        String[] files = this.context.fileList();
        return files != null && Arrays.asList(files).contains(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String load(String filename) {
        FileInputStream fileInputStream = null;
        try {
            String line;
            fileInputStream = this.context.openFileInput(filename);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder sb = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            this.logger.warn("Unable to load file {}.", (Object)filename);
            String string = null;
            return string;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception e) {
                this.logger.warn("Unable to close file {}.", (Object)filename, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(String filename, String data) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = this.context.openFileOutput(filename, 0);
            fileOutputStream.write(data.getBytes());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logger.error("Error saving file {}.", (Object)filename);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception e) {
                    this.logger.warn("Unable to close file {}.", (Object)filename, (Object)e);
                }
            }
        }
    }
}

