/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.datafile_handler;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import com.optimizely.ab.android.datafile_handler.BackgroundWatchersCache;
import com.optimizely.ab.android.datafile_handler.DatafileCache;
import com.optimizely.ab.android.datafile_handler.DatafileClient;
import com.optimizely.ab.android.datafile_handler.DatafileHandler;
import com.optimizely.ab.android.datafile_handler.DatafileLoadedListener;
import com.optimizely.ab.android.datafile_handler.DatafileService;
import com.optimizely.ab.android.datafile_handler.DatafileServiceConnection;
import com.optimizely.ab.android.shared.Cache;
import com.optimizely.ab.android.shared.Client;
import com.optimizely.ab.android.shared.DatafileConfig;
import com.optimizely.ab.android.shared.OptlyStorage;
import com.optimizely.ab.android.shared.ServiceScheduler;
import org.json.JSONObject;
import org.slf4j.LoggerFactory;

public class DefaultDatafileHandler
implements DatafileHandler {
    private DatafileServiceConnection datafileServiceConnection;

    @Override
    public String downloadDatafile(Context context, DatafileConfig datafileConfig) {
        DatafileClient datafileClient = new DatafileClient(new Client(new OptlyStorage(context), LoggerFactory.getLogger(OptlyStorage.class)), LoggerFactory.getLogger(DatafileClient.class));
        String datafileUrl = datafileConfig.getUrl();
        return datafileClient.request(datafileUrl);
    }

    @Override
    public void downloadDatafile(final Context context, DatafileConfig datafileConfig, final DatafileLoadedListener listener) {
        Intent intent = new Intent(context.getApplicationContext(), DatafileService.class);
        if (this.datafileServiceConnection == null) {
            this.datafileServiceConnection = new DatafileServiceConnection(datafileConfig, context.getApplicationContext(), new DatafileLoadedListener(){

                @Override
                @RequiresApi(api=11)
                public void onDatafileLoaded(@Nullable String dataFile) {
                    if (listener != null) {
                        listener.onDatafileLoaded(dataFile);
                    }
                    if (DefaultDatafileHandler.this.datafileServiceConnection != null && DefaultDatafileHandler.this.datafileServiceConnection.isBound()) {
                        context.getApplicationContext().unbindService((ServiceConnection)DefaultDatafileHandler.this.datafileServiceConnection);
                        DefaultDatafileHandler.this.datafileServiceConnection = null;
                    }
                }

                @Override
                public void onStop(Context context2) {
                    if (listener != null) {
                        listener.onStop(context2);
                    }
                }
            });
            context.getApplicationContext().bindService(intent, (ServiceConnection)this.datafileServiceConnection, 1);
        }
    }

    @Override
    public void startBackgroundUpdates(Context context, DatafileConfig datafileConfig, Long updateInterval) {
        this.stopBackgroundUpdates(context, datafileConfig);
        this.enableBackgroundCache(context, datafileConfig);
        ServiceScheduler.PendingIntentFactory pendingIntentFactory = new ServiceScheduler.PendingIntentFactory(context.getApplicationContext());
        ServiceScheduler serviceScheduler = new ServiceScheduler(context, pendingIntentFactory, LoggerFactory.getLogger(ServiceScheduler.class));
        Intent intent = new Intent(context.getApplicationContext(), DatafileService.class);
        intent.putExtra("com.optimizely.ab.android.EXTRA_DATAFILE_CONFIG", datafileConfig.toJSONString());
        serviceScheduler.schedule(intent, updateInterval * 1000L);
        DefaultDatafileHandler.storeInterval(context, updateInterval * 1000L);
    }

    private static void storeInterval(Context context, long interval) {
        OptlyStorage storage = new OptlyStorage(context);
        storage.saveLong("DATAFILE_INTERVAL", interval);
    }

    public static long getUpdateInterval(Context context) {
        OptlyStorage storage = new OptlyStorage(context);
        return storage.getLong("DATAFILE_INTERVAL", -1L);
    }

    @Override
    public void stopBackgroundUpdates(Context context, DatafileConfig datafileConfig) {
        ServiceScheduler.PendingIntentFactory pendingIntentFactory = new ServiceScheduler.PendingIntentFactory(context.getApplicationContext());
        ServiceScheduler serviceScheduler = new ServiceScheduler(context.getApplicationContext(), pendingIntentFactory, LoggerFactory.getLogger(ServiceScheduler.class));
        Intent intent = new Intent(context.getApplicationContext(), DatafileService.class);
        serviceScheduler.unschedule(intent);
        this.clearBackgroundCache(context, datafileConfig);
        DefaultDatafileHandler.storeInterval(context, -1L);
    }

    private void enableBackgroundCache(Context context, DatafileConfig datafileConfig) {
        BackgroundWatchersCache backgroundWatchersCache = new BackgroundWatchersCache(new Cache(context, LoggerFactory.getLogger(Cache.class)), LoggerFactory.getLogger(BackgroundWatchersCache.class));
        backgroundWatchersCache.setIsWatching(datafileConfig, true);
    }

    private void clearBackgroundCache(Context context, DatafileConfig projectId) {
        BackgroundWatchersCache backgroundWatchersCache = new BackgroundWatchersCache(new Cache(context, LoggerFactory.getLogger(Cache.class)), LoggerFactory.getLogger(BackgroundWatchersCache.class));
        backgroundWatchersCache.setIsWatching(projectId, false);
    }

    @Override
    public void saveDatafile(Context context, DatafileConfig datafileConfig, String dataFile) {
        DatafileCache datafileCache = new DatafileCache(datafileConfig.getKey(), new Cache(context, LoggerFactory.getLogger(Cache.class)), LoggerFactory.getLogger(DatafileCache.class));
        datafileCache.delete();
        datafileCache.save(dataFile);
    }

    @Override
    public String loadSavedDatafile(Context context, DatafileConfig datafileConfig) {
        DatafileCache datafileCache = new DatafileCache(datafileConfig.getKey(), new Cache(context, LoggerFactory.getLogger(Cache.class)), LoggerFactory.getLogger(DatafileCache.class));
        JSONObject datafile = datafileCache.load();
        if (datafile != null) {
            return datafile.toString();
        }
        return null;
    }

    @Override
    public Boolean isDatafileSaved(Context context, DatafileConfig datafileConfig) {
        DatafileCache datafileCache = new DatafileCache(datafileConfig.getKey(), new Cache(context, LoggerFactory.getLogger(Cache.class)), LoggerFactory.getLogger(DatafileCache.class));
        return datafileCache.exists();
    }

    @Override
    public void removeSavedDatafile(Context context, DatafileConfig datafileConfig) {
        DatafileCache datafileCache = new DatafileCache(datafileConfig.getKey(), new Cache(context, LoggerFactory.getLogger(Cache.class)), LoggerFactory.getLogger(DatafileCache.class));
        if (datafileCache.exists()) {
            datafileCache.delete();
        }
    }
}

