/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.datafile_handler;

import android.content.Context;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import com.optimizely.ab.android.datafile_handler.DatafileCache;
import com.optimizely.ab.android.datafile_handler.DatafileClient;
import com.optimizely.ab.android.datafile_handler.DatafileLoadedListener;
import com.optimizely.ab.android.datafile_handler.DatafileService;
import com.optimizely.ab.android.datafile_handler.DatafileServiceConnection;
import com.optimizely.ab.android.shared.DatafileConfig;
import java.util.concurrent.Executor;
import org.slf4j.Logger;

public class DatafileLoader {
    @NonNull
    private final DatafileCache datafileCache;
    @NonNull
    private final DatafileClient datafileClient;
    @NonNull
    private final DatafileService datafileService;
    @NonNull
    private final Executor executor;
    @NonNull
    private final Logger logger;
    private boolean hasNotifiedListener = false;

    public DatafileLoader(@NonNull DatafileService datafileService, @NonNull DatafileClient datafileClient, @NonNull DatafileCache datafileCache, @NonNull Executor executor, @NonNull Logger logger) {
        this.logger = logger;
        this.datafileService = datafileService;
        this.datafileClient = datafileClient;
        this.datafileCache = datafileCache;
        this.executor = executor;
        new DatafileServiceConnection(new DatafileConfig("projectId", (String)null), datafileService.getApplicationContext(), new DatafileLoadedListener(){

            @Override
            public void onDatafileLoaded(@Nullable String dataFile) {
            }

            @Override
            public void onStop(Context context) {
            }
        });
    }

    @RequiresApi(api=11)
    public void getDatafile(@NonNull String datafileUrl, @Nullable DatafileLoadedListener datafileLoadedListener) {
        RequestDatafileFromClientTask requestDatafileFromClientTask = new RequestDatafileFromClientTask(datafileUrl, this.datafileService, this.datafileCache, this.datafileClient, this, datafileLoadedListener, this.logger);
        requestDatafileFromClientTask.executeOnExecutor(this.executor, new Void[0]);
        this.logger.info("Refreshing data file");
    }

    private void notify(@Nullable DatafileLoadedListener datafileLoadedListener, @Nullable String dataFile) {
        if (datafileLoadedListener != null && this.datafileService.isBound() && !this.hasNotifiedListener) {
            datafileLoadedListener.onDatafileLoaded(dataFile);
            this.hasNotifiedListener = true;
        }
    }

    private static class RequestDatafileFromClientTask
    extends AsyncTask<Void, Void, String> {
        @NonNull
        private final String datafileUrl;
        @NonNull
        private final DatafileService datafileService;
        @NonNull
        private final DatafileCache datafileCache;
        @NonNull
        private final DatafileClient datafileClient;
        @NonNull
        private final DatafileLoader datafileLoader;
        @NonNull
        private final Logger logger;
        @Nullable
        private final DatafileLoadedListener datafileLoadedListener;

        RequestDatafileFromClientTask(@NonNull String datafileUrl, @NonNull DatafileService datafileService, @NonNull DatafileCache datafileCache, @NonNull DatafileClient datafileClient, @NonNull DatafileLoader datafileLoader, @Nullable DatafileLoadedListener datafileLoadedListener, @NonNull Logger logger) {
            this.datafileUrl = datafileUrl;
            this.datafileService = datafileService;
            this.datafileCache = datafileCache;
            this.datafileClient = datafileClient;
            this.datafileLoader = datafileLoader;
            this.datafileLoadedListener = datafileLoadedListener;
            this.logger = logger;
        }

        protected String doInBackground(Void ... params) {
            String dataFile = this.datafileClient.request(this.datafileUrl);
            if (dataFile != null && !dataFile.isEmpty()) {
                if (this.datafileCache.exists() && !this.datafileCache.delete()) {
                    this.logger.warn("Unable to delete old datafile");
                }
                if (!this.datafileCache.save(dataFile)) {
                    this.logger.warn("Unable to save new datafile");
                }
            }
            return dataFile;
        }

        protected void onPostExecute(@Nullable String dataFile) {
            this.datafileLoader.notify(this.datafileLoadedListener, dataFile);
            this.datafileService.stop();
            if (this.datafileLoader.hasNotifiedListener) {
                this.datafileLoadedListener.onStop(this.datafileService.getApplicationContext());
            }
        }
    }
}

