/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.datafile_handler;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.optimizely.ab.android.shared.Client;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;

public class DatafileClient {
    public static final int REQUEST_BACKOFF_TIMEOUT = 2;
    public static final int REQUEST_RETRIES_POWER = 3;
    @NonNull
    private final Client client;
    @NonNull
    private final Logger logger;

    public DatafileClient(@NonNull Client client, @NonNull Logger logger) {
        this.client = client;
        this.logger = logger;
    }

    @Nullable
    public String request(final String urlString) {
        Client.Request<String> request = new Client.Request<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String execute() {
                HttpURLConnection urlConnection = null;
                try {
                    URL url = new URL(urlString);
                    DatafileClient.this.logger.info("Requesting data file from {}", (Object)url);
                    urlConnection = DatafileClient.this.client.openConnection(url);
                    if (urlConnection == null) {
                        String string = null;
                        return string;
                    }
                    DatafileClient.this.client.setIfModifiedSince((URLConnection)urlConnection);
                    urlConnection.setConnectTimeout(5000);
                    urlConnection.connect();
                    int status = urlConnection.getResponseCode();
                    if (status >= 200 && status < 300) {
                        DatafileClient.this.client.saveLastModified((URLConnection)urlConnection);
                        String e = DatafileClient.this.client.readStream((URLConnection)urlConnection);
                        return e;
                    }
                    if (status == 304) {
                        DatafileClient.this.logger.info("Data file has not been modified on the cdn");
                        String e = "";
                        return e;
                    }
                    DatafileClient.this.logger.error("Unexpected response from data file cdn, status: {}", (Object)status);
                    String e = null;
                    return e;
                }
                catch (Exception e) {
                    DatafileClient.this.logger.error("Error making request", (Throwable)e);
                    String string = null;
                    return string;
                }
                finally {
                    if (urlConnection != null) {
                        try {
                            urlConnection.disconnect();
                        }
                        catch (Exception e) {
                            DatafileClient.this.logger.error("Error closing connection", (Throwable)e);
                        }
                    }
                }
            }
        };
        return (String)this.client.execute((Client.Request)request, 2, 3);
    }
}

