/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.datafile_handler;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.optimizely.ab.android.datafile_handler.BackgroundWatchersCache;
import com.optimizely.ab.android.datafile_handler.DatafileService;
import com.optimizely.ab.android.shared.Cache;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatafileRescheduler
extends BroadcastReceiver {
    Logger logger = LoggerFactory.getLogger(DatafileRescheduler.class);

    public void onReceive(Context context, Intent intent) {
        if (context != null && intent != null && (intent.getAction().equals("android.intent.action.BOOT_COMPLETED") || intent.getAction().equals("android.intent.action.MY_PACKAGE_REPLACED"))) {
            this.logger.info("Received intent with action {}", (Object)intent.getAction());
            BackgroundWatchersCache backgroundWatchersCache = new BackgroundWatchersCache(new Cache(context, LoggerFactory.getLogger(Cache.class)), LoggerFactory.getLogger(BackgroundWatchersCache.class));
            Dispatcher dispatcher = new Dispatcher(context, backgroundWatchersCache, LoggerFactory.getLogger(Dispatcher.class));
            intent = new Intent(context, DatafileService.class);
            dispatcher.dispatch(intent);
        } else {
            this.logger.warn("Received invalid broadcast to data file rescheduler");
        }
    }

    static class Dispatcher {
        @NonNull
        private final Context context;
        @NonNull
        private final BackgroundWatchersCache backgroundWatchersCache;
        @NonNull
        private final Logger logger;

        Dispatcher(@NonNull Context context, @NonNull BackgroundWatchersCache backgroundWatchersCache, @NonNull Logger logger) {
            this.context = context;
            this.backgroundWatchersCache = backgroundWatchersCache;
            this.logger = logger;
        }

        void dispatch(Intent intent) {
            List<String> projectIds = this.backgroundWatchersCache.getWatchingProjectIds();
            for (String projectId : projectIds) {
                intent.putExtra("com.optimizely.ab.android.EXTRA_PROJECT_ID", projectId);
                this.context.startService(intent);
                this.logger.info("Rescheduled data file watching for project {}", (Object)projectId);
            }
        }
    }
}

