/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util.finder;

import com.opensymphony.xwork2.util.finder.ClassLoaderInterface;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.xwork.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlSet {
    private static final Logger LOG = LoggerFactory.getLogger(UrlSet.class);
    private final Map<String, URL> urls;

    public UrlSet(ClassLoaderInterface classLoader) throws IOException {
        this(UrlSet.getUrls(classLoader));
    }

    public UrlSet(URL ... urls) {
        this(Arrays.asList(urls));
    }

    public UrlSet(Collection<URL> urls) {
        this.urls = new HashMap<String, URL>();
        for (URL location : urls) {
            try {
                this.urls.put(location.toExternalForm(), location);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private UrlSet(Map<String, URL> urls) {
        this.urls = urls;
    }

    public UrlSet include(UrlSet urlSet) {
        HashMap<String, URL> urls = new HashMap<String, URL>(this.urls);
        urls.putAll(urlSet.urls);
        return new UrlSet(urls);
    }

    public UrlSet exclude(UrlSet urlSet) {
        HashMap<String, URL> urls = new HashMap<String, URL>(this.urls);
        Map<String, URL> parentUrls = urlSet.urls;
        for (String url : parentUrls.keySet()) {
            urls.remove(url);
        }
        return new UrlSet(urls);
    }

    public UrlSet exclude(ClassLoaderInterface parent) throws IOException {
        return this.exclude(new UrlSet(parent));
    }

    public UrlSet exclude(File file) throws MalformedURLException {
        return this.exclude(this.relative(file));
    }

    public UrlSet exclude(String pattern) throws MalformedURLException {
        return this.exclude(this.matching(pattern));
    }

    public UrlSet excludeJavaExtDirs() throws MalformedURLException {
        return this.excludePaths(System.getProperty("java.ext.dirs", ""));
    }

    public UrlSet excludeJavaEndorsedDirs() throws MalformedURLException {
        return this.excludePaths(System.getProperty("java.endorsed.dirs", ""));
    }

    public UrlSet excludeJavaHome() throws MalformedURLException {
        String path = System.getProperty("java.home");
        File java = new File(path);
        if (path.matches("/System/Library/Frameworks/JavaVM.framework/Versions/[^/]+/Home")) {
            java = java.getParentFile();
        }
        return this.exclude(java);
    }

    public UrlSet excludePaths(String pathString) throws MalformedURLException {
        String[] paths = pathString.split(File.pathSeparator);
        UrlSet urlSet = this;
        for (String path : paths) {
            if (!StringUtils.isNotEmpty(path)) continue;
            File file = new File(path);
            urlSet = urlSet.exclude(file);
        }
        return urlSet;
    }

    public UrlSet matching(String pattern) {
        HashMap<String, URL> urls = new HashMap<String, URL>();
        for (Map.Entry<String, URL> entry : this.urls.entrySet()) {
            String url = entry.getKey();
            if (!url.matches(pattern)) continue;
            urls.put(url, entry.getValue());
        }
        return new UrlSet(urls);
    }

    public UrlSet relative(File file) throws MalformedURLException {
        String urlPath = file.toURL().toExternalForm();
        HashMap<String, URL> urls = new HashMap<String, URL>();
        for (Map.Entry<String, URL> entry : this.urls.entrySet()) {
            String url = entry.getKey();
            if (!url.startsWith(urlPath) && !url.startsWith("jar:" + urlPath)) continue;
            urls.put(url, entry.getValue());
        }
        return new UrlSet(urls);
    }

    public List<URL> getUrls() {
        return new ArrayList<URL>(this.urls.values());
    }

    private static List<URL> getUrls(ClassLoaderInterface classLoader) throws IOException {
        ArrayList<URL> list = new ArrayList<URL>();
        ArrayList<URL> urls = Collections.list(classLoader.getResources("META-INF"));
        for (URL url : urls) {
            if ("jar".equalsIgnoreCase(url.getProtocol())) {
                String externalForm = url.toExternalForm();
                url = new URL(StringUtils.substringBefore(externalForm, "META-INF"));
                list.add(url);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Ignoring URL [#0] because it is not a jar", url.toExternalForm());
        }
        list.addAll(Collections.list(classLoader.getResources("")));
        return list;
    }
}

