/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionBranch;
import org.aspectj.apache.bcel.generic.InstructionByte;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InstructionSelect;

public interface InstructionComparator {
    public static final InstructionComparator DEFAULT = new InstructionComparator(){

        public boolean equals(Instruction i1, Instruction i2) {
            if (i1.opcode == i2.opcode) {
                if (i1 instanceof InstructionSelect) {
                    InstructionHandle[] t1 = ((InstructionSelect)i1).getTargets();
                    InstructionHandle[] t2 = ((InstructionSelect)i2).getTargets();
                    if (t1 == null && t2 == null) {
                        return true;
                    }
                    if (t1 == null || t2 == null) {
                        return false;
                    }
                    if (t1.length == t2.length) {
                        int i = 0;
                        while (i < t1.length) {
                            if (t1[i] != t2[i]) {
                                return false;
                            }
                            ++i;
                        }
                        return true;
                    }
                } else {
                    if (i1 instanceof InstructionBranch) {
                        return ((InstructionBranch)i1).targetInstruction == ((InstructionBranch)i2).targetInstruction;
                    }
                    if (i1.isConstantInstruction()) {
                        return i1.getValue().equals(i2.getValue());
                    }
                    if (i1.isIndexedInstruction()) {
                        return i1.getIndex() == i2.getIndex();
                    }
                    if (i1.opcode == 188) {
                        return ((InstructionByte)i1).getTypecode() == ((InstructionByte)i2).getTypecode();
                    }
                    return true;
                }
            }
            return false;
        }
    };

    public boolean equals(Instruction var1, Instruction var2);
}

