/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import com.opensymphony.xwork2.util.ClassLoaderUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class FileManager {
    private static Map<String, Revision> files = Collections.synchronizedMap(new HashMap());
    protected static boolean reloadingConfigs = true;
    private static final String JAR_FILE_NAME_PREFIX = "jar:file:";
    private static final String JAR_FILE_NAME_SEPARATOR = "!/";

    private FileManager() {
    }

    public static void setReloadingConfigs(boolean reloadingConfigs) {
        FileManager.reloadingConfigs = reloadingConfigs;
    }

    public static boolean isReloadingConfigs() {
        return reloadingConfigs;
    }

    public static boolean fileNeedsReloading(String fileName) {
        Revision revision = files.get(fileName);
        if (revision == null) {
            return reloadingConfigs;
        }
        return revision.needsReloading();
    }

    public static InputStream loadFile(String fileName, Class clazz) {
        URL fileUrl = ClassLoaderUtil.getResource(fileName, clazz);
        return FileManager.loadFile(fileUrl);
    }

    public static InputStream loadFile(URL fileUrl) {
        return FileManager.loadFile(fileUrl, true);
    }

    public static InputStream loadFile(URL fileUrl, boolean openStream) {
        if (fileUrl == null) {
            return null;
        }
        String fileName = fileUrl.toString();
        InputStream is = null;
        if (openStream) {
            try {
                is = fileUrl.openStream();
                if (is == null) {
                    throw new IllegalArgumentException("No file '" + fileName + "' found as a resource");
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("No file '" + fileName + "' found as a resource");
            }
        }
        if (FileManager.isReloadingConfigs()) {
            if (!fileName.startsWith(JAR_FILE_NAME_PREFIX)) {
                File file = new File(fileUrl.getFile());
                if (!file.exists() || !file.canRead()) {
                    file = null;
                }
                if (file != null) {
                    long lastModified = file.lastModified();
                    files.put(fileName, new FileRevision(file, lastModified));
                } else {
                    files.put(fileName, new FileRevision());
                }
            } else {
                ZipEntry entry;
                int separatorIndex = fileName.indexOf(JAR_FILE_NAME_SEPARATOR);
                String jarFileName = fileName.substring(JAR_FILE_NAME_PREFIX.length(), separatorIndex);
                String fileNameInJar = fileName.substring(separatorIndex + JAR_FILE_NAME_SEPARATOR.length());
                try {
                    JarFile jarFile = new JarFile(jarFileName);
                    entry = jarFile.getEntry(fileNameInJar);
                }
                catch (IOException e) {
                    entry = null;
                }
                if (entry != null) {
                    files.put(fileName, new JarEntryRevision(jarFileName, fileNameInJar, entry.getTime()));
                } else {
                    files.put(fileName, new Revision());
                }
            }
        }
        return is;
    }

    private static class JarEntryRevision
    extends Revision {
        private String jarFileName;
        private String fileNameInJar;
        private long lastModified;

        public JarEntryRevision(String jarFileName, String fileNameInJar, long lastModified) {
            if (jarFileName == null || fileNameInJar == null) {
                throw new IllegalArgumentException("JarFileName and FileNameInJar cannot be null");
            }
            this.jarFileName = jarFileName;
            this.fileNameInJar = fileNameInJar;
            this.lastModified = lastModified;
        }

        public boolean needsReloading() {
            ZipEntry entry;
            try {
                JarFile jarFile = new JarFile(this.jarFileName);
                entry = jarFile.getEntry(this.fileNameInJar);
            }
            catch (IOException e) {
                entry = null;
            }
            if (entry != null) {
                return this.lastModified < entry.getTime();
            }
            return false;
        }
    }

    private static class FileRevision
    extends Revision {
        private File file;
        private long lastModified;

        public FileRevision() {
        }

        public FileRevision(File file, long lastUpdated) {
            if (file == null) {
                throw new IllegalArgumentException("File cannot be null");
            }
            this.file = file;
            this.lastModified = lastUpdated;
        }

        public File getFile() {
            return this.file;
        }

        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public boolean needsReloading() {
            return this.lastModified < this.file.lastModified();
        }
    }

    private static class Revision {
        public boolean needsReloading() {
            return false;
        }
    }
}

