/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.validator.ShortCircuitableValidator;
import com.opensymphony.xwork2.validator.Validator;
import com.opensymphony.xwork2.validator.ValidatorConfig;
import com.opensymphony.xwork2.validator.ValidatorFactory;
import com.opensymphony.xwork2.validator.ValidatorFileParser;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DefaultValidatorFactory
implements ValidatorFactory {
    protected Map<String, String> validators = new HashMap<String, String>();
    private static Logger LOG = LoggerFactory.getLogger(DefaultValidatorFactory.class);
    protected ObjectFactory objectFactory;
    protected ValidatorFileParser validatorFileParser;

    @Inject
    public DefaultValidatorFactory(@Inject ObjectFactory objectFactory, @Inject ValidatorFileParser parser) {
        this.objectFactory = objectFactory;
        this.validatorFileParser = parser;
        this.parseValidators();
    }

    public Validator getValidator(ValidatorConfig cfg) {
        Validator validator;
        String className = this.lookupRegisteredValidatorType(cfg.getType());
        try {
            validator = this.objectFactory.buildValidator(className, cfg.getParams(), null);
        }
        catch (Exception e) {
            String msg = "There was a problem creating a Validator of type " + className + " : caused by " + e.getMessage();
            throw new XWorkException(msg, e, cfg);
        }
        validator.setMessageKey(cfg.getMessageKey());
        validator.setDefaultMessage(cfg.getDefaultMessage());
        if (validator instanceof ShortCircuitableValidator) {
            ((ShortCircuitableValidator)((Object)validator)).setShortCircuit(cfg.isShortCircuit());
        }
        return validator;
    }

    public void registerValidator(String name, String className) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registering validator of class " + className + " with name " + name, new String[0]);
        }
        this.validators.put(name, className);
    }

    public String lookupRegisteredValidatorType(String name) {
        String className = this.validators.get(name);
        if (className == null) {
            throw new IllegalArgumentException("There is no validator class mapped to the name " + name);
        }
        return className;
    }

    private void parseValidators() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading validator definitions.", new String[0]);
        }
        ArrayList<File> files = new ArrayList<File>();
        try {
            Iterator<URL> urls = ClassLoaderUtil.getResources("", DefaultValidatorFactory.class, false);
            while (urls.hasNext()) {
                URL u = urls.next();
                File f = new File(new URI(u.toExternalForm().replaceAll(" ", "%20")));
                FilenameFilter filter = new FilenameFilter(){

                    public boolean accept(File file, String fileName) {
                        return fileName.contains("-validators.xml");
                    }
                };
                files.addAll(Arrays.asList(f.listFiles(filter)));
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to parse validators", e);
        }
        String resourceName = "com/opensymphony/xwork2/validator/validators/default.xml";
        this.retrieveValidatorConfiguration(resourceName);
        resourceName = "validators.xml";
        this.retrieveValidatorConfiguration(resourceName);
        for (File file : files) {
            this.retrieveValidatorConfiguration(file.getName());
        }
    }

    private void retrieveValidatorConfiguration(String resourceName) {
        InputStream is = ClassLoaderUtil.getResourceAsStream(resourceName, DefaultValidatorFactory.class);
        if (is != null) {
            this.validatorFileParser.parseValidatorDefinitions(this.validators, is, resourceName);
        }
    }
}

