/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.xslt;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.views.xslt.AdapterFactory;
import com.opensymphony.webwork.views.xslt.ServletURIResolver;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.Result;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.util.TextParseUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XSLTResult
implements Result {
    private static final Log log = LogFactory.getLog((Class)XSLTResult.class);
    public static final String DEFAULT_PARAM = "stylesheetLocation";
    protected boolean noCache = false;
    private Map templatesCache = new HashMap();
    private String stylesheetLocation;
    private boolean parse;
    private AdapterFactory adapterFactory;

    public XSLTResult() {
        this.noCache = Configuration.getString("webwork.xslt.nocache").trim().equalsIgnoreCase("true");
    }

    public void setLocation(String location) {
        this.setStylesheetLocation(location);
    }

    public void setStylesheetLocation(String location) {
        if (location == null) {
            throw new IllegalArgumentException("Null location");
        }
        System.out.println("location = " + location);
        this.stylesheetLocation = location;
    }

    public String getStylesheetLocation() {
        return this.stylesheetLocation;
    }

    public void setParse(boolean parse) {
        this.parse = parse;
    }

    public void execute(ActionInvocation invocation) throws Exception {
        long startTime = System.currentTimeMillis();
        String location = this.getStylesheetLocation();
        if (this.parse) {
            OgnlValueStack stack = ActionContext.getContext().getValueStack();
            location = TextParseUtil.translateVariables((String)location, (OgnlValueStack)stack);
        }
        try {
            Transformer transformer;
            HttpServletResponse response = ServletActionContext.getResponse();
            PrintWriter writer = response.getWriter();
            Templates templates = null;
            if (location != null) {
                templates = this.getTemplates(location);
                transformer = templates.newTransformer();
            } else {
                transformer = TransformerFactory.newInstance().newTransformer();
            }
            transformer.setURIResolver(this.getURIResolver());
            String mimeType = null;
            mimeType = templates == null ? "text/xml" : templates.getOutputProperties().getProperty("media-type");
            if (mimeType == null) {
                mimeType = "text/html";
            }
            response.setContentType(mimeType);
            Source xmlSource = this.getDOMSourceForStack(invocation.getAction());
            PrintWriter out = response.getWriter();
            log.debug((Object)("xmlSource = " + xmlSource));
            transformer.transform(xmlSource, new StreamResult(out));
            out.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Time:" + (System.currentTimeMillis() - startTime) + "ms"));
            }
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            log.error((Object)("Unable to render XSLT Template, '" + location + "'"), (Throwable)e);
            throw e;
        }
    }

    protected AdapterFactory getAdapterFactory() {
        if (this.adapterFactory == null) {
            this.adapterFactory = new AdapterFactory();
        }
        return this.adapterFactory;
    }

    protected void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    protected URIResolver getURIResolver() {
        return new ServletURIResolver(ServletActionContext.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Templates getTemplates(String path) throws TransformerException, IOException {
        String pathFromRequest = ServletActionContext.getRequest().getParameter("xslt.location");
        if (pathFromRequest != null) {
            path = pathFromRequest;
        }
        if (path == null) {
            throw new TransformerException("Stylesheet path is null");
        }
        Templates templates = (Templates)this.templatesCache.get(path);
        if (this.noCache || templates == null) {
            Map map = this.templatesCache;
            synchronized (map) {
                URL resource = ServletActionContext.getServletContext().getResource(path);
                if (resource == null) {
                    throw new TransformerException("Stylesheet " + path + " not found in resources.");
                }
                log.debug((Object)("Preparing XSLT stylesheet templates: " + path));
                TransformerFactory factory = TransformerFactory.newInstance();
                templates = factory.newTemplates(new StreamSource(resource.openStream()));
                this.templatesCache.put(path, templates);
            }
        }
        return templates;
    }

    protected Source getDOMSourceForStack(Object action) throws IllegalAccessException, InstantiationException {
        return new DOMSource(this.getAdapterFactory().adaptDocument("result", action));
    }
}

