/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.sitegraph.model;

import com.opensymphony.webwork.sitegraph.model.IndentWriter;
import com.opensymphony.webwork.sitegraph.model.Render;
import com.opensymphony.webwork.sitegraph.model.SubGraph;
import java.io.IOException;

public abstract class SiteGraphNode
implements Render,
Comparable {
    private String name;
    private SubGraph parent;

    public SiteGraphNode(String name) {
        this.name = name;
    }

    public SubGraph getParent() {
        return this.parent;
    }

    public void setParent(SubGraph parent) {
        this.parent = parent;
    }

    public void render(IndentWriter writer) throws IOException {
        writer.write(this.getFullName() + " [label=\"" + this.name + "\",color=\"" + this.getColor() + "\"];");
    }

    public String getFullName() {
        String parentPrefix;
        String prefix = "";
        if (this.parent != null && !(parentPrefix = this.parent.getPrefix()).equals("")) {
            prefix = parentPrefix + "_";
        }
        return prefix + this.cleanName();
    }

    private String cleanName() {
        return this.name.replaceAll("[\\.\\/\\-\\$\\{\\}]", "_");
    }

    public abstract String getColor();

    public int compareTo(Object o) {
        return this.name.compareTo(((SiteGraphNode)o).name);
    }
}

