/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.sitegraph.entities;

import com.opensymphony.util.FileUtils;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.sitegraph.entities.Target;
import com.opensymphony.webwork.sitegraph.entities.View;
import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class FileBasedView
implements View {
    private String name;
    private String contents;

    public FileBasedView(File file) {
        this.name = file.getName();
        this.contents = FileUtils.readFile((File)file).replaceAll("[\r\n ]+", " ");
    }

    public String getName() {
        return this.name;
    }

    public Set getTargets() {
        TreeSet targets = new TreeSet();
        this.matchPatterns(this.getLinkPattern(), targets, 2);
        this.matchPatterns(this.getActionPattern(), targets, 1);
        this.matchPatterns(this.getFormPattern(), targets, 0);
        return targets;
    }

    protected Pattern getLinkPattern() {
        Object ext = Configuration.get("webwork.action.extension");
        String actionRegex = "([A-Za-z0-9\\._\\-\\!]+\\." + ext + ")";
        return Pattern.compile(actionRegex);
    }

    private void matchPatterns(Pattern pattern, Set targets, int type) {
        Matcher matcher = pattern.matcher(this.contents);
        while (matcher.find()) {
            String target = matcher.group(1);
            targets.add(new Target(target, type));
        }
    }

    protected abstract Pattern getActionPattern();

    protected abstract Pattern getFormPattern();
}

