/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher.mapper;

import com.opensymphony.webwork.RequestUtils;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.dispatcher.ServletRedirectResult;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapper;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapping;
import com.opensymphony.webwork.util.PrefixTrie;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class DefaultActionMapper
implements ActionMapper {
    static final String METHOD_PREFIX = "method:";
    static final String ACTION_PREFIX = "action:";
    static final String REDIRECT_PREFIX = "redirect:";
    static final String REDIRECT_ACTION_PREFIX = "redirect-action:";
    static PrefixTrie prefixTrie = new PrefixTrie(){
        {
            this.put(DefaultActionMapper.METHOD_PREFIX, new ParameterAction(){

                public void execute(String key, ActionMapping mapping) {
                    mapping.setMethod(key.substring(DefaultActionMapper.METHOD_PREFIX.length()));
                }
            });
            this.put(DefaultActionMapper.ACTION_PREFIX, new ParameterAction(){

                public void execute(String key, ActionMapping mapping) {
                    String name = key.substring(DefaultActionMapper.ACTION_PREFIX.length());
                    int bang = name.indexOf(33);
                    if (bang != -1) {
                        String method = name.substring(bang + 1);
                        mapping.setMethod(method);
                        name = name.substring(0, bang);
                    }
                    mapping.setName(name);
                }
            });
            this.put(DefaultActionMapper.REDIRECT_PREFIX, new ParameterAction(){

                public void execute(String key, ActionMapping mapping) {
                    ServletRedirectResult redirect = new ServletRedirectResult();
                    redirect.setLocation(key.substring(DefaultActionMapper.REDIRECT_PREFIX.length()));
                    mapping.setResult(redirect);
                }
            });
            this.put(DefaultActionMapper.REDIRECT_ACTION_PREFIX, new ParameterAction(){

                public void execute(String key, ActionMapping mapping) {
                    String location = key.substring(DefaultActionMapper.REDIRECT_ACTION_PREFIX.length());
                    ServletRedirectResult redirect = new ServletRedirectResult();
                    String extension = DefaultActionMapper.getDefaultExtension();
                    if (extension != null) {
                        location = location + "." + extension;
                    }
                    redirect.setLocation(location);
                    mapping.setResult(redirect);
                }
            });
        }
    };

    public ActionMapping getMapping(HttpServletRequest request) {
        ActionMapping mapping = new ActionMapping();
        String uri = this.getUri(request);
        this.parseNameAndNamespace(uri, mapping);
        this.handleSpecialParameters(request, mapping);
        if (mapping.getName() == null) {
            return null;
        }
        String name = mapping.getName();
        int exclamation = name.lastIndexOf("!");
        if (exclamation != -1) {
            mapping.setName(name.substring(0, exclamation));
            mapping.setMethod(name.substring(exclamation + 1));
        }
        return mapping;
    }

    protected void handleSpecialParameters(HttpServletRequest request, ActionMapping mapping) {
        Map parameterMap = request.getParameterMap();
        Iterator iterator = parameterMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            ParameterAction parameterAction = (ParameterAction)prefixTrie.get(key);
            if (parameterAction == null) continue;
            parameterAction.execute(key, mapping);
            break;
        }
    }

    protected void parseNameAndNamespace(String uri, ActionMapping mapping) {
        String name;
        String namespace;
        int lastSlash = uri.lastIndexOf("/");
        if (lastSlash == -1) {
            namespace = "";
            name = uri;
        } else if (lastSlash == 0) {
            namespace = "/";
            name = uri.substring(lastSlash + 1);
        } else {
            namespace = uri.substring(0, lastSlash);
            name = uri.substring(lastSlash + 1);
        }
        mapping.setNamespace(namespace);
        mapping.setName(this.dropExtension(name));
    }

    String dropExtension(String name) {
        List extensions = DefaultActionMapper.getExtensions();
        if (extensions == null) {
            return name;
        }
        Iterator it = extensions.iterator();
        while (it.hasNext()) {
            String extension = "." + (String)it.next();
            if (!name.endsWith(extension)) continue;
            name = name.substring(0, name.length() - extension.length());
            return name;
        }
        return null;
    }

    static String getDefaultExtension() {
        List extensions = DefaultActionMapper.getExtensions();
        if (extensions == null) {
            return null;
        }
        return (String)extensions.get(0);
    }

    static List getExtensions() {
        String extensions = (String)Configuration.get("webwork.action.extension");
        if (extensions.equals("")) {
            return null;
        }
        return Arrays.asList(extensions.split(","));
    }

    String getUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (uri != null) {
            return uri;
        }
        uri = RequestUtils.getServletPath(request);
        if (uri != null && !"".equals(uri)) {
            return uri;
        }
        uri = request.getRequestURI();
        return uri.substring(request.getContextPath().length());
    }

    public String getUriFromActionMapping(ActionMapping mapping) {
        String extension;
        StringBuffer uri = new StringBuffer();
        uri.append(mapping.getNamespace());
        if (!"/".equals(mapping.getNamespace())) {
            uri.append("/");
        }
        String name = mapping.getName();
        String params = "";
        if (name.indexOf(63) != -1) {
            params = name.substring(name.indexOf(63));
            name = name.substring(0, name.indexOf(63));
        }
        uri.append(name);
        if (null != mapping.getMethod() && !"".equals(mapping.getMethod())) {
            uri.append("!").append(mapping.getMethod());
        }
        if ((extension = DefaultActionMapper.getDefaultExtension()) != null && uri.indexOf('.' + extension) == -1) {
            uri.append(".").append(extension);
            if (params.length() > 0) {
                uri.append(params);
            }
        }
        return uri.toString();
    }

    static interface ParameterAction {
        public void execute(String var1, ActionMapping var2);
    }
}

