/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.webwork.WebWorkException;
import com.opensymphony.webwork.components.Component;
import com.opensymphony.xwork.LocaleProvider;
import com.opensymphony.xwork.TextProviderSupport;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.Writer;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class I18n
extends Component {
    private static final Log LOG = LogFactory.getLog((Class)I18n.class);
    protected boolean pushed;
    protected String name;

    public I18n(OgnlValueStack stack) {
        super(stack);
    }

    public boolean start(Writer writer) {
        boolean result = super.start(writer);
        try {
            String name = this.findString(this.name, "name", "Resource bundle name is required. Example: foo or foo_en");
            ResourceBundle bundle = (ResourceBundle)this.findValue("texts('" + name + "')");
            if (bundle == null) {
                bundle = LocalizedTextUtil.findResourceBundle((String)name, (Locale)((Locale)this.getStack().getContext().get("com.opensymphony.xwork.ActionContext.locale")));
            }
            if (bundle != null) {
                final Locale locale = (Locale)this.getStack().getContext().get("com.opensymphony.xwork.ActionContext.locale");
                this.getStack().push((Object)new TextProviderSupport(bundle, new LocaleProvider(){

                    public Locale getLocale() {
                        return locale;
                    }
                }));
                this.pushed = true;
            }
        }
        catch (Exception e) {
            String msg = "Could not find the bundle " + this.name;
            LOG.error((Object)msg, (Throwable)e);
            throw new WebWorkException(msg);
        }
        return result;
    }

    public boolean end(Writer writer, String body) {
        if (this.pushed) {
            this.getStack().pop();
        }
        return super.end(writer, body);
    }

    public void setName(String name) {
        this.name = name;
    }
}

