/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.webwork.WebWorkException;
import com.opensymphony.webwork.components.AbstractRichtexteditorConnector;
import com.opensymphony.webwork.util.ServletContextAware;
import com.opensymphony.webwork.views.util.UrlHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultRichtexteditorConnector
extends AbstractRichtexteditorConnector
implements ServletContextAware {
    private static final Log _log = LogFactory.getLog((Class)DefaultRichtexteditorConnector.class);
    private static final long serialVersionUID = -3792445192115623052L;
    protected String _actualServerPath = "/com/opensymphony/webwork/static/richtexteditor/data/";
    private ServletContext servletContext;

    public String getActualServerPath() {
        return this._actualServerPath;
    }

    public void setActualServerPath(String actualServerPath) {
        this._actualServerPath = actualServerPath;
    }

    protected String calculateServerPath(String serverPath, String folderPath, String type) throws Exception {
        return UrlHelper.buildUrl(serverPath + type + folderPath, this._request, this._response, new HashMap(), this._request.getScheme(), true, true, true);
    }

    protected String calculateActualServerPath(String actualServerPath, String type, String folderPath) throws Exception {
        String path = "file:////" + this.servletContext.getRealPath("/WEB-INF/classes" + actualServerPath);
        path = path.trim();
        path = path.replace('\\', '/');
        this.makeDirIfNotExists(path);
        path = path.endsWith("/") ? path : path + "/";
        return path + type + folderPath;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected AbstractRichtexteditorConnector.Folder[] getFolders(String virtualFolderPath, String type) throws Exception {
        String path = this.calculateActualServerPath(this.getActualServerPath(), type, virtualFolderPath);
        this.makeDirIfNotExists(path);
        File f = new File(new URI(path));
        File[] children = f.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return !pathname.isFile();
            }
        });
        ArrayList<AbstractRichtexteditorConnector.Folder> tmpFolders = new ArrayList<AbstractRichtexteditorConnector.Folder>();
        for (int a = 0; a < children.length; ++a) {
            tmpFolders.add(new AbstractRichtexteditorConnector.Folder(children[a].getName()));
        }
        return tmpFolders.toArray(new AbstractRichtexteditorConnector.Folder[0]);
    }

    protected AbstractRichtexteditorConnector.FoldersAndFiles getFoldersAndFiles(String virtualFolderPath, String type) throws Exception {
        String path = this.calculateActualServerPath(this.getActualServerPath(), type, virtualFolderPath);
        this.makeDirIfNotExists(path);
        File f = new File(new URI(path));
        File[] children = f.listFiles();
        ArrayList<AbstractRichtexteditorConnector.Folder> directories = new ArrayList<AbstractRichtexteditorConnector.Folder>();
        ArrayList<AbstractRichtexteditorConnector.File> files = new ArrayList<AbstractRichtexteditorConnector.File>();
        for (int a = 0; a < children.length; ++a) {
            if (children[a].isDirectory()) {
                directories.add(new AbstractRichtexteditorConnector.Folder(children[a].getName()));
                continue;
            }
            try {
                files.add(new AbstractRichtexteditorConnector.File(children[a].getName(), this.fileSizeInKBytes(children[a])));
                continue;
            }
            catch (Exception e) {
                _log.error((Object)("cannot deal with file " + children[a]), (Throwable)e);
            }
        }
        return new AbstractRichtexteditorConnector.FoldersAndFiles(directories.toArray(new AbstractRichtexteditorConnector.Folder[0]), files.toArray(new AbstractRichtexteditorConnector.File[0]));
    }

    protected AbstractRichtexteditorConnector.CreateFolderResult createFolder(String virtualFolderPath, String type, String newFolderName) {
        try {
            String tmpPath = this.calculateActualServerPath(this.getActualServerPath(), type, virtualFolderPath);
            tmpPath = tmpPath + newFolderName;
            boolean alreadyExists = this.makeDirIfNotExists(tmpPath);
            if (alreadyExists) {
                return AbstractRichtexteditorConnector.CreateFolderResult.folderAlreadyExists();
            }
        }
        catch (Exception e) {
            _log.error((Object)e.toString(), (Throwable)e);
            return AbstractRichtexteditorConnector.CreateFolderResult.unknownError();
        }
        return AbstractRichtexteditorConnector.CreateFolderResult.noErrors();
    }

    protected AbstractRichtexteditorConnector.FileUploadResult fileUpload(String virtualFolderPath, String type, String filename, String contentType, File newFile) {
        try {
            String tmpDir = this.calculateActualServerPath(this.getActualServerPath(), type, virtualFolderPath);
            this.makeDirIfNotExists(tmpDir);
            String tmpFile = tmpDir + filename;
            if (this.makeFileIfNotExists(tmpFile)) {
                int a = 0;
                String ext = String.valueOf(a);
                tmpFile = this.calculateActualServerPath(this.getActualServerPath(), type, virtualFolderPath) + filename + ext;
                while (this.makeFileIfNotExists(tmpFile)) {
                    ext = String.valueOf(++a);
                    if (a > 100) {
                        return AbstractRichtexteditorConnector.FileUploadResult.invalidFile();
                    }
                    tmpFile = this.calculateActualServerPath(this.getActualServerPath(), type, virtualFolderPath) + filename + ext;
                }
                this.copyFile(newFile, new File(new URI(tmpFile)));
                return AbstractRichtexteditorConnector.FileUploadResult.uploadCompleteWithFilenamChanged(filename + ext);
            }
            this.copyFile(newFile, new File(new URI(tmpFile)));
            return AbstractRichtexteditorConnector.FileUploadResult.uploadComplete();
        }
        catch (Exception e) {
            _log.error((Object)e.toString(), (Throwable)e);
            return AbstractRichtexteditorConnector.FileUploadResult.invalidFile();
        }
    }

    protected void unknownCommand(String command, String virtualFolderPath, String type, String filename, String contentType, File newFile) {
        throw new WebWorkException("unknown command " + command);
    }

    protected boolean makeDirIfNotExists(String path) throws URISyntaxException {
        File dir = new File(new URI(path));
        if (!dir.exists()) {
            boolean ok;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("make directory " + dir));
            }
            if (!(ok = dir.mkdirs())) {
                throw new WebWorkException("cannot make directory " + dir);
            }
            return false;
        }
        return true;
    }

    protected boolean makeFileIfNotExists(String filePath) throws IOException, URISyntaxException {
        File f = new File(new URI(filePath));
        if (!f.exists()) {
            boolean ok;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("creating file " + filePath));
            }
            if (!(ok = f.createNewFile())) {
                throw new WebWorkException("cannot create file " + filePath);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile(File from, File to) throws FileNotFoundException, IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("copy file from " + from + " to " + to));
            }
            fis = new FileInputStream(from);
            fos = new FileOutputStream(to);
            int tmpByte = fis.read();
            while (tmpByte != -1) {
                fos.write(tmpByte);
                tmpByte = fis.read();
            }
            fos.flush();
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long fileSizeInKBytes(File file) throws FileNotFoundException, IOException {
        FileInputStream fis = null;
        long size = 0L;
        try {
            fis = new FileInputStream(file);
            size = fis.getChannel().size();
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        if (size > 0L) {
            size /= 100L;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("size of file " + file + " is " + size + " kb"));
        }
        return size;
    }
}

