/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.webwork.WebWorkException;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapper;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapperFactory;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapping;
import com.opensymphony.webwork.util.FastByteArrayOutputStream;
import com.opensymphony.webwork.views.jsp.TagUtils;
import com.opensymphony.webwork.views.util.ContextUtil;
import com.opensymphony.webwork.views.util.UrlHelper;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.util.TextParseUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Component {
    private static final Log LOG;
    public static final String COMPONENT_STACK = "__component_stack";
    protected OgnlValueStack stack;
    protected Map parameters;
    protected String id;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Component(OgnlValueStack stack) {
        this.stack = stack;
        this.parameters = new HashMap();
        this.getComponentStack().push(this);
    }

    private String getComponentName() {
        Class<?> c = this.getClass();
        String name = c.getName();
        int dot = name.lastIndexOf(46);
        return name.substring(dot + 1).toLowerCase();
    }

    public OgnlValueStack getStack() {
        return this.stack;
    }

    public Stack getComponentStack() {
        Stack componentStack = (Stack)this.stack.getContext().get(COMPONENT_STACK);
        if (componentStack == null) {
            componentStack = new Stack();
            this.stack.getContext().put(COMPONENT_STACK, componentStack);
        }
        return componentStack;
    }

    public boolean start(Writer writer) {
        return true;
    }

    public boolean end(Writer writer, String body) {
        return this.end(writer, body, true);
    }

    protected boolean end(Writer writer, String body, boolean popComponentStack) {
        if (!$assertionsDisabled && body == null) {
            throw new AssertionError();
        }
        try {
            writer.write(body);
        }
        catch (IOException e) {
            throw new WebWorkException("IOError while writing the body: " + e.getMessage(), e);
        }
        if (popComponentStack) {
            this.popComponentStack();
        }
        return false;
    }

    protected void popComponentStack() {
        this.getComponentStack().pop();
    }

    protected Component findAncestor(Class clazz) {
        Stack componentStack = this.getComponentStack();
        int currPosition = componentStack.search(this);
        if (currPosition >= 0) {
            int start;
            for (int i = start = componentStack.size() - currPosition - 1; i >= 0; --i) {
                Component component = (Component)componentStack.get(i);
                if (!clazz.isAssignableFrom(component.getClass()) || component == this) continue;
                return component;
            }
        }
        return null;
    }

    protected String findString(String expr) {
        return (String)this.findValue(expr, String.class);
    }

    protected String findString(String expr, String field, String errorMsg) {
        if (expr == null) {
            throw this.fieldError(field, errorMsg, null);
        }
        return this.findString(expr);
    }

    protected WebWorkException fieldError(String field, String errorMsg, Exception e) {
        String msg = "tag '" + this.getComponentName() + "', field '" + field + (this.id != null ? "', id '" + this.id : "") + (this.parameters != null && this.parameters.containsKey("name") ? "', name '" + this.parameters.get("name") : "") + "': " + errorMsg;
        if (e == null) {
            LOG.error((Object)msg);
            return new WebWorkException(msg);
        }
        LOG.error((Object)msg, (Throwable)e);
        return new WebWorkException(msg, e);
    }

    protected Object findValue(String expr) {
        if (expr == null) {
            return null;
        }
        if (this.altSyntax() && expr.startsWith("%{") && expr.endsWith("}")) {
            expr = expr.substring(2, expr.length() - 1);
        }
        return this.getStack().findValue(expr);
    }

    public boolean altSyntax() {
        return ContextUtil.isUseAltSyntax(this.stack.getContext());
    }

    protected Object findValue(String expr, String field, String errorMsg) {
        if (expr == null) {
            throw this.fieldError(field, errorMsg, null);
        }
        Object value = null;
        Exception problem = null;
        try {
            value = this.findValue(expr);
        }
        catch (Exception e) {
            problem = e;
        }
        if (value == null) {
            throw this.fieldError(field, errorMsg, problem);
        }
        return value;
    }

    protected Object findValue(String expr, Class toType) {
        if (this.altSyntax() && toType == String.class) {
            return TextParseUtil.translateVariables((char)'%', (String)expr, (OgnlValueStack)this.stack);
        }
        if (this.altSyntax() && expr.startsWith("%{") && expr.endsWith("}")) {
            expr = expr.substring(2, expr.length() - 1);
        }
        return this.getStack().findValue(expr, toType);
    }

    protected String determineActionURL(String action, String namespace, String method, HttpServletRequest req, HttpServletResponse res, Map parameters, String scheme, boolean includeContext, boolean encodeResult, boolean escapeXml) {
        String finalAction = this.findString(action);
        String finalNamespace = this.determineNamespace(namespace, this.getStack(), req);
        ActionMapping mapping = new ActionMapping(finalAction, finalNamespace, method, parameters);
        ActionMapper mapper = ActionMapperFactory.getMapper();
        String uri = mapper.getUriFromActionMapping(mapping);
        return UrlHelper.buildUrl(uri, req, res, parameters, scheme, includeContext, encodeResult, false, escapeXml);
    }

    protected String determineNamespace(String namespace, OgnlValueStack stack, HttpServletRequest req) {
        String result = namespace == null ? TagUtils.buildNamespace(stack, req) : this.findString(namespace);
        if (result == null) {
            result = "";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyParams(Map params) {
        this.stack.push((Object)this.parameters);
        this.stack.push((Object)this);
        try {
            Iterator iterator = params.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String key = (String)entry.getKey();
                this.stack.setValue(key, entry.getValue());
            }
        }
        finally {
            this.stack.pop();
            this.stack.pop();
        }
    }

    protected String toString(Throwable t) {
        FastByteArrayOutputStream bout = new FastByteArrayOutputStream();
        PrintWriter wrt = new PrintWriter(bout);
        t.printStackTrace(wrt);
        wrt.close();
        return bout.toString();
    }

    public Map getParameters() {
        return this.parameters;
    }

    public void addAllParameters(Map params) {
        this.parameters.putAll(params);
    }

    public void addParameter(String key, Object value) {
        if (key != null) {
            Map params = this.getParameters();
            if (value == null) {
                params.remove(key);
            } else {
                params.put(key, value);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (id != null) {
            this.id = this.findString(id);
        }
    }

    public boolean usesBody() {
        return false;
    }

    static {
        $assertionsDisabled = !Component.class.desiredAssertionStatus();
        LOG = LogFactory.getLog((Class)Component.class);
    }
}

