/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.freemarker;

import com.opensymphony.xwork.util.OgnlValueStack;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ScopesHashModel
extends SimpleHash {
    private HttpServletRequest request;
    private ObjectWrapper objectWraper;
    private ServletContext servletContext;
    private OgnlValueStack stack;

    public ScopesHashModel(ObjectWrapper objectWrapper, ServletContext context, HttpServletRequest request, OgnlValueStack stack) {
        super(objectWrapper);
        this.servletContext = context;
        this.request = request;
        this.stack = stack;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        Object obj;
        TemplateModel model = super.get(key);
        if (model != null) {
            return model;
        }
        if (this.stack != null) {
            obj = this.stack.findValue(key);
            if (obj != null) {
                return this.wrap(obj);
            }
            obj = this.stack.getContext().get(key);
            if (obj != null) {
                return this.wrap(obj);
            }
        }
        if (this.request != null) {
            obj = this.request.getAttribute(key);
            if (obj != null) {
                return this.wrap(obj);
            }
            HttpSession session = this.request.getSession(false);
            if (session != null && (obj = session.getAttribute(key)) != null) {
                return this.wrap(obj);
            }
        }
        if (this.servletContext != null && (obj = this.servletContext.getAttribute(key)) != null) {
            return this.wrap(obj);
        }
        return null;
    }

    public void put(String string, boolean b) {
        super.put(string, b);
    }

    public void put(String string, Object object) {
        super.put(string, object);
    }
}

