/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.quickstart;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class MultiDirClassLoader
extends URLClassLoader {
    private ClassLoader parent;

    public MultiDirClassLoader(String[] dirs, String[] cps, ClassLoader parent) throws MalformedURLException {
        super(MultiDirClassLoader.getAllURLs(dirs, cps), parent);
        this.parent = parent;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        try {
            Class<?> aClass = this.parent.loadClass(name);
            if (aClass != null) {
                return aClass;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return super.loadClass(name);
    }

    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null && this.parent != null) {
            url = this.parent.getResource(name);
        }
        return url;
    }

    private static URL[] getAllURLs(String[] dirs, String[] cps) throws MalformedURLException {
        int i;
        ArrayList<URL> urls = new ArrayList<URL>();
        for (i = 0; i < cps.length; ++i) {
            String cp = cps[i];
            urls.add(new File(cp).toURL());
        }
        for (i = 0; i < dirs.length; ++i) {
            String dir = dirs[i];
            File file = new File(dir);
            MultiDirClassLoader.findJars(file, urls);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static void findJars(File file, ArrayList fileList) throws MalformedURLException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                MultiDirClassLoader.findJars(f, fileList);
            }
        } else if (file.getName().endsWith(".jar") && !file.getName().equals("tangosol-license-local.jar")) {
            fileList.add(file.toURL());
        }
    }
}

