/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.datetimepickers.year;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.olekdia.androidcommon.extensions.LocaleExt;
import com.olekdia.datetimepickers.ICommonDatePickerController;
import com.olekdia.datetimepickers.IOnDateChangedListener;
import com.olekdia.datetimepickers.R;
import com.olekdia.datetimepickers.calendars.CalendarCompat;
import com.olekdia.datetimepickers.year.TextViewWithCircularIndicator;

public class YearsPickerView
extends ListView
implements AdapterView.OnItemClickListener,
IOnDateChangedListener {
    private final ICommonDatePickerController mController;
    private final YearsAdapter mAdapter;
    private final int mViewSize;
    private final int mChildSize;
    private TextViewWithCircularIndicator mSelectedView;
    private final int[] mYearsProvider;
    private final LayoutInflater mInflater;
    private final int mCurrYear;
    private final Typeface mDefNormalTypeface;
    private final Typeface mDefBoldTypeface;

    public YearsPickerView(Context context, ICommonDatePickerController controller) {
        super(context);
        this.mController = controller;
        this.mController.registerOnDateChangedListener(this);
        ViewGroup.LayoutParams frame = new ViewGroup.LayoutParams(-1, -2);
        this.setLayoutParams(frame);
        this.mInflater = LayoutInflater.from((Context)context);
        this.mDefNormalTypeface = Typeface.create((Typeface)Typeface.DEFAULT, (int)0);
        this.mDefBoldTypeface = Typeface.create((Typeface)Typeface.DEFAULT, (int)1);
        Resources res = context.getResources();
        this.mViewSize = res.getDimensionPixelOffset(R.dimen.mdtp_date_picker_view_animator_height);
        this.mChildSize = res.getDimensionPixelOffset(R.dimen.mdtp_year_label_height);
        this.setVerticalFadingEdgeEnabled(true);
        this.setFadingEdgeLength(this.mChildSize / 3);
        this.mCurrYear = CalendarCompat.getInstance().get(1);
        int fromYear = this.mController.getMinYear();
        int toYear = this.mController.getMaxYear();
        this.mYearsProvider = new int[toYear - fromYear + 1];
        for (int year = fromYear; year <= toYear; ++year) {
            this.mYearsProvider[year - fromYear] = year;
        }
        this.mAdapter = new YearsAdapter();
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnItemClickListener(this);
        this.setSelector((Drawable)new StateListDrawable());
        this.setDividerHeight(0);
        this.onDateChanged();
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.mController.tryVibrate();
        TextViewWithCircularIndicator clickedView = (TextViewWithCircularIndicator)view;
        if (clickedView != null) {
            if (clickedView != this.mSelectedView) {
                if (this.mSelectedView != null) {
                    this.mSelectedView.drawIndicator(false);
                    this.mSelectedView.requestLayout();
                }
                clickedView.drawIndicator(true);
                clickedView.requestLayout();
                this.mSelectedView = clickedView;
            }
            this.mController.onYearSelected(YearsPickerView.getYearFromTextView(clickedView));
            this.mAdapter.notifyDataSetChanged();
        }
    }

    private static int getYearFromTextView(TextView view) {
        return (Integer)view.getTag();
    }

    public void postSetSelectionCentered(int position) {
        this.postSetSelectionFromTop(position, this.mViewSize / 2 - this.mChildSize / 2);
    }

    public void postSetSelectionFromTop(final int position, final int offset) {
        this.post(new Runnable(){

            @Override
            public void run() {
                YearsPickerView.this.setSelectionFromTop(position, offset);
                YearsPickerView.this.requestLayout();
            }
        });
    }

    public int getFirstPositionOffset() {
        View firstChild = this.getChildAt(0);
        if (firstChild == null) {
            return 0;
        }
        return firstChild.getTop();
    }

    @Override
    public void onDateChanged() {
        this.mAdapter.notifyDataSetChanged();
        this.postSetSelectionCentered(this.mController.getSelectedYear() - this.mController.getMinYear());
    }

    private class YearsAdapter
    extends BaseAdapter {
        public int getCount() {
            return YearsPickerView.this.mYearsProvider.length;
        }

        public Object getItem(int position) {
            return YearsPickerView.this.mYearsProvider[position];
        }

        public int getYear(int position) {
            return YearsPickerView.this.mYearsProvider[position];
        }

        public long getItemId(int position) {
            return YearsPickerView.this.mYearsProvider[position];
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = YearsPickerView.this.mInflater.inflate(R.layout.mdtp_year_label_text_view, parent, false);
            }
            TextViewWithCircularIndicator field = (TextViewWithCircularIndicator)convertView;
            int year = this.getYear(position);
            field.setText(LocaleExt.toLocalNumerals((int)year, (int)YearsPickerView.this.mController.getNumeralSystem()));
            field.setTag(year);
            field.setAccentColor(YearsPickerView.this.mController.getAccentColor(), YearsPickerView.this.mController.isThemeDark());
            field.requestLayout();
            boolean selected = YearsPickerView.this.mController.getSelectedYear() == year;
            field.drawIndicator(selected);
            if (selected) {
                YearsPickerView.this.mSelectedView = field;
            }
            field.setTypeface(YearsPickerView.this.mCurrYear == year ? YearsPickerView.this.mDefBoldTypeface : YearsPickerView.this.mDefNormalTypeface);
            return field;
        }
    }
}

