/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.datetimepickers.year;

import android.animation.ObjectAnimator;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import com.olekdia.androidcommon.extensions.LocaleExt;
import com.olekdia.androidcommon.extensions.MathExt;
import com.olekdia.androidcommon.extensions.ResExt;
import com.olekdia.datetimepickers.DTPickersHelper;
import com.olekdia.datetimepickers.HapticFeedbackController;
import com.olekdia.datetimepickers.IOnDateChangedListener;
import com.olekdia.datetimepickers.PickerDialog;
import com.olekdia.datetimepickers.R;
import com.olekdia.datetimepickers.calendars.CalendarCompat;
import com.olekdia.datetimepickers.date.DateAnimator;
import com.olekdia.datetimepickers.year.IYearPickerController;
import com.olekdia.datetimepickers.year.YearsPickerView;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;

public class YearPickerDialog
extends PickerDialog
implements View.OnClickListener,
IYearPickerController {
    private final Calendar mCalendar = CalendarCompat.getInstance();
    private OnDateSetListener mCallBack;
    private DateAnimator mAnimator;
    private boolean mDelayAnimation = true;
    private LinearLayout mYearContainer;
    private TextView mYearView;
    private YearsPickerView mYearsPickerView;
    private int mCurrentView = -1;
    private int mMinYear = MathExt.roundTo((int)(this.mCalendar.get(1) - 100), (int)100);
    private int mMaxYear = MathExt.roundTo((int)(this.mCalendar.get(1) + 200), (int)100);
    private Calendar mMinDate;
    private Calendar mMaxDate;
    private Calendar[] mHighlightedYears;
    private Calendar[] mSelectableYears;

    public void initialize(OnDateSetListener callBack, int year) {
        this.mCallBack = callBack;
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, 0);
        this.mCalendar.set(5, 1);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        FragmentActivity activity = this.getActivity();
        activity.getWindow().setSoftInputMode(3);
        this.mCurrentView = -1;
        if (savedInstanceState != null) {
            this.mCalendar.set(1, savedInstanceState.getInt("year"));
            this.mCalendar.set(2, 0);
            this.mCalendar.set(5, 1);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.setToNearestDate(this.mCalendar);
        View view = inflater.inflate(R.layout.mdtp_year_picker_dialog, container, false);
        this.mYearContainer = (LinearLayout)view.findViewById(R.id.year_picker_year_container);
        this.mYearContainer.setOnClickListener((View.OnClickListener)this);
        this.mYearView = (TextView)view.findViewById(R.id.year_picker_year);
        this.mYearView.setOnClickListener((View.OnClickListener)this);
        int listPosition = -1;
        int listPositionOffset = 0;
        int currentView = 1;
        if (savedInstanceState != null) {
            this.mMinYear = savedInstanceState.getInt("year_start");
            this.mMaxYear = savedInstanceState.getInt("year_end");
            currentView = savedInstanceState.getInt("current_view");
            listPosition = savedInstanceState.getInt("list_position");
            listPositionOffset = savedInstanceState.getInt("list_position_offset");
            this.mMinDate = (Calendar)savedInstanceState.getSerializable("min_date");
            this.mMaxDate = (Calendar)savedInstanceState.getSerializable("max_date");
            this.mHighlightedYears = (Calendar[])savedInstanceState.getSerializable("highlighted_days");
            this.mSelectableYears = (Calendar[])savedInstanceState.getSerializable("selectable_days");
            this.restoreInstanceState(savedInstanceState);
        }
        FragmentActivity activity = this.getActivity();
        this.mYearsPickerView = new YearsPickerView((Context)activity, this);
        if (!this.mThemeDarkChanged) {
            this.mThemeDark = DTPickersHelper.isDarkTheme((Context)activity, this.mThemeDark);
        }
        int bgColorResource = this.mThemeDark ? R.color.mdtp_date_picker_view_animator_dark_theme : R.color.mdtp_date_picker_view_animator;
        view.setBackgroundColor(ResExt.getColorCompat((Context)activity, (int)bgColorResource));
        this.mAnimator = (DateAnimator)view.findViewById(R.id.animator);
        this.mAnimator.addView((View)this.mYearsPickerView);
        AlphaAnimation animation = new AlphaAnimation(0.0f, 1.0f);
        animation.setDuration(300L);
        this.mAnimator.setInAnimation((Animation)animation);
        AlphaAnimation animation2 = new AlphaAnimation(1.0f, 0.0f);
        animation2.setDuration(300L);
        this.mAnimator.setOutAnimation((Animation)animation2);
        TextView okButton = (TextView)view.findViewById(R.id.ok);
        okButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                YearPickerDialog.this.tryVibrate();
                YearPickerDialog.this.notifyOnDateListener();
                YearPickerDialog.this.dismiss();
            }
        });
        if (this.mOkString != null) {
            okButton.setText((CharSequence)this.mOkString);
        } else {
            okButton.setText(this.mOkResId);
        }
        TextView cancelButton = (TextView)view.findViewById(R.id.cancel);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                YearPickerDialog.this.tryVibrate();
                if (YearPickerDialog.this.getDialog() != null) {
                    YearPickerDialog.this.getDialog().cancel();
                }
            }
        });
        if (this.mCancelString != null) {
            cancelButton.setText((CharSequence)this.mCancelString);
        } else {
            cancelButton.setText(this.mCancelResId);
        }
        cancelButton.setVisibility(this.isCancelable() ? 0 : 8);
        if (this.mAccentColor == -1) {
            this.mAccentColor = DTPickersHelper.getAccentColorFromThemeIfAvailable((Context)activity);
        }
        if (this.mPrimaryColor == -1) {
            this.mPrimaryColor = DTPickersHelper.getPrimaryColorFromThemeIfAvailable((Context)activity);
        }
        okButton.setTextColor(this.mAccentColor);
        cancelButton.setTextColor(this.mAccentColor);
        view.findViewById(R.id.year_picker_selected_year_layout).setBackgroundColor(this.mPrimaryColor);
        if (this.getDialog() == null) {
            view.findViewById(R.id.done_background).setVisibility(8);
        }
        this.updateDisplay();
        this.setCurrentView(currentView);
        if (listPosition != -1) {
            this.mYearsPickerView.postSetSelectionFromTop(listPosition, listPositionOffset);
        }
        this.mHapticFeedbackController = new HapticFeedbackController((Context)activity);
        return view;
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.requestWindowFeature(1);
        return dialog;
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("year", this.mCalendar.get(1));
        outState.putInt("year_start", this.mMinYear);
        outState.putInt("year_end", this.mMaxYear);
        outState.putInt("current_view", this.mCurrentView);
        outState.putInt("list_position_offset", this.mYearsPickerView.getFirstPositionOffset());
        outState.putInt("list_position", this.mYearsPickerView.getFirstVisiblePosition());
        outState.putSerializable("min_date", (Serializable)this.mMinDate);
        outState.putSerializable("max_date", (Serializable)this.mMaxDate);
        outState.putSerializable("highlighted_days", (Serializable)this.mHighlightedYears);
        outState.putSerializable("selectable_days", (Serializable)this.mSelectableYears);
    }

    private void setCurrentView(int viewIndex) {
        ObjectAnimator pulseAnimator = DTPickersHelper.getPulseAnimator((View)this.mYearView, 0.85f, 1.1f);
        if (this.mDelayAnimation) {
            pulseAnimator.setStartDelay(500L);
            this.mDelayAnimation = false;
        }
        if (this.mCurrentView != viewIndex) {
            this.mYearContainer.setSelected(false);
            this.mYearView.setSelected(true);
            this.mAnimator.setDisplayedChild(1);
            this.mCurrentView = viewIndex;
        }
        pulseAnimator.start();
    }

    private void updateDisplay() {
        this.mYearView.setText((CharSequence)LocaleExt.toLocalNumerals((int)this.mCalendar.get(1), (int)this.mNumeralSystem));
    }

    public void setYearRange(int startYear, int endYear) {
        if (endYear < startYear) {
            throw new IllegalArgumentException("Year end must be larger than or equal to year start");
        }
        this.mMinYear = startYear;
        this.mMaxYear = endYear;
    }

    public void setMinDate(Calendar calendar) {
        this.mMinDate = calendar;
    }

    public Calendar getMinDate() {
        return this.mMinDate;
    }

    public void setMaxDate(Calendar calendar) {
        this.mMaxDate = calendar;
    }

    public Calendar getMaxDate() {
        return this.mMaxDate;
    }

    public void setHighlightedYears(Calendar[] highlightedYears) {
        Arrays.sort(highlightedYears);
        this.mHighlightedYears = highlightedYears;
    }

    public Calendar[] getHighlightedYears() {
        return this.mHighlightedYears;
    }

    public void setSelectableYears(Calendar[] selectableYears) {
        Arrays.sort(selectableYears);
        this.mSelectableYears = selectableYears;
    }

    public Calendar[] getSelectableYears() {
        return this.mSelectableYears;
    }

    public void setOnDateSetListener(OnDateSetListener listener) {
        this.mCallBack = listener;
    }

    @Override
    public int getSelectedYear() {
        return this.mCalendar.get(1);
    }

    @Override
    public Calendar getStartDate() {
        if (this.mSelectableYears != null) {
            return this.mSelectableYears[0];
        }
        if (this.mMinDate != null) {
            return this.mMinDate;
        }
        Calendar output = Calendar.getInstance();
        output.set(1, this.mMinYear);
        output.set(2, 0);
        output.set(5, 1);
        return output;
    }

    @Override
    public Calendar getEndDate() {
        if (this.mSelectableYears != null) {
            return this.mSelectableYears[this.mSelectableYears.length - 1];
        }
        if (this.mMaxDate != null) {
            return this.mMaxDate;
        }
        Calendar output = Calendar.getInstance();
        output.set(1, this.mMaxYear);
        output.set(2, 11);
        output.set(5, 31);
        return output;
    }

    @Override
    public int getMinYear() {
        if (this.mSelectableYears != null) {
            return this.mSelectableYears[0].get(1);
        }
        return this.mMinDate != null && this.mMinDate.get(1) > this.mMinYear ? this.mMinDate.get(1) : this.mMinYear;
    }

    @Override
    public int getMaxYear() {
        if (this.mSelectableYears != null) {
            return this.mSelectableYears[this.mSelectableYears.length - 1].get(1);
        }
        return this.mMaxDate != null && this.mMaxDate.get(1) < this.mMaxYear ? this.mMaxDate.get(1) : this.mMaxYear;
    }

    @Override
    public boolean isOutOfRange(int year) {
        if (this.mSelectableYears != null) {
            return !this.isSelectable(year);
        }
        if (this.isBeforeMin(year)) {
            return true;
        }
        return this.isAfterMax(year);
    }

    public boolean isOutOfRange(Calendar calendar) {
        return this.isOutOfRange(calendar.get(1));
    }

    private boolean isSelectable(int year) {
        for (Calendar c : this.mSelectableYears) {
            if (year < c.get(1)) break;
            if (year > c.get(1)) continue;
            return true;
        }
        return false;
    }

    private boolean isBeforeMin(int year) {
        if (this.mMinDate == null) {
            return false;
        }
        return year < this.mMinDate.get(1);
    }

    private boolean isBeforeMin(Calendar calendar) {
        return this.isBeforeMin(calendar.get(1));
    }

    private boolean isAfterMax(int year) {
        if (this.mMaxDate == null) {
            return false;
        }
        return year > this.mMaxDate.get(1);
    }

    private boolean isAfterMax(Calendar calendar) {
        return this.isAfterMax(calendar.get(1));
    }

    private void setToNearestDate(Calendar calendar) {
        if (this.mSelectableYears != null) {
            long distance = Long.MAX_VALUE;
            Calendar currentBest = calendar;
            for (Calendar c : this.mSelectableYears) {
                long newDistance = Math.abs(calendar.getTimeInMillis() - c.getTimeInMillis());
                if (newDistance >= distance) break;
                distance = newDistance;
                currentBest = c;
            }
            calendar.setTimeInMillis(currentBest.getTimeInMillis());
            return;
        }
        if (this.isBeforeMin(calendar)) {
            calendar.setTimeInMillis(this.mMinDate.getTimeInMillis());
            return;
        }
        if (this.isAfterMax(calendar)) {
            calendar.setTimeInMillis(this.mMaxDate.getTimeInMillis());
            return;
        }
    }

    @Override
    public void registerOnDateChangedListener(IOnDateChangedListener listener) {
    }

    @Override
    public void unregisterOnDateChangedListener(IOnDateChangedListener listener) {
    }

    public void notifyOnDateListener() {
        if (this.mCallBack != null) {
            this.mCallBack.onDateSet(this, this.mCalendar.get(1));
        }
    }

    public void onClick(View v) {
        this.tryVibrate();
        this.setCurrentView(1);
        this.mYearsPickerView.onDateChanged();
    }

    @Override
    public void onYearSelected(int year) {
        this.mCalendar.set(1, year);
        this.updateDisplay();
        if (this.mAutoDismiss) {
            this.notifyOnDateListener();
            this.dismiss();
        }
    }

    public static interface OnDateSetListener {
        public void onDateSet(YearPickerDialog var1, int var2);
    }
}

