/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.datetimepickers.time;

import android.animation.ObjectAnimator;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import com.olekdia.androidcommon.extensions.LocaleExt;
import com.olekdia.androidcommon.extensions.ResExt;
import com.olekdia.datetimepickers.DTPickersHelper;
import com.olekdia.datetimepickers.HapticFeedbackController;
import com.olekdia.datetimepickers.PickerDialog;
import com.olekdia.datetimepickers.R;
import com.olekdia.datetimepickers.time.ITimePickerController;
import com.olekdia.datetimepickers.time.RadialPickerLayout;
import com.olekdia.datetimepickers.time.Timepoint;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class TimePickerDialog
extends PickerDialog
implements RadialPickerLayout.OnValueSelectedListener,
ITimePickerController {
    public static final int HOUR_INDEX = 0;
    public static final int MINUTE_INDEX = 1;
    public static final int SECOND_INDEX = 2;
    private static final int PULSE_ANIMATOR_DELAY = 300;
    private OnTimeSetListener mCallback;
    private TextView mCancelButton;
    private TextView mOkButton;
    private TextView mHourView;
    private TextView mHourSpaceView;
    private TextView mMinuteView;
    private TextView mMinuteSpaceView;
    private TextView mSecondView;
    private TextView mSecondSpaceView;
    private TextView mAmPmTextView;
    private View mAmPmHitspace;
    private RadialPickerLayout mTimePicker;
    private int mSelectedColor;
    private int mUnselectedColor;
    private String mAmText = null;
    private String mPmText = null;
    private boolean mAllowAutoAdvance;
    private Timepoint mInitialTime;
    private boolean mIs24HourMode;
    private Timepoint[] mSelectableTimes;
    private Timepoint mMinTime;
    private Timepoint mMaxTime;
    private boolean mEnableSeconds;
    private String mDoublePlaceholderText;

    public static TimePickerDialog newInstance(OnTimeSetListener callback, int hourOfDay, int minute, int second, boolean is24HourMode) {
        TimePickerDialog ret = new TimePickerDialog();
        ret.initialize(callback, hourOfDay, minute, second, is24HourMode);
        return ret;
    }

    public static TimePickerDialog newInstance(OnTimeSetListener callback, int hourOfDay, int minute, boolean is24HourMode) {
        return TimePickerDialog.newInstance(callback, hourOfDay, minute, 0, is24HourMode);
    }

    public void initialize(OnTimeSetListener callback, int hourOfDay, int minute, int second, boolean is24HourMode) {
        this.mCallback = callback;
        this.mInitialTime = new Timepoint(hourOfDay, minute, second);
        this.mIs24HourMode = is24HourMode;
        this.mTitle = "";
        this.mThemeDark = false;
        this.mThemeDarkChanged = false;
        this.mAccentColor = -1;
        this.mVibrate = true;
        this.mDismissOnPause = false;
        this.mEnableSeconds = false;
        this.mOkResId = R.string.mdtp_ok;
        this.mCancelResId = R.string.mdtp_cancel;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null && savedInstanceState.containsKey("initial_time") && savedInstanceState.containsKey("is_24_hour_view")) {
            this.mInitialTime = (Timepoint)savedInstanceState.getParcelable("initial_time");
            this.mIs24HourMode = savedInstanceState.getBoolean("is_24_hour_view");
            this.mSelectableTimes = (Timepoint[])savedInstanceState.getParcelableArray("selectable_times");
            this.mMinTime = (Timepoint)savedInstanceState.getParcelable("min_time");
            this.mMaxTime = (Timepoint)savedInstanceState.getParcelable("max_time");
            this.mEnableSeconds = savedInstanceState.getBoolean("enable_seconds");
            this.mAmText = savedInstanceState.getString("am");
            this.mPmText = savedInstanceState.getString("pm");
            this.restoreInstanceState(savedInstanceState);
        }
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.mdtp_time_picker_dialog, container, false);
        FragmentActivity activity = this.getActivity();
        Resources res = this.getResources();
        if (this.mAccentColor == -1) {
            this.mAccentColor = DTPickersHelper.getAccentColorFromThemeIfAvailable((Context)activity);
        }
        if (this.mPrimaryColor == -1) {
            this.mPrimaryColor = DTPickersHelper.getPrimaryColorFromThemeIfAvailable((Context)activity);
        }
        if (!this.mThemeDarkChanged) {
            this.mThemeDark = DTPickersHelper.isDarkTheme((Context)activity, this.mThemeDark);
        }
        this.mSelectedColor = ResExt.getColorCompat((Context)activity, (int)R.color.mdtp_white);
        this.mUnselectedColor = ResExt.getColorCompat((Context)activity, (int)R.color.mdtp_accent_color_focused);
        this.mHourView = (TextView)view.findViewById(R.id.hours);
        this.mHourSpaceView = (TextView)view.findViewById(R.id.hour_space);
        this.mMinuteSpaceView = (TextView)view.findViewById(R.id.minutes_space);
        this.mMinuteView = (TextView)view.findViewById(R.id.minutes);
        this.mSecondSpaceView = (TextView)view.findViewById(R.id.seconds_space);
        this.mSecondView = (TextView)view.findViewById(R.id.seconds);
        this.mAmPmTextView = (TextView)view.findViewById(R.id.ampm_label);
        if (this.mAmText == null || this.mPmText == null) {
            String[] amPmTexts = new DateFormatSymbols().getAmPmStrings();
            this.mAmText = amPmTexts[0];
            this.mPmText = amPmTexts[1];
        }
        this.mHapticFeedbackController = new HapticFeedbackController((Context)this.getActivity());
        this.mInitialTime = this.roundToNearest(this.mInitialTime);
        this.mTimePicker = (RadialPickerLayout)view.findViewById(R.id.time_picker);
        this.mTimePicker.setOnValueSelectedListener(this);
        this.mTimePicker.initialize((Context)this.getActivity(), this, this.mInitialTime, this.mIs24HourMode);
        int currentItemShowing = 0;
        if (savedInstanceState != null && savedInstanceState.containsKey("current_item_showing")) {
            currentItemShowing = savedInstanceState.getInt("current_item_showing");
        }
        this.setCurrentItemShowing(currentItemShowing, false, true);
        this.mTimePicker.invalidate();
        this.mHourView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TimePickerDialog.this.setCurrentItemShowing(0, true, false);
                TimePickerDialog.this.tryVibrate();
            }
        });
        this.mMinuteView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TimePickerDialog.this.setCurrentItemShowing(1, true, false);
                TimePickerDialog.this.tryVibrate();
            }
        });
        this.mSecondView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TimePickerDialog.this.setCurrentItemShowing(2, true, false);
                TimePickerDialog.this.tryVibrate();
            }
        });
        this.mOkButton = (TextView)view.findViewById(R.id.ok);
        this.mOkButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TimePickerDialog.this.tryVibrate();
                TimePickerDialog.this.notifyOnDateListener();
                TimePickerDialog.this.dismiss();
            }
        });
        if (this.mOkString != null) {
            this.mOkButton.setText((CharSequence)this.mOkString);
        } else {
            this.mOkButton.setText(this.mOkResId);
        }
        this.mCancelButton = (TextView)view.findViewById(R.id.cancel);
        this.mCancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TimePickerDialog.this.tryVibrate();
                if (TimePickerDialog.this.getDialog() != null) {
                    TimePickerDialog.this.getDialog().cancel();
                }
            }
        });
        if (this.mCancelString != null) {
            this.mCancelButton.setText((CharSequence)this.mCancelString);
        } else {
            this.mCancelButton.setText(this.mCancelResId);
        }
        this.mCancelButton.setVisibility(this.isCancelable() ? 0 : 8);
        this.mAmPmHitspace = view.findViewById(R.id.ampm_hitspace);
        if (this.mIs24HourMode) {
            this.mAmPmTextView.setVisibility(8);
        } else {
            this.mAmPmTextView.setVisibility(0);
            this.updateAmPmDisplay(this.mInitialTime.isAM() ? 0 : 1);
            this.mAmPmHitspace.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (TimePickerDialog.this.isAmDisabled() || TimePickerDialog.this.isPmDisabled()) {
                        return;
                    }
                    TimePickerDialog.this.tryVibrate();
                    int amOrPm = TimePickerDialog.this.mTimePicker.getIsCurrentlyAmOrPm();
                    if (amOrPm == 0) {
                        amOrPm = 1;
                    } else if (amOrPm == 1) {
                        amOrPm = 0;
                    }
                    TimePickerDialog.this.mTimePicker.setAmOrPm(amOrPm);
                }
            });
        }
        if (!this.mEnableSeconds) {
            this.mSecondSpaceView.setVisibility(8);
            view.findViewById(R.id.separator_seconds).setVisibility(8);
        }
        if (this.mIs24HourMode && !this.mEnableSeconds) {
            RelativeLayout.LayoutParams paramsSeparator = new RelativeLayout.LayoutParams(-2, -2);
            paramsSeparator.addRule(13);
            TextView separatorView = (TextView)view.findViewById(R.id.separator);
            separatorView.setLayoutParams((ViewGroup.LayoutParams)paramsSeparator);
        } else if (this.mEnableSeconds) {
            RelativeLayout.LayoutParams paramsMinutes;
            View separator = view.findViewById(R.id.separator);
            RelativeLayout.LayoutParams paramsSeparator = new RelativeLayout.LayoutParams(-2, -2);
            paramsSeparator.addRule(0, R.id.minutes_space);
            paramsSeparator.addRule(15, -1);
            separator.setLayoutParams((ViewGroup.LayoutParams)paramsSeparator);
            if (!this.mIs24HourMode) {
                paramsMinutes = new RelativeLayout.LayoutParams(-2, -2);
                paramsMinutes.addRule(13);
                this.mMinuteSpaceView.setLayoutParams((ViewGroup.LayoutParams)paramsMinutes);
            } else {
                paramsMinutes = new RelativeLayout.LayoutParams(-2, -2);
                paramsMinutes.addRule(1, R.id.center_view);
                this.mMinuteSpaceView.setLayoutParams((ViewGroup.LayoutParams)paramsMinutes);
            }
        }
        this.mAllowAutoAdvance = true;
        this.setHour(this.mInitialTime.getHour());
        this.setMinute(this.mInitialTime.getMinute());
        this.setSecond(this.mInitialTime.getSecond());
        this.mDoublePlaceholderText = res.getString(R.string.mdtp_time_placeholder);
        TextView timePickerHeader = (TextView)view.findViewById(R.id.time_picker_header);
        if (!this.mTitle.isEmpty()) {
            timePickerHeader.setVisibility(0);
            timePickerHeader.setText((CharSequence)this.mTitle.toUpperCase(Locale.getDefault()));
        }
        this.mOkButton.setTextColor(this.mAccentColor);
        this.mCancelButton.setTextColor(this.mAccentColor);
        timePickerHeader.setBackgroundColor(this.mPrimaryColor);
        view.findViewById(R.id.time_display_background).setBackgroundColor(this.mPrimaryColor);
        view.findViewById(R.id.time_display).setBackgroundColor(this.mPrimaryColor);
        if (this.getDialog() == null) {
            view.findViewById(R.id.done_background).setVisibility(8);
        }
        int backgroundColor = ResExt.getColorCompat((Context)activity, (int)R.color.mdtp_secondary_light);
        int darkBackgroundColor = ResExt.getColorCompat((Context)activity, (int)R.color.mdtp_ternary_light_dark_theme);
        this.mTimePicker.setBackgroundColor(this.mThemeDark ? darkBackgroundColor : backgroundColor);
        view.findViewById(R.id.time_picker_dialog).setBackgroundColor(this.mThemeDark ? darkBackgroundColor : backgroundColor);
        return view;
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.requestWindowFeature(1);
        return dialog;
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        if (this.mTimePicker != null) {
            super.onSaveInstanceState(outState);
            outState.putParcelable("initial_time", (Parcelable)this.mTimePicker.getTime());
            outState.putBoolean("is_24_hour_view", this.mIs24HourMode);
            outState.putInt("current_item_showing", this.mTimePicker.getCurrentItemShowing());
            outState.putParcelableArray("selectable_times", (Parcelable[])this.mSelectableTimes);
            outState.putParcelable("min_time", (Parcelable)this.mMinTime);
            outState.putParcelable("max_time", (Parcelable)this.mMaxTime);
            outState.putBoolean("enable_seconds", this.mEnableSeconds);
            outState.putString("am", this.mAmText);
            outState.putString("pm", this.mPmText);
        }
    }

    private void updateAmPmDisplay(int amOrPm) {
        if (amOrPm == 0) {
            this.mAmPmTextView.setText((CharSequence)this.mAmText);
        } else if (amOrPm == 1) {
            this.mAmPmTextView.setText((CharSequence)this.mPmText);
        } else {
            this.mAmPmTextView.setText((CharSequence)this.mDoublePlaceholderText);
        }
    }

    @Override
    public void advancePicker(int index) {
        if (!this.mAllowAutoAdvance) {
            return;
        }
        if (index == 0) {
            this.setCurrentItemShowing(1, true, true);
        } else if (index == 1 && this.mEnableSeconds) {
            this.setCurrentItemShowing(2, true, true);
        }
    }

    private void setCurrentItemShowing(int index, boolean animateCircle, boolean delayLabelAnimate) {
        TextView labelToAnimate;
        this.mTimePicker.setCurrentItemShowing(index, animateCircle);
        switch (index) {
            case 0: {
                labelToAnimate = this.mHourView;
                break;
            }
            case 1: {
                labelToAnimate = this.mMinuteView;
                break;
            }
            default: {
                labelToAnimate = this.mSecondView;
            }
        }
        int hourColor = index == 0 ? this.mSelectedColor : this.mUnselectedColor;
        int minuteColor = index == 1 ? this.mSelectedColor : this.mUnselectedColor;
        int secondColor = index == 2 ? this.mSelectedColor : this.mUnselectedColor;
        this.mHourView.setTextColor(hourColor);
        this.mMinuteView.setTextColor(minuteColor);
        this.mSecondView.setTextColor(secondColor);
        ObjectAnimator pulseAnimator = DTPickersHelper.getPulseAnimator((View)labelToAnimate, 0.85f, 1.1f);
        if (delayLabelAnimate) {
            pulseAnimator.setStartDelay(300L);
        }
        pulseAnimator.start();
    }

    @Override
    public boolean is24HourMode() {
        return this.mIs24HourMode;
    }

    public void enableSeconds(boolean enableSeconds) {
        this.mEnableSeconds = enableSeconds;
    }

    public void setMinTime(int hour, int minute, int second) {
        this.setMinTime(new Timepoint(hour, minute, second));
    }

    public void setMinTime(Timepoint minTime) {
        if (this.mMaxTime != null && minTime.compareTo(this.mMaxTime) > 0) {
            throw new IllegalArgumentException("Minimum time must be smaller than the maximum time");
        }
        this.mMinTime = minTime;
    }

    public void setMaxTime(int hour, int minute, int second) {
        this.setMaxTime(new Timepoint(hour, minute, second));
    }

    public void setMaxTime(Timepoint maxTime) {
        if (this.mMinTime != null && maxTime.compareTo(this.mMinTime) < 0) {
            throw new IllegalArgumentException("Maximum time must be greater than the minimum time");
        }
        this.mMaxTime = maxTime;
    }

    public void setSelectableTimes(Timepoint[] selectableTimes) {
        this.mSelectableTimes = selectableTimes;
        Arrays.sort(this.mSelectableTimes);
    }

    public void setTimeInterval(@IntRange(from=1L, to=24L) int hourInterval, @IntRange(from=1L, to=60L) int minuteInterval, @IntRange(from=1L, to=60L) int secondInterval) {
        ArrayList<Timepoint> timepoints = new ArrayList<Timepoint>();
        for (int hour = 0; hour < 24; hour += hourInterval) {
            for (int minute = 0; minute < 60; minute += minuteInterval) {
                for (int second = 0; second < 60; second += secondInterval) {
                    timepoints.add(new Timepoint(hour, minute, second));
                }
            }
        }
        this.setSelectableTimes(timepoints.toArray(new Timepoint[timepoints.size()]));
    }

    public void setTimeInterval(@IntRange(from=1L, to=24L) int hourInterval, @IntRange(from=1L, to=60L) int minuteInterval) {
        this.setTimeInterval(hourInterval, minuteInterval, 1);
    }

    public void setTimeInterval(@IntRange(from=1L, to=24L) int hourInterval) {
        this.setTimeInterval(hourInterval, 1);
    }

    public void setOnTimeSetListener(OnTimeSetListener callback) {
        this.mCallback = callback;
    }

    public void setStartTime(int hourOfDay, int minute, int second) {
        this.mInitialTime = this.roundToNearest(new Timepoint(hourOfDay, minute, second));
    }

    public void setStartTime(int hourOfDay, int minute) {
        this.setStartTime(hourOfDay, minute, 0);
    }

    public boolean isOutOfRange(Timepoint current) {
        if (this.mMinTime != null && this.mMinTime.compareTo(current) > 0) {
            return true;
        }
        if (this.mMaxTime != null && this.mMaxTime.compareTo(current) < 0) {
            return true;
        }
        if (this.mSelectableTimes != null) {
            return !Arrays.asList(this.mSelectableTimes).contains(current);
        }
        return false;
    }

    @Override
    public boolean isOutOfRange(Timepoint current, int index) {
        if (current == null) {
            return false;
        }
        if (index == 0) {
            if (this.mMinTime != null && this.mMinTime.getHour() > current.getHour()) {
                return true;
            }
            if (this.mMaxTime != null && this.mMaxTime.getHour() + 1 <= current.getHour()) {
                return true;
            }
            if (this.mSelectableTimes != null) {
                for (Timepoint t : this.mSelectableTimes) {
                    if (t.getHour() != current.getHour()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (index == 1) {
            Timepoint roundedMax;
            Timepoint roundedMin;
            if (this.mMinTime != null && (roundedMin = new Timepoint(this.mMinTime.getHour(), this.mMinTime.getMinute())).compareTo(current) > 0) {
                return true;
            }
            if (this.mMaxTime != null && (roundedMax = new Timepoint(this.mMaxTime.getHour(), this.mMaxTime.getMinute(), 59)).compareTo(current) < 0) {
                return true;
            }
            if (this.mSelectableTimes != null) {
                for (Timepoint t : this.mSelectableTimes) {
                    if (t.getHour() != current.getHour() || t.getMinute() != current.getMinute()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return this.isOutOfRange(current);
    }

    @Override
    public boolean isAmDisabled() {
        Timepoint midday = new Timepoint(12);
        if (this.mMinTime != null && this.mMinTime.compareTo(midday) > 0) {
            return true;
        }
        if (this.mSelectableTimes != null) {
            for (Timepoint t : this.mSelectableTimes) {
                if (t.compareTo(midday) >= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isPmDisabled() {
        Timepoint midday = new Timepoint(12);
        if (this.mMaxTime != null && this.mMaxTime.compareTo(midday) < 0) {
            return true;
        }
        if (this.mSelectableTimes != null) {
            for (Timepoint t : this.mSelectableTimes) {
                if (t.compareTo(midday) < 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getAmText() {
        return this.mAmText;
    }

    public void setAmText(String am) {
        this.mAmText = am;
    }

    @Override
    public String getPmText() {
        return this.mPmText;
    }

    public void setPmText(String pm) {
        this.mPmText = pm;
    }

    private Timepoint roundToNearest(Timepoint time) {
        return this.roundToNearest(time, Timepoint.TYPE.HOUR);
    }

    @Override
    public Timepoint roundToNearest(Timepoint time, Timepoint.TYPE type) {
        if (this.mMinTime != null && this.mMinTime.compareTo(time) > 0) {
            return this.mMinTime;
        }
        if (this.mMaxTime != null && this.mMaxTime.compareTo(time) < 0) {
            return this.mMaxTime;
        }
        if (this.mSelectableTimes != null) {
            int currentDistance = Integer.MAX_VALUE;
            Timepoint output = time;
            for (Timepoint t : this.mSelectableTimes) {
                if (type == Timepoint.TYPE.MINUTE && t.getHour() != time.getHour() || type == Timepoint.TYPE.SECOND && t.getHour() != time.getHour() && t.getMinute() != time.getMinute()) continue;
                int newDistance = Math.abs(t.compareTo(time));
                if (newDistance >= currentDistance) break;
                currentDistance = newDistance;
                output = t;
            }
            return output;
        }
        return time;
    }

    private void setHour(int value) {
        String text;
        if (this.mIs24HourMode) {
            text = LocaleExt.toLocal2DigNumerals((int)value, (int)this.mNumeralSystem);
        } else {
            if ((value %= 12) == 0) {
                value = 12;
            }
            text = LocaleExt.toLocalNumerals((int)value, (int)this.mNumeralSystem);
        }
        this.mHourView.setText((CharSequence)text);
        this.mHourSpaceView.setText((CharSequence)text);
    }

    private void setMinute(int value) {
        if (value == 60) {
            value = 0;
        }
        String text = LocaleExt.toLocal2DigNumerals((int)value, (int)this.mNumeralSystem);
        this.mMinuteView.setText((CharSequence)text);
        this.mMinuteSpaceView.setText((CharSequence)text);
    }

    private void setSecond(int value) {
        if (value == 60) {
            value = 0;
        }
        String text = LocaleExt.toLocal2DigNumerals((int)value, (int)this.mNumeralSystem);
        this.mSecondView.setText((CharSequence)text);
        this.mSecondSpaceView.setText((CharSequence)text);
    }

    public void notifyOnDateListener() {
        if (this.mCallback != null) {
            this.mCallback.onTimeSet(this.mTimePicker, this.mTimePicker.getHours(), this.mTimePicker.getMinutes(), this.mTimePicker.getSeconds());
        }
    }

    @Override
    public void onValueSelected(Timepoint newValue) {
        this.setHour(newValue.getHour());
        this.setMinute(newValue.getMinute());
        this.setSecond(newValue.getSecond());
        if (!this.mIs24HourMode) {
            this.updateAmPmDisplay(newValue.isAM() ? 0 : 1);
        }
    }

    public static interface OnTimeSetListener {
        public void onTimeSet(RadialPickerLayout var1, int var2, int var3, int var4);
    }
}

