/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.datetimepickers.month;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import com.olekdia.androidcommon.extensions.LocaleExt;
import com.olekdia.androidcommon.extensions.ResExt;
import com.olekdia.datetimepickers.R;
import com.olekdia.datetimepickers.calendars.CalendarCompat;
import com.olekdia.datetimepickers.month.IMonthPickerController;
import com.olekdia.datetimepickers.month.YearAdapter;
import java.util.Calendar;

public abstract class YearView
extends View {
    public static final int NUM_ROWS = 4;
    public static final int NUM_COLUMNS = 3;
    public static final int FIRST_MONTH = 0;
    private final Calendar mCalendarForDraw;
    private final Calendar mCalendar;
    private final boolean mIsRtl;
    protected final int mMonthTitleTextSize;
    protected final int mYearTextSize;
    protected final int mYearHeaderSize;
    protected float mSelectedRectHeight;
    private float mYearTopPadding;
    private String mYearTitleTypeface;
    protected Typeface mDefNormalTypeface;
    protected Typeface mDefBoldTypeface;
    protected Paint mMonthTitlePaint;
    protected Paint mYearTitlePaint;
    protected Paint mSelectedRectPaint;
    protected int mPrimaryTextColor;
    protected int mSecondaryTextColor;
    protected int mSelectedMonthTextColor;
    protected final IMonthPickerController mController;
    protected int mWidth;
    protected final int mRowHeight;
    protected OnMonthClickListener mOnMonthClickListener;
    protected int mCurrantMonth;
    protected int mCurrantYear;
    protected int mSelectedMonth = -1;
    protected int mSelectedYear = -1;
    protected int mYear;

    public YearView(Context context) {
        this(context, null, null);
    }

    public YearView(Context context, AttributeSet attr2, IMonthPickerController controller) {
        super(context, attr2);
        boolean darkTheme;
        this.mController = controller;
        Resources res = context.getResources();
        this.mCalendarForDraw = CalendarCompat.getInstance();
        this.mCalendar = CalendarCompat.getInstance();
        this.mIsRtl = LocaleExt.isLayoutRtl((Resources)res);
        this.mCurrantMonth = this.mCalendar.get(2);
        this.mCurrantYear = this.mCalendar.get(1);
        this.mYearTitleTypeface = res.getString(R.string.mdtp_sans_serif);
        this.mDefNormalTypeface = Typeface.create((Typeface)Typeface.DEFAULT, (int)0);
        this.mDefBoldTypeface = Typeface.create((Typeface)Typeface.DEFAULT, (int)1);
        boolean bl = darkTheme = this.mController != null && this.mController.isThemeDark();
        if (darkTheme) {
            this.mPrimaryTextColor = ResExt.getColorCompat((Context)context, (int)R.color.mdtp_date_picker_text_normal_dark_theme);
            this.mSecondaryTextColor = ResExt.getColorCompat((Context)context, (int)R.color.mdtp_date_picker_month_day_dark_theme);
        } else {
            this.mPrimaryTextColor = ResExt.getColorCompat((Context)context, (int)R.color.mdtp_date_picker_text_normal);
            this.mSecondaryTextColor = ResExt.getColorCompat((Context)context, (int)R.color.mdtp_date_picker_month_day);
        }
        this.mSelectedMonthTextColor = ResExt.getColorCompat((Context)context, (int)R.color.mdtp_white);
        this.mMonthTitleTextSize = res.getDimensionPixelSize(R.dimen.mdtp_day_number_size);
        this.mYearTextSize = res.getDimensionPixelSize(R.dimen.mdtp_month_label_size);
        this.mYearHeaderSize = res.getDimensionPixelOffset(R.dimen.mdtp_year_list_item_header_height);
        this.mYearTopPadding = (float)(this.mYearHeaderSize / 2) + (float)this.mYearTextSize * 0.4f;
        this.mRowHeight = (res.getDimensionPixelOffset(R.dimen.mdtp_date_picker_view_animator_height) - this.getMonthHeaderSize() * 2) / 4;
        this.initView();
    }

    protected void initView() {
        this.mYearTitlePaint = new Paint(1);
        this.mYearTitlePaint.setFakeBoldText(true);
        this.mYearTitlePaint.setTextSize((float)this.mYearTextSize);
        this.mYearTitlePaint.setTypeface(Typeface.create((String)this.mYearTitleTypeface, (int)1));
        this.mYearTitlePaint.setColor(this.mPrimaryTextColor);
        this.mYearTitlePaint.setTextAlign(Paint.Align.CENTER);
        this.mYearTitlePaint.setStyle(Paint.Style.FILL);
        this.mMonthTitlePaint = new Paint(1);
        this.mMonthTitlePaint.setTextSize((float)this.mMonthTitleTextSize);
        this.mMonthTitlePaint.setStyle(Paint.Style.FILL);
        this.mMonthTitlePaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthTitlePaint.setFakeBoldText(true);
        Rect bounds = new Rect();
        this.mMonthTitlePaint.getTextBounds("0", 0, 1, bounds);
        this.mSelectedRectHeight = bounds.height();
        this.mSelectedRectPaint = new Paint(1);
        this.mSelectedRectPaint.setColor(this.mController.getAccentColor());
        this.mSelectedRectPaint.setStyle(Paint.Style.FILL);
    }

    public void setSelectedMonth(int selectedMonth) {
        this.mSelectedMonth = selectedMonth;
    }

    public void setSelectedYear(int selectedYear) {
        this.mSelectedYear = selectedYear;
    }

    public void setOnDayClickListener(OnMonthClickListener listener) {
        this.mOnMonthClickListener = listener;
    }

    public void setMonthParams(int year) {
        this.mYear = year;
        this.mCalendar.set(1, this.mYear);
        this.mCalendar.set(2, 0);
        this.mCalendar.set(5, 1);
    }

    public int getYear() {
        return this.mYear;
    }

    public void reuse() {
        this.requestLayout();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mWidth = w;
    }

    protected void onDraw(Canvas canvas) {
        this.drawYearTitle(canvas);
        this.drawYearMonths(canvas);
    }

    protected void drawYearTitle(Canvas canvas) {
        int year = this.mCalendar.get(1);
        canvas.drawText(this.getYearString(year), (float)(this.mWidth / 2), this.mYearTopPadding, this.mYearTitlePaint);
    }

    protected int getMonthHeaderSize() {
        return this.mYearHeaderSize;
    }

    @NonNull
    private String getYearString(int year) {
        return LocaleExt.toLocalNumerals((int)year, (int)this.mController.getNumeralSystem());
    }

    protected void drawYearMonths(Canvas canvas) {
        float columnW = this.mWidth / 3;
        float rowH = this.mRowHeight;
        float firstColumnX = this.mIsRtl ? (float)this.mWidth - columnW / 2.0f : columnW / 2.0f;
        float nextColumnDelta = this.mIsRtl ? -columnW : columnW;
        float x = firstColumnX;
        float y = (float)this.getMonthHeaderSize() + rowH / 2.0f;
        for (int i = 1; i <= 12; ++i) {
            this.mCalendarForDraw.set(2, -1 + i);
            this.mCalendarForDraw.set(1, this.mYear);
            this.drawYearMonth(canvas, this.mCalendarForDraw.get(1), this.mCalendarForDraw.get(2), x, y);
            x += nextColumnDelta;
            if (i % 3 != 0) continue;
            x = firstColumnX;
            y += rowH;
        }
    }

    public abstract void drawYearMonth(Canvas var1, int var2, int var3, float var4, float var5);

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        switch (event.getAction()) {
            case 1: {
                int month = this.getMonthFromLocation(event.getX(), event.getY());
                if (month < 0) break;
                this.onMonthClick(month);
            }
        }
        return true;
    }

    public int getMonthFromLocation(float x, float y) {
        float columnW = this.mWidth / 3;
        float rowH = this.mRowHeight;
        int cellX = (int)Math.floor(this.mIsRtl ? (double)(((float)this.mWidth - x) / columnW) : (double)(x / columnW));
        int cellY = (int)Math.floor((y - (float)this.getMonthHeaderSize()) / rowH);
        return cellY * 3 + cellX;
    }

    private void onMonthClick(int month) {
        if (this.mController.isOutOfRange(this.mYear, month)) {
            return;
        }
        if (this.mOnMonthClickListener != null) {
            this.mOnMonthClickListener.onMonthClick(this, new YearAdapter.CalendarMonth(this.mYear, month));
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), this.getMonthHeaderSize() + this.mRowHeight * 4);
    }

    public static interface OnMonthClickListener {
        public void onMonthClick(YearView var1, YearAdapter.CalendarMonth var2);
    }
}

