/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.datetimepickers.month;

import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.olekdia.datetimepickers.IOnDateChangedListener;
import com.olekdia.datetimepickers.month.IMonthPickerController;
import com.olekdia.datetimepickers.month.YearAdapter;
import com.olekdia.datetimepickers.month.YearView;

public class YearPickerView
extends ListView
implements AbsListView.OnScrollListener,
IOnDateChangedListener {
    protected static final int GOTO_SCROLL_DURATION = 250;
    protected static final int SCROLL_CHANGE_DELAY = 40;
    public static int LIST_TOP_OFFSET = -1;
    protected float mFriction = 1.0f;
    protected Context mContext;
    protected Handler mHandler;
    protected YearAdapter.CalendarMonth mSelectedDay = new YearAdapter.CalendarMonth();
    protected YearAdapter mAdapter;
    protected YearAdapter.CalendarMonth mTempDay = new YearAdapter.CalendarMonth();
    protected int mCurrentMonthDisplayed;
    protected long mPreviousScrollPosition;
    protected int mPreviousScrollState = 0;
    protected int mCurrentScrollState = 0;
    private IMonthPickerController mController;
    protected ScrollStateRunnable mScrollStateChangedRunnable = new ScrollStateRunnable();

    public YearPickerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public YearPickerView(Context context, IMonthPickerController controller) {
        super(context);
        this.init(context);
        this.setController(controller);
    }

    public void setController(IMonthPickerController controller) {
        this.mController = controller;
        this.mController.registerOnDateChangedListener(this);
        this.refreshAdapter();
        this.onDateChanged();
    }

    public void init(Context context) {
        this.mHandler = new Handler();
        this.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -1));
        this.setDrawSelectorOnTop(false);
        this.mContext = context;
        this.setUpListView();
    }

    public void onChange() {
        this.refreshAdapter();
    }

    protected void refreshAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = this.createMonthAdapter(this.getContext(), this.mController);
        } else {
            this.mAdapter.setSelectedDay(this.mSelectedDay);
        }
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    public YearAdapter createMonthAdapter(Context context, IMonthPickerController controller) {
        return new YearAdapter(context, controller);
    }

    protected void setUpListView() {
        this.setCacheColorHint(0);
        this.setDivider(null);
        this.setItemsCanFocus(true);
        this.setFastScrollEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        this.setOnScrollListener(this);
        this.setFadingEdgeLength(0);
        this.setFriction(ViewConfiguration.getScrollFriction() * this.mFriction);
    }

    public boolean goTo(YearAdapter.CalendarMonth day, boolean animate, boolean setSelected, boolean forceScroll) {
        View child;
        if (setSelected) {
            this.mSelectedDay.set(day);
        }
        this.mTempDay.set(day);
        int position = day.year - this.mController.getMinYear();
        int i = 0;
        int top = 0;
        while ((child = this.getChildAt(i++)) != null && (top = child.getTop()) < 0) {
        }
        int selectedPosition = child != null ? this.getPositionForView(child) : 0;
        if (setSelected) {
            this.mAdapter.setSelectedDay(this.mSelectedDay);
        }
        if (position != selectedPosition || forceScroll) {
            this.setMonthDisplayed(this.mTempDay);
            this.mPreviousScrollState = 2;
            if (animate) {
                this.smoothScrollToPositionFromTop(position, LIST_TOP_OFFSET, 250);
                return true;
            }
            this.postSetSelection(position);
        } else if (setSelected) {
            this.setMonthDisplayed(this.mSelectedDay);
        }
        return false;
    }

    public void postSetSelection(final int position) {
        this.clearFocus();
        this.post(new Runnable(){

            @Override
            public void run() {
                YearPickerView.this.setSelection(position);
            }
        });
        this.onScrollStateChanged((AbsListView)this, 0);
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        YearView child = (YearView)view.getChildAt(0);
        if (child == null) {
            return;
        }
        this.mPreviousScrollPosition = view.getFirstVisiblePosition() * child.getHeight() - child.getBottom();
        this.mPreviousScrollState = this.mCurrentScrollState;
    }

    protected void setMonthDisplayed(YearAdapter.CalendarMonth date) {
        this.mCurrentMonthDisplayed = date.month;
        this.invalidateViews();
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        this.mScrollStateChangedRunnable.doScrollStateChange(view, scrollState);
    }

    public int getMostVisiblePosition() {
        View child;
        int firstPosition = this.getFirstVisiblePosition();
        int height = this.getHeight();
        int maxDisplayedHeight = 0;
        int mostVisibleIndex = 0;
        int i = 0;
        int bottom = 0;
        while (bottom < height && (child = this.getChildAt(i)) != null) {
            bottom = child.getBottom();
            int displayedHeight = Math.min(bottom, height) - Math.max(0, child.getTop());
            if (displayedHeight > maxDisplayedHeight) {
                mostVisibleIndex = i;
                maxDisplayedHeight = displayedHeight;
            }
            ++i;
        }
        return firstPosition + mostVisibleIndex;
    }

    @Override
    public void onDateChanged() {
        this.goTo(this.mController.getSelectedMonth(), false, true, true);
    }

    protected class ScrollStateRunnable
    implements Runnable {
        private int mNewState;

        protected ScrollStateRunnable() {
        }

        public void doScrollStateChange(AbsListView view, int scrollState) {
            YearPickerView.this.mHandler.removeCallbacks((Runnable)this);
            this.mNewState = scrollState;
            YearPickerView.this.mHandler.postDelayed((Runnable)this, 40L);
        }

        @Override
        public void run() {
            YearPickerView.this.mCurrentScrollState = this.mNewState;
            if (this.mNewState == 0 && YearPickerView.this.mPreviousScrollState != 0 && YearPickerView.this.mPreviousScrollState != 1) {
                YearPickerView.this.mPreviousScrollState = this.mNewState;
                int i = 0;
                View child = YearPickerView.this.getChildAt(i);
                while (child != null && child.getBottom() <= 0) {
                    child = YearPickerView.this.getChildAt(++i);
                }
                if (child == null) {
                    return;
                }
                int firstPosition = YearPickerView.this.getFirstVisiblePosition();
                int lastPosition = YearPickerView.this.getLastVisiblePosition();
                boolean scroll = firstPosition != 0 && lastPosition != YearPickerView.this.getCount() - 1;
                int top = child.getTop();
                int bottom = child.getBottom();
                int midpoint = YearPickerView.this.getHeight() / 2;
                if (scroll && top < LIST_TOP_OFFSET) {
                    if (bottom > midpoint) {
                        YearPickerView.this.smoothScrollBy(top, 250);
                    } else {
                        YearPickerView.this.smoothScrollBy(bottom, 250);
                    }
                }
            } else {
                YearPickerView.this.mPreviousScrollState = this.mNewState;
            }
        }
    }
}

