/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.datetimepickers.month;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import com.olekdia.datetimepickers.calendars.CalendarCompat;
import com.olekdia.datetimepickers.month.IMonthPickerController;
import com.olekdia.datetimepickers.month.SimpleYearView;
import com.olekdia.datetimepickers.month.YearView;
import java.util.Calendar;

public class YearAdapter
extends BaseAdapter
implements YearView.OnMonthClickListener {
    private final Context mContext;
    protected final IMonthPickerController mController;
    private CalendarMonth mSelectedMonth;

    public YearAdapter(Context context, IMonthPickerController controller) {
        this.mContext = context;
        this.mController = controller;
        this.init();
        this.setSelectedDay(this.mController.getSelectedMonth());
    }

    public void setSelectedDay(CalendarMonth day) {
        this.mSelectedMonth = day;
        this.notifyDataSetChanged();
    }

    public CalendarMonth getSelectedDay() {
        return this.mSelectedMonth;
    }

    protected void init() {
        this.mSelectedMonth = new CalendarMonth(System.currentTimeMillis());
    }

    public int getCount() {
        Calendar endDate = this.mController.getEndDate();
        Calendar startDate = this.mController.getStartDate();
        return endDate.get(1) - startDate.get(1) + 1;
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    @SuppressLint(value={"NewApi"})
    public View getView(int position, View convertView, ViewGroup parent) {
        YearView v;
        if (convertView != null) {
            v = (YearView)convertView;
        } else {
            v = this.createMonthView(this.mContext);
            AbsListView.LayoutParams params = new AbsListView.LayoutParams(-1, -1);
            v.setLayoutParams((ViewGroup.LayoutParams)params);
            v.setClickable(true);
            v.setOnDayClickListener(this);
        }
        int year = position + this.mController.getStartDate().get(2) + this.mController.getMinYear();
        v.reuse();
        v.setMonthParams(year);
        if (this.mSelectedMonth != null) {
            v.setSelectedYear(this.mSelectedMonth.year);
            v.setSelectedMonth(this.mSelectedMonth.month);
        }
        v.invalidate();
        return v;
    }

    public YearView createMonthView(Context context) {
        return new SimpleYearView(context, null, this.mController);
    }

    @Override
    public void onMonthClick(YearView view, CalendarMonth month) {
        if (month != null) {
            this.mController.onMonthSelected(month.year, month.month);
            this.mSelectedMonth.setMonth(month.year, month.month);
        }
    }

    public static class CalendarMonth {
        private Calendar calendar;
        int year;
        int month;

        public CalendarMonth() {
            this.setTime(System.currentTimeMillis());
        }

        public CalendarMonth(long timeInMillis) {
            this.setTime(timeInMillis);
        }

        public CalendarMonth(Calendar calendar) {
            this.year = calendar.get(1);
            this.month = calendar.get(2);
        }

        public CalendarMonth(int year, int month) {
            this.setMonth(year, month);
        }

        public void set(CalendarMonth date) {
            this.year = date.year;
            this.month = date.month;
        }

        public void setMonth(int year, int month) {
            this.year = year;
            this.month = month;
        }

        private void setTime(long timeInMillis) {
            if (this.calendar == null) {
                this.calendar = CalendarCompat.getInstance();
            }
            this.calendar.setTimeInMillis(timeInMillis);
            this.month = this.calendar.get(2);
            this.year = this.calendar.get(1);
        }

        public int getYear() {
            return this.year;
        }

        public int getMonth() {
            return this.month;
        }
    }
}

