/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.datetimepickers.month;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.olekdia.datetimepickers.month.IMonthPickerController;
import com.olekdia.datetimepickers.month.YearView;

public class SimpleYearView
extends YearView {
    private final RectF mSelectedRect = new RectF();

    public SimpleYearView(Context context, AttributeSet attr2, IMonthPickerController controller) {
        super(context, attr2, controller);
    }

    @Override
    public void drawYearMonth(Canvas canvas, int year, int month, float x, float y) {
        boolean isSelected = this.mSelectedMonth == month && this.mSelectedYear == year;
        boolean isCurrent = this.mCurrantMonth == month && this.mCurrantYear == year;
        String monthTitle = this.getMonthTitle(month);
        if (isSelected) {
            float rectWidth = this.mMonthTitlePaint.measureText(monthTitle, 0, monthTitle.length());
            this.mSelectedRect.set(x - rectWidth / 2.0f - this.mSelectedRectHeight, y - 2.0f * this.mSelectedRectHeight, x - rectWidth / 2.0f + rectWidth + this.mSelectedRectHeight, y + this.mSelectedRectHeight);
            canvas.drawRoundRect(this.mSelectedRect, this.mSelectedRectHeight, this.mSelectedRectHeight, this.mSelectedRectPaint);
        }
        if (isSelected) {
            this.mMonthTitlePaint.setColor(this.mSelectedMonthTextColor);
            this.mMonthTitlePaint.setTypeface(this.mDefBoldTypeface);
        } else if (isCurrent) {
            this.mMonthTitlePaint.setColor(this.mPrimaryTextColor);
            this.mMonthTitlePaint.setTypeface(this.mDefBoldTypeface);
        } else {
            this.mMonthTitlePaint.setColor(this.mSecondaryTextColor);
            this.mMonthTitlePaint.setTypeface(this.mDefNormalTypeface);
        }
        this.mMonthTitlePaint.setFakeBoldText(isSelected | isCurrent);
        canvas.drawText(monthTitle, x, y, this.mMonthTitlePaint);
    }

    public final String getMonthTitle(int month) {
        return this.mController.getMonthsOfYear()[month];
    }
}

