/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.datetimepickers.month;

import android.animation.ObjectAnimator;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import com.olekdia.androidcommon.extensions.LocaleExt;
import com.olekdia.androidcommon.extensions.MathExt;
import com.olekdia.androidcommon.extensions.ResExt;
import com.olekdia.datetimepickers.DTPickersHelper;
import com.olekdia.datetimepickers.HapticFeedbackController;
import com.olekdia.datetimepickers.IOnDateChangedListener;
import com.olekdia.datetimepickers.PickerDialog;
import com.olekdia.datetimepickers.R;
import com.olekdia.datetimepickers.calendars.CalendarCompat;
import com.olekdia.datetimepickers.date.DateAnimator;
import com.olekdia.datetimepickers.month.IMonthPickerController;
import com.olekdia.datetimepickers.month.YearAdapter;
import com.olekdia.datetimepickers.month.YearPickerView;
import com.olekdia.datetimepickers.year.YearsPickerView;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Locale;

public class MonthPickerDialog
extends PickerDialog
implements View.OnClickListener,
IMonthPickerController {
    private static final int MONTH_VIEW = 0;
    private final Calendar mCalendar = CalendarCompat.getInstance();
    private OnDateSetListener mCallBack;
    private HashSet<IOnDateChangedListener> mListeners = new HashSet();
    private DateAnimator mAnimator;
    private boolean mDelayAnimation = true;
    private LinearLayout mMonthAndYearView;
    private TextView mSelectedMonthTextView;
    private TextView mYearView;
    private YearPickerView mYearPickerView;
    private YearsPickerView mYearsPickerView;
    private int mCurrentView = -1;
    private int mDefaultView = 0;
    private int mMinYear = MathExt.roundTo((int)(this.mCalendar.get(1) - 100), (int)100);
    private int mMaxYear = MathExt.roundTo((int)(this.mCalendar.get(1) + 200), (int)100);
    private Calendar mMinDate;
    private Calendar mMaxDate;
    private Calendar[] mHighlightedMonths;
    private Calendar[] mSelectableMonths;
    private String[] mMonthsOfYear;

    public void initialize(OnDateSetListener callBack, int year, int monthOfYear) {
        this.mCallBack = callBack;
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, monthOfYear);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        FragmentActivity activity = this.getActivity();
        activity.getWindow().setSoftInputMode(3);
        this.mCurrentView = -1;
        if (savedInstanceState != null) {
            this.mCalendar.set(1, savedInstanceState.getInt("year"));
            this.mCalendar.set(2, savedInstanceState.getInt("month"));
            this.mCalendar.set(5, savedInstanceState.getInt("day"));
            this.mDefaultView = savedInstanceState.getInt("default_view");
        }
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("year", this.mCalendar.get(1));
        outState.putInt("month", this.mCalendar.get(2));
        outState.putInt("day", this.mCalendar.get(5));
        outState.putInt("year_start", this.mMinYear);
        outState.putInt("year_end", this.mMaxYear);
        outState.putStringArray("months_of_year", this.mMonthsOfYear);
        outState.putInt("current_view", this.mCurrentView);
        int listPosition = -1;
        if (this.mCurrentView == 0) {
            listPosition = this.mYearPickerView.getMostVisiblePosition();
        } else if (this.mCurrentView == 1) {
            listPosition = this.mYearsPickerView.getFirstVisiblePosition();
            outState.putInt("list_position_offset", this.mYearsPickerView.getFirstPositionOffset());
        }
        outState.putInt("list_position", listPosition);
        outState.putSerializable("min_date", (Serializable)this.mMinDate);
        outState.putSerializable("max_date", (Serializable)this.mMaxDate);
        outState.putSerializable("highlighted_days", (Serializable)this.mHighlightedMonths);
        outState.putSerializable("selectable_days", (Serializable)this.mSelectableMonths);
        outState.putInt("default_view", this.mDefaultView);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.setToNearestDate(this.mCalendar);
        View view = inflater.inflate(R.layout.mdtp_month_picker_dialog, container, false);
        this.mMonthAndYearView = (LinearLayout)view.findViewById(R.id.month_picker_month_and_year);
        this.mMonthAndYearView.setOnClickListener((View.OnClickListener)this);
        this.mSelectedMonthTextView = (TextView)view.findViewById(R.id.month_picker_month);
        this.mYearView = (TextView)view.findViewById(R.id.month_picker_year);
        this.mYearView.setOnClickListener((View.OnClickListener)this);
        int listPosition = -1;
        int listPositionOffset = 0;
        int currentView = this.mDefaultView;
        if (savedInstanceState != null) {
            this.mMonthsOfYear = savedInstanceState.getStringArray("months_of_year");
            this.mMinYear = savedInstanceState.getInt("year_start");
            this.mMaxYear = savedInstanceState.getInt("year_end");
            currentView = savedInstanceState.getInt("current_view");
            listPosition = savedInstanceState.getInt("list_position");
            listPositionOffset = savedInstanceState.getInt("list_position_offset");
            this.mMinDate = (Calendar)savedInstanceState.getSerializable("min_date");
            this.mMaxDate = (Calendar)savedInstanceState.getSerializable("max_date");
            this.mHighlightedMonths = (Calendar[])savedInstanceState.getSerializable("highlighted_days");
            this.mSelectableMonths = (Calendar[])savedInstanceState.getSerializable("selectable_days");
            this.mDefaultView = savedInstanceState.getInt("default_view");
            this.restoreInstanceState(savedInstanceState);
        }
        FragmentActivity activity = this.getActivity();
        this.mYearPickerView = new YearPickerView((Context)activity, this);
        this.mYearsPickerView = new YearsPickerView((Context)activity, this);
        if (!this.mThemeDarkChanged) {
            this.mThemeDark = DTPickersHelper.isDarkTheme((Context)activity, this.mThemeDark);
        }
        if (this.mMonthsOfYear == null) {
            this.createMonthsOfYear();
        }
        int bgColorResource = this.mThemeDark ? R.color.mdtp_date_picker_view_animator_dark_theme : R.color.mdtp_date_picker_view_animator;
        view.setBackgroundColor(ResExt.getColorCompat((Context)activity, (int)bgColorResource));
        this.mAnimator = (DateAnimator)view.findViewById(R.id.animator);
        this.mAnimator.addView((View)this.mYearPickerView);
        this.mAnimator.addView((View)this.mYearsPickerView);
        AlphaAnimation animation = new AlphaAnimation(0.0f, 1.0f);
        animation.setDuration(300L);
        this.mAnimator.setInAnimation((Animation)animation);
        AlphaAnimation animation2 = new AlphaAnimation(1.0f, 0.0f);
        animation2.setDuration(300L);
        this.mAnimator.setOutAnimation((Animation)animation2);
        TextView okButton = (TextView)view.findViewById(R.id.ok);
        okButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MonthPickerDialog.this.tryVibrate();
                MonthPickerDialog.this.notifyOnDateListener();
                MonthPickerDialog.this.dismiss();
            }
        });
        if (this.mOkString != null) {
            okButton.setText((CharSequence)this.mOkString);
        } else {
            okButton.setText(this.mOkResId);
        }
        TextView cancelButton = (TextView)view.findViewById(R.id.cancel);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MonthPickerDialog.this.tryVibrate();
                if (MonthPickerDialog.this.getDialog() != null) {
                    MonthPickerDialog.this.getDialog().cancel();
                }
            }
        });
        if (this.mCancelString != null) {
            cancelButton.setText((CharSequence)this.mCancelString);
        } else {
            cancelButton.setText(this.mCancelResId);
        }
        cancelButton.setVisibility(this.isCancelable() ? 0 : 8);
        if (this.mAccentColor == -1) {
            this.mAccentColor = DTPickersHelper.getAccentColorFromThemeIfAvailable((Context)activity);
        }
        if (this.mPrimaryColor == -1) {
            this.mPrimaryColor = DTPickersHelper.getPrimaryColorFromThemeIfAvailable((Context)activity);
        }
        okButton.setTextColor(this.mAccentColor);
        cancelButton.setTextColor(this.mAccentColor);
        view.findViewById(R.id.month_picker_selected_month_layout).setBackgroundColor(this.mPrimaryColor);
        if (this.getDialog() == null) {
            view.findViewById(R.id.done_background).setVisibility(8);
        }
        this.updateDisplay();
        this.setCurrentView(currentView);
        if (listPosition != -1) {
            if (currentView == 0) {
                this.mYearPickerView.postSetSelection(listPosition);
            } else if (currentView == 1) {
                this.mYearsPickerView.postSetSelectionFromTop(listPosition, listPositionOffset);
            }
        }
        this.mHapticFeedbackController = new HapticFeedbackController((Context)activity);
        return view;
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.requestWindowFeature(1);
        return dialog;
    }

    private void createMonthsOfYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        SimpleDateFormat formatter = new SimpleDateFormat("LLLL", Locale.getDefault());
        this.mMonthsOfYear = new String[12];
        for (int month = 0; month <= 11; ++month) {
            cal.set(2, month);
            this.mMonthsOfYear[month] = formatter.format(cal.getTime());
        }
    }

    private void setCurrentView(int viewIndex) {
        switch (viewIndex) {
            case 0: {
                ObjectAnimator pulseAnimator = DTPickersHelper.getPulseAnimator((View)this.mMonthAndYearView, 0.9f, 1.05f);
                if (this.mDelayAnimation) {
                    pulseAnimator.setStartDelay(500L);
                    this.mDelayAnimation = false;
                }
                this.mYearPickerView.onDateChanged();
                if (this.mCurrentView != viewIndex) {
                    this.mMonthAndYearView.setSelected(true);
                    this.mYearView.setSelected(false);
                    this.mAnimator.setDisplayedChild(0);
                    this.mCurrentView = viewIndex;
                }
                pulseAnimator.start();
                break;
            }
            case 1: {
                ObjectAnimator pulseAnimator = DTPickersHelper.getPulseAnimator((View)this.mYearView, 0.85f, 1.1f);
                if (this.mDelayAnimation) {
                    pulseAnimator.setStartDelay(500L);
                    this.mDelayAnimation = false;
                }
                this.mYearsPickerView.onDateChanged();
                if (this.mCurrentView != viewIndex) {
                    this.mMonthAndYearView.setSelected(false);
                    this.mYearView.setSelected(true);
                    this.mAnimator.setDisplayedChild(1);
                    this.mCurrentView = viewIndex;
                }
                pulseAnimator.start();
            }
        }
    }

    private void updateDisplay() {
        this.mSelectedMonthTextView.setText((CharSequence)this.mMonthsOfYear[this.mCalendar.get(2)]);
        this.mYearView.setText((CharSequence)LocaleExt.toLocalNumerals((int)this.mCalendar.get(1), (int)this.mNumeralSystem));
    }

    private void updatePickers() {
        for (IOnDateChangedListener listener : this.mListeners) {
            listener.onDateChanged();
        }
    }

    @Override
    public String[] getMonthsOfYear() {
        return this.mMonthsOfYear;
    }

    public final void setMonthsOfYear(String[] monthsOfYear) {
        this.mMonthsOfYear = monthsOfYear;
        if (this.mYearPickerView != null) {
            this.mYearPickerView.onChange();
        }
    }

    public void setYearRange(int startYear, int endYear) {
        if (endYear < startYear) {
            throw new IllegalArgumentException("Year end must be larger than or equal to year start");
        }
        this.mMinYear = startYear;
        this.mMaxYear = endYear;
        if (this.mYearPickerView != null) {
            this.mYearPickerView.onChange();
        }
    }

    public void setMinDate(Calendar calendar) {
        this.mMinDate = calendar;
        if (this.mYearPickerView != null) {
            this.mYearPickerView.onChange();
        }
    }

    public Calendar getMinDate() {
        return this.mMinDate;
    }

    public void setMaxDate(Calendar calendar) {
        this.mMaxDate = calendar;
        if (this.mYearPickerView != null) {
            this.mYearPickerView.onChange();
        }
    }

    public Calendar getMaxDate() {
        return this.mMaxDate;
    }

    public void setHighlightedDays(Calendar[] highlightedMonths) {
        Arrays.sort(highlightedMonths);
        this.mHighlightedMonths = highlightedMonths;
    }

    @Override
    public Calendar[] getHighlightedMonths() {
        return this.mHighlightedMonths;
    }

    public void setSelectableMonths(Calendar[] selectableMonths) {
        Arrays.sort(selectableMonths);
        this.mSelectableMonths = selectableMonths;
    }

    @Override
    public Calendar[] getSelectableMonths() {
        return this.mSelectableMonths;
    }

    public void setOnDateSetListener(OnDateSetListener listener) {
        this.mCallBack = listener;
    }

    @Override
    public YearAdapter.CalendarMonth getSelectedMonth() {
        return new YearAdapter.CalendarMonth(this.mCalendar);
    }

    @Override
    public int getSelectedYear() {
        return this.mCalendar.get(1);
    }

    @Override
    public Calendar getStartDate() {
        if (this.mSelectableMonths != null) {
            return this.mSelectableMonths[0];
        }
        if (this.mMinDate != null) {
            return this.mMinDate;
        }
        Calendar output = Calendar.getInstance();
        output.set(1, this.mMinYear);
        output.set(5, 1);
        output.set(2, 0);
        return output;
    }

    @Override
    public Calendar getEndDate() {
        if (this.mSelectableMonths != null) {
            return this.mSelectableMonths[this.mSelectableMonths.length - 1];
        }
        if (this.mMaxDate != null) {
            return this.mMaxDate;
        }
        Calendar output = Calendar.getInstance();
        output.set(1, this.mMaxYear);
        output.set(5, 31);
        output.set(2, 11);
        return output;
    }

    @Override
    public int getMinYear() {
        if (this.mSelectableMonths != null) {
            return this.mSelectableMonths[0].get(1);
        }
        return this.mMinDate != null && this.mMinDate.get(1) > this.mMinYear ? this.mMinDate.get(1) : this.mMinYear;
    }

    @Override
    public int getMaxYear() {
        if (this.mSelectableMonths != null) {
            return this.mSelectableMonths[this.mSelectableMonths.length - 1].get(1);
        }
        return this.mMaxDate != null && this.mMaxDate.get(1) < this.mMaxYear ? this.mMaxDate.get(1) : this.mMaxYear;
    }

    @Override
    public boolean isOutOfRange(int year, int month) {
        if (this.mSelectableMonths != null) {
            return !this.isSelectable(year, month);
        }
        if (this.isBeforeMin(year, month)) {
            return true;
        }
        return this.isAfterMax(year, month);
    }

    public boolean isOutOfRange(Calendar calendar) {
        return this.isOutOfRange(calendar.get(1), calendar.get(2));
    }

    private boolean isSelectable(int year, int month) {
        for (Calendar c : this.mSelectableMonths) {
            if (year < c.get(1)) break;
            if (year > c.get(1)) continue;
            if (month < c.get(2)) break;
            if (month > c.get(2)) continue;
            return true;
        }
        return false;
    }

    private boolean isBeforeMin(int year, int month) {
        if (this.mMinDate == null) {
            return false;
        }
        if (year < this.mMinDate.get(1)) {
            return true;
        }
        if (year > this.mMinDate.get(1)) {
            return false;
        }
        return month < this.mMinDate.get(2);
    }

    private boolean isBeforeMin(Calendar calendar) {
        return this.isBeforeMin(calendar.get(1), calendar.get(2));
    }

    private boolean isAfterMax(int year, int month) {
        if (this.mMaxDate == null) {
            return false;
        }
        if (year > this.mMaxDate.get(1)) {
            return true;
        }
        if (year < this.mMaxDate.get(1)) {
            return false;
        }
        return month > this.mMaxDate.get(2);
    }

    private boolean isAfterMax(Calendar calendar) {
        return this.isAfterMax(calendar.get(1), calendar.get(2));
    }

    private void setToNearestDate(Calendar calendar) {
        if (this.mSelectableMonths != null) {
            long distance = Long.MAX_VALUE;
            Calendar currentBest = calendar;
            for (Calendar c : this.mSelectableMonths) {
                long newDistance = Math.abs(calendar.getTimeInMillis() - c.getTimeInMillis());
                if (newDistance >= distance) break;
                distance = newDistance;
                currentBest = c;
            }
            calendar.setTimeInMillis(currentBest.getTimeInMillis());
            return;
        }
        if (this.isBeforeMin(calendar)) {
            calendar.setTimeInMillis(this.mMinDate.getTimeInMillis());
            return;
        }
        if (this.isAfterMax(calendar)) {
            calendar.setTimeInMillis(this.mMaxDate.getTimeInMillis());
            return;
        }
    }

    @Override
    public void registerOnDateChangedListener(IOnDateChangedListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void unregisterOnDateChangedListener(IOnDateChangedListener listener) {
        this.mListeners.remove(listener);
    }

    public void notifyOnDateListener() {
        if (this.mCallBack != null) {
            this.mCallBack.onDateSet(this, this.mCalendar.get(1), this.mCalendar.get(2));
        }
    }

    public void onClick(View v) {
        this.tryVibrate();
        if (v.getId() == R.id.month_picker_year) {
            this.setCurrentView(1);
        } else if (v.getId() == R.id.month_picker_month_and_year) {
            this.setCurrentView(0);
        }
    }

    @Override
    public void onYearSelected(int year) {
        this.mCalendar.set(1, year);
        this.updatePickers();
        this.setCurrentView(0);
        this.updateDisplay();
    }

    @Override
    public void onMonthSelected(int year, int month) {
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, month);
        this.mCalendar.set(5, 1);
        this.updatePickers();
        this.updateDisplay();
        if (this.mAutoDismiss) {
            this.notifyOnDateListener();
            this.dismiss();
        }
    }

    public static interface OnDateSetListener {
        public void onDateSet(MonthPickerDialog var1, int var2, int var3);
    }
}

