/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.datetimepickers.date;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import com.olekdia.androidcommon.extensions.LocaleExt;
import com.olekdia.datetimepickers.date.IDatePickerController;
import com.olekdia.datetimepickers.date.MonthView;

public class SimpleMonthView
extends MonthView {
    public SimpleMonthView(Context context, AttributeSet attr2, IDatePickerController controller) {
        super(context, attr2, controller);
    }

    @Override
    public void drawMonthDay(Canvas canvas, int year, int month, int day, int x, int y, int startX, int stopX, int startY, int stopY) {
        if (this.mSelectedDay == day) {
            canvas.drawCircle((float)x, (float)(y - this.mMiniDayNumberTextSize / 3), (float)this.mDaySelectedCircleSize, this.mSelectedCirclePaint);
        }
        if (this.mController.isOutOfRange(year, month, day)) {
            this.mMonthNumPaint.setColor(this.mDisabledDayTextColor);
            this.mMonthNumPaint.setTypeface(this.mDefNormalTypeface);
            this.mMonthNumPaint.setFakeBoldText(false);
        } else if (this.mSelectedDay == day) {
            this.mMonthNumPaint.setTypeface(this.mDefBoldTypeface);
            this.mMonthNumPaint.setColor(this.mSelectedDayTextColor);
            this.mMonthNumPaint.setFakeBoldText(true);
        } else if (this.mHasToday && this.mToday == day) {
            this.mMonthNumPaint.setColor(this.mPrimaryTextColor);
            this.mMonthNumPaint.setFakeBoldText(true);
            this.mMonthNumPaint.setTypeface(this.mDefBoldTypeface);
        } else {
            boolean isHighlighted = this.isHighlighted(year, month, day);
            this.mMonthNumPaint.setColor(isHighlighted ? this.mHighlightedDayTextColor : this.mSecondaryTextColor);
            this.mMonthNumPaint.setTypeface(isHighlighted ? this.mDefBoldTypeface : this.mDefNormalTypeface);
            this.mMonthNumPaint.setFakeBoldText(false);
        }
        canvas.drawText(LocaleExt.toLocalNumerals((int)day, (int)this.mController.getNumeralSystem()), (float)x, (float)y, this.mMonthNumPaint);
    }
}

